//index.js
//获取应用实例
const app = getApp()

Page({
  data: {
    web: app.globalData.web,
    url: app.globalData.url,
    h_t: wx.getSystemInfoSync().windowHeight,
    to: '0',
    ok: false
  },
  onLoad: function (options) {
    this.setData({
      ok: app.globalData.ok
    })
    wx.setNavigationBarTitle({
      title: app.globalData.web
    })
    if (options.scene) {
      let s = decodeURIComponent(options.scene).split('&')[0]
      s = s.split('=')
      if (s[0] == 'fr') options['fr'] = s[1]
    }
    if (options.fr) {
      let c = options.fr.split('_')
      if (c.length == 2) {
        this.setData({
          to: c[1]
        })
        app.xhr({
          act: 'from',
          from: c[0]
        }, function (r) {})
      }
    }
    this.login()
  },
  login: function () {
    let that = this
    if (app.globalData.ok) {
      this.setData({
        ok: true
      })
      this.index()
    } else {
      setTimeout(function () {
        that.login()
      }, 100)
    }
  },
  index: function () {
    let c = this.data.to
    if (this.data.ok) wx.navigateTo({
      url: c == '0' ? '../main/main' : '../item/item?id=' + c,
    })
  }
})