// pages/item/item.js
const app = getApp()
Page({
  data: {
    web: app.globalData.web,
    url: app.globalData.url,
    cfg: app.globalData.cfg,
    id: 0,
    goods: [],
    exfee: [],
    review: [],
    coupon: [],
    best: {},
    h_msk: 0,
    addr: false,
    adrpc: '未知地区',
    adrfe: '??',
    goto: 0
  },
  onLoad: function (options) {
    let that = this;
    wx.getStorage({
      key: 'addr',
      success(res) {
        that.setData({
          addr: res.data
        })
      }
    })
    that.setData({
      id: options.id || 0
    })
    app.xhr({
      act: 'item',
      id: that.data.id
    }, function (r) {
      wx.setNavigationBarTitle({
        title: r.goods.Nm + ' - ' + app.globalData.web
      })
      let c = r.goods.Nb;
      for (let i = 0; i < c.length; i++) c[i] = [c[i], c[i].substr(-4).toLowerCase() == '.mp4']
      r.goods.Nb = c;
      that.setData({
        goods: r.goods,
        exfee: r.exfee,
        review: r.review,
        coupon: r.coupon,
        best: r.best,
        more: r.more
      })
      let m = 0;
      let n = 0;
      for (let i = 0; i < r.coupon.length; i++) {
        if (m < r.coupon[i].Nm * 1) {
          m = r.coupon[i].Nm;
          n = r.coupon[i].Nk
        }
      }
      let e = r.goods.Nr.split('/');
      let w = e[1] == '0' ? 5 : Math.round(e[0] * 100 / e[1]) / 100;
      let d = 0;
      let f = [];
      let h = [];
      let o = '';
      for (let i in r.goods.Nx.n) {
        h[d] = {
          n: i,
          m: r.goods.Nx.n[i]
        };
        d++;
        f.push(i);
        o += '-';
      }
      for (let i = 0; i < h.length; i++) {
        for (let j = 0; j < h[i].m.length; j++) {
          h[i].m[j] = [i == 0 && r.goods.Nx.m['m_' + ('0123456789abcdefghijklmnopqrstuvwxyz'.substr(j, 1))] ? r.goods.Nx.m['m_' + ('0123456789abcdefghijklmnopqrstuvwxyz'.substr(j, 1))] : false, h[i].m[j], 0];
        }
      }
      that.setData({
        cpnmny: m / 100,
        cpnmin: n / 100,
        revfen: w,
        gds_nx: h,
        gds_ns: f.join(','),
        sel_p: r.goods.Ni[0],
        sel_m: r.goods.Np,
        sel_k: r.goods.Nk,
        sel_c: 1,
        sel_o: o
      })
      that.setAddr()
    });
  },
  fadeIO: function (obj, io) {
    this.setData(JSON.parse('{"d_' + obj + '":"block"}'))
    this.setData({
      d_msk: "block",
      h_msk: wx.getSystemInfoSync().windowHeight
    })
    let ao = wx.createAnimation({
      duration: 500,
      timingFunction: 'ease',
      delay: 0
    });
    ao.opacity(io ? 1 : 0).translateY(io ? 0 : 100).step()
    let am = wx.createAnimation({
      duration: 500,
      timingFunction: 'ease',
      delay: 0
    });
    am.opacity(io ? 0.3 : 0).step()
    let jo = JSON.parse('{"' + obj + '":""}')
    jo[obj] = ao.export()
    jo.msk = am.export()
    this.setData(jo)
    if (!io) {
      let that = this
      setTimeout(function () {
        that.setData(JSON.parse('{"d_' + obj + '":"none","h_msk":0}'))
      }, 550)
    }
  },
  selType: function (e) {
    let nx = e.currentTarget.dataset['nx'].split('-')
    let n = this.data.gds_nx;
    let d = this.data.goods;
    let p = '';
    let m = -1;
    let t = [];
    for (let i = 0; i < n[nx[0]].m.length; i++) n[nx[0]].m[i][2] = 0
    n[nx[0]].m[nx[1]][2] = 1
    for (let i = 0; i < n.length; i++) {
      let c = -1;
      for (let j = 0; j < n[i].m.length; j++) {
        if (n[i].m[j][2] == 1) {
          c = j;
          t.push('"' + n[i].n + '"');
        }
      }
      if (c > -1) {
        p += '0123456789abcdefghijklmnopqrstuvwxyz'.substr(c, 1)
        if (i == 0) m = c
      } else p += '-'
    }
    this.setData({
      gds_nx: n,
      sel_p: d.Nx.m['m_' + ('0123456789abcdefghijklmnopqrstuvwxyz'.substr(m, 1))] || d.Ni[0],
      sel_t: t.join(','),
      sel_k: d.Nx.k['k_' + p] || '0',
      sel_m: d.Nx.p['p_' + p] || d.Np,
      sel_o: p
    })
  },
  cntType: function (e) {
    let c = e.currentTarget.dataset['ct']
    let d = this.data.sel_c + c * 1;
    if (d < 1) d = 1;
    this.setData({
      sel_c: d
    })
  },
  navGoto: function () {
    if (this.data.sel_k * 1 == 0) {
      app.alt('所选商品或型号规格库存不足')
      return;
    }
    if (this.data.goto == '0') this.hideGnx()
    if (this.data.goto == '1') this.addCart()
    if (this.data.goto == '2') this.toOrder()
  },
  toOrder: function () {
    wx.navigateTo({
      url: '../order/order?s=[["' + this.data.id + '","' + this.data.sel_o + '",' + this.data.sel_c + ']]'
    })
  },
  addCart: function () {
    if (!this.data.exfee) {
      app.alt('虚拟商品不支持添加购物车，请直接下单购买！')
      return
    }
    let n = this.data.gds_nx
    if (n.length > 0) {
      let a = this.data.sel_o.indexOf('-')
      if (a > -1) {
        app.alt('请选择 ' + n[a].n)
        return;
      }
    }
    let that = this
    app.xhr({
      act: 'crta',
      Ns: this.data.id + '_' + this.data.sel_o,
      Nc: this.data.sel_c
    }, function (r) {
      app.alt('添加购物车成功', 1)
      if (n.length > 0) that.hideGnx()
    })
  },
  showGnx: function (e) {
    this.data.goto = e.currentTarget.dataset['to']
    if (this.data.gds_nx.length == 0) {
      this.navGoto()
    } else this.fadeIO('gnx', 1)
  },
  hideGnx: function () {
    this.fadeIO('gnx', 0)
  },
  showCpn: function () {
    this.fadeIO('cpn', 1)
  },
  hideCpn: function () {
    this.fadeIO('cpn', 0)
  },
  showShr: function () {
    this.fadeIO('shr', 1)
  },
  hideShr: function () {
    this.fadeIO('shr', 0)
  },
  codeShr: function () {
    wx.previewImage({
      urls: [this.data.url + 'wxcode.php?u=' + app.globalData.uid + '_' + this.data.id + '&p=' + this.data.goods.Ni[0] + '&t=' + encodeURI(app.globalData.www) + '&k=' + encodeURI(this.data.goods.Nm) + '&b=' + encodeURI('长按保存图片 微信扫码识别')]
    })
  },
  selAddr: function () {
    let that = this
    wx.chooseAddress({
      success(res) {
        let ad = {}
        ad.p = res.provinceName
        ad.c = res.cityName
        ad.a = res.countyName
        ad.d = res.detailInfo
        ad.m = res.userName
        ad.n = res.telNumber
        wx.setStorage({
          key: "addr",
          data: ad
        })
        that.setData({
          addr: ad
        })
        that.setAddr()
      }
    })
  },
  setAddr: function () {
    let ad = this.data.addr
    if (!ad || !this.data.exfee) return;
    let Nw = this.data.goods.Nw
    let Np = this.data.goods.Np
    let Nf = this.data.exfee
    let p = ad.p.replace('省', '').replace('市', '').replace('自治区', '').replace('壮族', '').replace('回族', '').replace('维吾尔', '')
    let c = p + ad.c.replace('市', '')
    let f = 9999;
    let w = Math.ceil(Nw * 1);
    if (w <= 0) w = Nf.Ns;
    let v = w - Nf.Ns;
    if (v < 0) v = 0;
    f = Nf[p].s * 1 + Math.ceil(v / Nf.Nc) * Nf[p].c;
    if (Nf[p].b == 1) f = 0;
    if (Np.split('-')[0] * 1 > Nf.Nb) f = 0;
    if (Nf[p].d == 1) f = 9999;
    this.setData({
      adrpc: c,
      adrfe: f
    })
  },
  addFavi: function () {
    app.xhr({
      act: 'fava',
      ID: this.data.id
    }, function (r) {
      app.alt('添加收藏夹成功', 1)
    })
  },
  takeCpn: function (e) {
    app.xhr({
      act: 'cpna',
      ID: e.currentTarget.dataset['id']
    }, function (r) {
      app.alt('领取优惠券成功', 1)
    })
  },
  navHome: function () {
    wx.reLaunch({
      url: '../main/main'
    })
  },
  navRevw: function () {
    wx.navigateTo({
      url: '../revw/revw?id=' + this.data.id + '&m=' + this.data.goods.Nm + '&n=' + this.data.goods.Ni[0]
    })
  },
  navItem: function (e) {
    wx.navigateTo({
      url: '../item/item?id=' + e.currentTarget.dataset['id']
    })
  },
  onShareAppMessage: function (options) {
    return {
      title: '[' + app.globalData.www + ']' + this.data.goods.Nm,
      path: '/pages/index/index?fr=' + app.globalData.uid + '_' + this.data.id,
      imageUrl: app.globalData.url + this.data.goods.Ni[0],
      success: function (res) {
        app.alt('分享成功', 1)
      },
      fail: function (res) {},
      complete: function (res) {}
    }
  }
})