// pages/list/list.js
const app = getApp()

Page({
  data: {
    web: app.globalData.web,
    url: app.globalData.url,
    class: [],
    cls: 0,
    sub: false,
    subi: 0,
    subx: 0,
    suby: 0,
    list: [],
    id: 0,
    qr: '',
    qry: '',
    pg: 1,
    pt: 0,
    pe: '正在加载数据......',
    pl: false
  },
  onLoad: function(options) {
    wx.setNavigationBarTitle({
      title: app.globalData.web
    })
    this.setData({
      id: options.id || 0,
      qr: options.qr || ''
    })
    this.loadList()
  },
  loadList: function() {
    if (this.data.pl) return;
    let that = this;
    this.setData({
      pe: '正在加载数据......',
      pl: true
    })
    app.xhr({
      act: 'list',
      id: that.data.id,
      qr: that.data.qr,
      pg: that.data.pg
    }, function(r) {
      let c = that.data.list
      for (let i = 0; i < r.list.length; i++) c.push(r.list[i])
      that.setData({
        class: r.class,
        list: c,
        pt: r.page * 1,
        pg: that.data.pg + 1,
        pl: false,
        pe: that.data.pg >= r.page * 1 ? '------ 我是有底线的 ------' : '正在加载数据......'
      })
    });
  },
  showClass: function(e) {
    let that = this
    let id = e.currentTarget.dataset['id'];
    let oh = e.currentTarget.dataset['oh'];
    if (id * 1 == 0) {
      this.setData({
        cls: 1 - this.data.cls
      })
      setTimeout(function() {
        let query = wx.createSelectorQuery();
        query.select('#cls').boundingClientRect();
        query.exec(function(rect) {
          if (rect[0] === null) return;
          that.setData({
            subx: rect[0].width + 8
          })
        });
      }, 500)
    } else {
      let c = [];
      for (let i = 0; i < this.data.class.length; i++) {
        if (id * 1 == this.data.class[i].Np) c.push(this.data.class[i])
      }
      this.setData({
        sub: c,
        subi: id,
        suby: 80 + oh * 73
      })
    }
    if (this.data.cls == 0) this.setData({
      sub: false
    })
  },
  naviToItem: function(e) {
    wx.navigateTo({
      url: '../item/item?id=' + e.currentTarget.dataset['id']
    })
  },
  naviToList: function(e) {
    wx.navigateTo({
      url: '../list/list?id=' + e.currentTarget.dataset['id']
    })
  },
  naviToSrch: function(e) {
    if (this.data.qry != '') wx.navigateTo({
      url: '../list/list?qr=' + this.data.qry
    })
  },
  naviToCart: function() {
    wx.navigateTo({
      url: '../cart/cart'
    })
  },
  naviToUser: function() {
    wx.navigateTo({
      url: '../user/user'
    })
  },
  qryText: function(e) {
    this.setData({
      qry: e.detail.value
    })
  },
  onReachBottom: function() {
    if (this.data.pt >= this.data.pg) this.loadList()
  }
})