// pages/order/order.js
const app = getApp()
Page({
  data: {
    url: app.globalData.url,
    cfg: app.globalData.cfg,
    tpl: app.globalData.tpl,
    tplid: [],
    addr: {},
    adok: 0,
    goods: [],
    total: 0,
    odrok: 1,
    pmode: 0,
    pdisa: false,
    d_pay: 'none',
    h_msk: 0,
    qp: '取消'
  },
  onLoad: function (options) {
    wx.setNavigationBarTitle({
      title: '确认订单 - ' + app.globalData.web
    })
    let that = this;
    wx.getStorage({
      key: 'addr',
      success(res) {
        that.setData({
          addr: res.data,
          adok: 1
        })
      }
    })
    this.setData({
      pmode: app.globalData.cfg.Fd,
      pdisa: app.globalData.cfg.Fd == 1,
      cart: options.c || '0'
    })
    app.xhr({
      act: 'odrc',
      s: JSON.parse(options.s)
    }, function (r) {
      let h = r.goods
      for (let i = 0; i < h.length; i++) {
        let c = JSON.parse(options.s)[i]
        h[i].Nb = ''
        if (h[i].Ix != '') h[i].Nk = h[i].Nx.k['k_' + c[1]]
        let d = []
        let j = 0
        if (JSON.stringify(h[i].Nx.n) != '{}') {
          for (let b in h[i].Nx.n) {
            d.push(b + ':' + h[i].Nx.n[b]['0123456789abcdefghijklmnopqrstuvwxyz'.indexOf(c[1].substr(j, 1))])
            if (j == 0 && h[i].Nx.m['m_' + c[1].substr(0, 1)]) h[i].Ni = h[i].Nx.m['m_' + c[1].substr(0, 1)]
            if (h[i].Nx.p['p_' + c[1]]) h[i].Np = h[i].Nx.p['p_' + c[1]]
            j++;
          }
          h[i].Nt = d.join(',')
        }
      }
      r.coupon['0'] = {
        ID: 0,
        Nn: '不使用',
        Nm: 0,
        Nk: 0,
        Ns: '2020-01-01',
        Ne: '2099-12-31',
        Ng: ''
      }
      that.setData({
        goods: h,
        exfee: r.exfee,
        coupon: r.coupon,
        date: r.date
      })
      that.exOrder()
    })
  },
  fadeIO: function (obj, io) {
    this.setData(JSON.parse('{"d_' + obj + '":"block"}'))
    this.setData({
      d_msk: "block",
      h_msk: wx.getSystemInfoSync().windowHeight
    })
    let ao = wx.createAnimation({
      duration: 500,
      timingFunction: 'ease',
      delay: 0
    });
    ao.opacity(io ? 1 : 0).translateY(io ? 0 : 100).step()
    let am = wx.createAnimation({
      duration: 500,
      timingFunction: 'ease',
      delay: 0
    });
    am.opacity(io ? 0.3 : 0).step()
    let jo = JSON.parse('{"' + obj + '":""}')
    jo[obj] = ao.export()
    jo.msk = am.export()
    this.setData(jo)
    if (!io) {
      let that = this
      setTimeout(function () {
        that.setData(JSON.parse('{"d_' + obj + '":"none","h_msk":0}'))
      }, 550)
    }
  },
  exOrder: function () {
    if (!this.data.exfee) {
      this.setData({
        addr: {
          d: '虚拟商品，自动发货，无需配送',
          p: '',
          c: '',
          a: '',
          m: '　',
          n: ''
        },
        adok: 1,
        pmode: 0,
        pdisa: true
      })
    }
    if (!this.data.adok) {
      app.alt('请选择收货地址')
      return;
    }
    let c = this.data.addr.p.replace('省', '').replace('市', '').replace('自治区', '').replace('壮族', '').replace('回族', '').replace('维吾尔', '')
    let h = this.data.coupon;
    for (let i in h) h[i].Nt = 0
    let f = this.data.exfee;
    if (f) {
      for (let i in f) {
        f[i].Nw = 0 //重量
        f[i].Nc = 0 //商品
        f[i].Ns = 0 //运费
      }
    }
    let b = this.data.goods;
    let v = this.data.date;
    for (let i = 0; i < b.length; i++) {
      if (f) f[b[i].Nf].Nw += b[i].Nw * 1 * b[i].Nc
      if (f) f[b[i].Nf].Nc += Math.round(b[i].Np * 100 * b[i].Nc)
      for (let j in h) {
        if (v >= h[j].Ns && v <= h[j].Ne && (h[j].Ng == '' || ('A,' + h[j].Ng + ',').indexOf(',' + b[i].ID + ',') > 0)) {
          h[j].Nt += Math.round(b[i].Np * 100 * b[i].Nc)
        }
      }
    }
    let l = [];
    let q = [];
    let k = 0
    let t = 0
    let d = 0
    for (let j in h) {
      if (h[j].Nt >= h[j].Nk * 1) {
        l.push(h[j].Nn + '：' + (h[j].Nm / 100) + '元')
        q.push(j)
        if (t < h[j].Nm * 1) {
          t = h[j].Nm * 1
          d = k
        }
        k++
      }
    }
    k = 1
    let t0 = 0
    let t1 = 0
    if (f) {
      for (let i in f) {
        let w = f[i].Nw - f[i].Np.Ns * 1
        if (w <= 0) w = 0
        w = Math.ceil(w / f[i].Np.Nc)
        let s = Math.round(f[i].Np[c].s * 100 + f[i].Np[c].c * 100 * w)
        if (f[i].Np[c].b == 1 || Math.round(f[i].Np.Nb * 100) <= f[i].Nc) s = 0
        if (f[i].Np[c].d) {
          s = -1
          k = 0
        }
        f[i].Ns = s
        if (s > 0) t1 += s
      }
    }
    for (let i = 0; i < b.length; i++) {
      b[i].Ns = f ? (f[b[i].Nf].Ns < 0 ? '不支持配送至当前地址' : (f[b[i].Nf].Nm + '：' + (f[b[i].Nf].Ns / 100) + '元')) : '无需配送'
      t0 += Math.round(b[i].Np * b[i].Nc * 100)
    }
    this.setData({
      exfee: f,
      goods: b,
      feegd: Math.round(t0) / 100,
      feeex: Math.round(t1) / 100,
      total: Math.round(t0 + t1 - (q.length == 0 ? 0 : h[q[d]].Nm) * 1) / 100,
      order: k,
      coupon: h,
      cpnar: l,
      cpnid: q,
      cpnix: d
    })
  },
  adOrder: function (e) {
    let i = e.currentTarget.dataset['ci']
    let b = e.currentTarget.dataset['ad']
    let c = this.data.goods
    c[i].Nc += b * 1;
    if (c[i].Nc < 1) c[i].Nc = 1
    if (c[i].Nc > c[i].Nk * 1) {
      c[i].Nc = c[i].Nk * 1
      app.alt('商品或规格型号库存不足')
    }
    this.setData({
      goods: c
    })
    this.exOrder()
  },
  bzOrder: function (e) {
    let i = e.currentTarget.dataset['ci']
    let c = this.data.goods
    c[i].Nb = e.detail.value
    this.setData({
      goods: c
    })
  },
  selAddr: function () {
    if (!this.data.exfee) return
    let that = this
    wx.chooseAddress({
      success(res) {
        let ad = {}
        ad.p = res.provinceName || false
        ad.c = res.cityName || false
        ad.a = res.countyName || false
        ad.d = res.detailInfo || false
        ad.m = res.userName || false
        ad.n = res.telNumber || false
        if (ad.p && ad.c && ad.a && ad.d && ad.m && ad.n) {
          wx.setStorage({
            key: "addr",
            data: ad
          })
          that.setData({
            addr: ad,
            adok: 1
          })
          that.exOrder()
        } else app.alt('请填写收货人名称、电话、详细地址！')
      }
    })
  },
  sCoupon: function (e) {
    this.setData({
      cpnix: e.detail.value,
      total: Math.round(this.data.feegd * 100 + this.data.feeex * 100 - (this.data.cpnid == 0 ? 0 : this.data.coupon[this.data.cpnid[e.detail.value]].Nm) * 1) / 100
    })
  },
  setMode: function () {
    this.setData({
      pmode: 1 - this.data.pmode
    })
  },
  toOrder: function () {
    let c = this.data.goods;
    let d = [];
    for (let i = 0; i < c.length; i++) {
      if (c[i].Nk * 1 < c[i].Nc * 1) {
        app.alt('有商品缺货，请重新选择')
        return
      } else d.push([c[i].ID, c[i].Ix, c[i].Nc, c[i].Nb, c[i].Ni])
    }
    if (!this.data.adok) {
      app.alt('请选择收货地址')
      return;
    }
    let that = this
    wx.requestSubscribeMessage({
      tmplIds: [that.data.tpl[0], that.data.tpl[1]],
      success: function (res) {},
      complete: function (res) {
        wx.showLoading({
          title: '正在下单......'
        })
        app.xhr({
          act: 'odrs',
          Ms: d,
          Md: that.data.exfee ? that.data.addr : false,
          Mh: that.data.cpnid[that.data.cpnix],
          Mb: that.data.pmode,
          Mc: that.data.cart
        }, function (r) {
          wx.hideLoading()
          if (that.data.pmode) {
            wx.redirectTo({
              url: '../user/user'
            })
          } else {
            let e = r.pay - r.cpn - r.yue;
            wx.showModal({
              title: '下单成功',
              content: '订单金额：' + (r.pay / 100) + '元\r\n优惠金额：' + (r.cpn / 100) + '元\r\n账户余额：' + (r.yue / 100) + '元\r\n应付金额：' + ((e < 0 ? 0 : e) / 100) + '元',
              confirmText: '立即支付',
              success(res) {
                if (res.confirm) {
                  that.wxPay(r.oid)
                }
                if (res.cancel) {
                  wx.redirectTo({
                    url: '../user/user'
                  })
                }
              }
            })
          }
        })
      }
    })
  },
  wxPay: function (o) {
    let that = this
    app.xhr({
      act: 'code',
      id: o
    }, function (r) {
      if (r.pay == 1) {
        wx.redirectTo({
          url: '../user/user'
        })
      } else {
        if (that.data.cfg.Fs == 0) {
          that.setData({
            qp: '取消'
          })
          that.fadeIO('pay', 1, 1)
          return
        }
        if (r.err == 0) {
          wx.requestPayment({
            timeStamp: r.tsp,
            nonceStr: r.rnd,
            package: 'prepay_id=' + r.qrc,
            signType: 'MD5',
            paySign: r.sgn,
            success(res) {
              wx.redirectTo({
                url: '../user/user'
              })
            },
            fail(res) {
              wx.redirectTo({
                url: '../user/user'
              })
            }
          })
        } else {
          app.alt(r.err)
          setTimeout(function () {
            wx.redirectTo({
              url: '../user/user'
            })
          }, 2000)
        }
      }
    })
  },
  hdPay: function () {
    wx.redirectTo({
      url: '../user/user'
    })
  },
  exPay: function () {
    this.setData({
      qp: '完成'
    })
  }
})