// pages/revw/revw.js
const app = getApp()
Page({
  data: {
    web: app.globalData.web,
    url: app.globalData.url,
    revw: [],
    pg: 1,
    pt: 0,
    pe: '正在加载数据......',
    pl: false
  },
  onLoad: function (options) {
    wx.setNavigationBarTitle({
      title: '商品评价 - ' + app.globalData.web
    })
    this.setData({
      id: options.id,
      gdsm: options.m,
      gdsn: options.n
    })
    this.loadRevw()
  },
  loadRevw: function () {
    if (this.data.pl) return;
    let that = this;
    this.setData({
      pe: '正在加载数据......',
      pl: true
    })
    app.xhr({
      act: 'revw',
      id: that.data.id,
      pg: that.data.pg
    }, function (r) {
      let c = that.data.revw
      for (let i = 0; i < r.revw.length; i++) c.push(r.revw[i])
      that.setData({
        revw: c,
        pt: r.page * 1,
        pg: that.data.pg + 1,
        pl: false,
        pe: that.data.pg >= r.page * 1 ? '------ 我是有底线的 ------' : '正在加载数据......'
      })
    });
  },
  viewImgs: function (e) {
    let c = this.data.revw[e.currentTarget.dataset['id']].Np
    let s = []
    for (let i = 0; i < c.length; i++) s.push(this.data.url + c[i])
    wx.previewImage({
      current: e.currentTarget.dataset['ix'],
      urls: s
    })
  },
  onReachBottom: function () {
    if (this.data.pt >= this.data.pg) this.loadRevw()
  }
})