// pages/user/user.js
const app = getApp()
Page({
  data: {
    web: app.globalData.web,
    url: app.globalData.url,
    tpl: app.globalData.tpl,
    user: {},
    text: {},
    h_msk: 0,
    rand: '',
    order: [],
    pg: 1,
    pt: 0,
    pe: '正在加载数据......',
    pl: false,
    oi: -1,
    qp: '取消'
  },
  onLoad: function (options) {
    wx.setNavigationBarTitle({
      title: '会员中心 - ' + app.globalData.web
    })
    let that = this
    app.xhr({
      act: 'user'
    }, function (r) {
      let c = 0
      for (let i in r.user.Nk) c++;
      r.user.Nk = c
      that.setData({
        user: r.user,
      })
      that.loadOdr()
    })
  },
  showOdr: function (e) {
    let c = e.currentTarget.dataset['ci'];
    this.setData({
      pg: 1,
      oi: c,
      order: []
    })
    this.loadOdr()
  },
  loadOdr: function () {
    if (this.data.pl) return;
    let that = this
    this.setData({
      pe: '正在加载数据......',
      pl: true,
      rand: app.globalData.sid
    })
    app.xhr({
      act: 'olst',
      nt: that.data.oi,
      pg: that.data.pg
    }, function (r) {
      let c = that.data.order
      for (let i = 0; i < r.order.length; i++) c.push(r.order[i])
      that.setData({
        order: c,
        pt: r.page * 1,
        pg: that.data.pg + 1,
        pl: false,
        pe: that.data.pg >= r.page * 1 ? '------ 我是有底线的 ------' : '正在加载数据......'
      })
    })
  },
  actsOdr: function (e) {
    let c = e.currentTarget.dataset['act'].split('-')
    let i = this.data.order[c[1]].ID * 1
    let n = this.data.order[c[1]].Nn * 1
    let that = this;
    switch (c[0]) {
      case 'p':
        this.toPay(c[1]);
        break;
      case 'c':
        this.odrStat(i, 7)
        break;
      case 't':
        this.odrStat(i, 1)
        break;
      case 'v':
        this.odrStat(i, 2)
        break;
      case 'w':
        this.odrStat(i, n ? 7 : 3)
        break;
      case 'x':
        if (n) {
          app.alt('此为货到付款订单，由商家确认收货！')
        } else this.odrStat(i, 8)
        break;
      case 'n':
        this.odrExpn(c[1])
        break;
      case 'm':
        this.odrExpm(c[1])
        break;
      case 'e':
        if (n) {
          app.alt('此为货到付款订单，请签收时仔细检查商品！如对商品质量不满意，请在签收时当场拒收！')
        } else this.odrRefd(c[1])
        break
      case 'f':
        this.odrFtex(c[1])
        break;
      case 'r':
        this.odrRevw(c[1])
        break;
      case 'k':
        this.odrKami(c[1])
        break;
      default:
    }
  },
  toPay: function (n) {
    let that = this
    let p = that.data.order[n].Nm * 1 + that.data.order[n].Nf * 1
    let b = that.data.order[n].Nb * 1 + Math.floor((p - that.data.order[n].Nb * 1) * (that.data.user.Nv * 1 == 1 ? app.globalData.cfg.Md : 0) / 100)
    let c = p - b - that.data.user.Ne * 1;
    c = c < 0 ? 0 : c;
    wx.showModal({
      title: '下单成功',
      content: '订单金额：' + (p / 100) + '元\r\n优惠金额：' + (b / 100) + '元\r\n账户余额：' + (that.data.user.Ne / 100) + '元\r\n应付金额：' + (c / 100) + '元',
      confirmText: '立即支付',
      success(res) {
        if (res.confirm) {
          wx.requestSubscribeMessage({
            tmplIds: [that.data.tpl[0], that.data.tpl[1]],
            success: function (res) {},
            complete: function (res) {
              that.wxPay(that.data.order[n].Ni)
            }
          })
        }
      }
    })
  },
  wxPay: function (o) {
    let that = this
    app.xhr({
      act: 'code',
      id: o
    }, function (r) {
      if (r.pay == 1) {
        wx.redirectTo({
          url: '../user/user'
        })
      } else {
        if (that.data.cfg.Fs == 0) {
          if (that.data.d_ctx == 'block') that.setData({
            d_ctx: 'none'
          })
          that.fadeIO('pay', 1, 1)
          return
        }
        if (r.err == 0) {
          wx.requestPayment({
            timeStamp: r.tsp,
            nonceStr: r.rnd,
            package: 'prepay_id=' + r.qrc,
            signType: 'MD5',
            paySign: r.sgn,
            success(res) {
              wx.redirectTo({
                url: '../user/user'
              })
            },
            fail(res) {
              wx.redirectTo({
                url: '../user/user'
              })
            }
          })
        } else app.alt(r.err)
      }
    })
  },
  showInf: function (e) {
    this.setData({
      odri: this.data.order[e.currentTarget.dataset['oi']]
    })
    this.fadeIO('inf', 1);
  },
  hideInf: function () {
    this.fadeIO('inf', 0)
  },
  odrKami: function (n) {
    let c = JSON.stringify(this.data.order[n])
    c = JSON.parse(c)
    for (let i = 0; i < c.Nr.length; i++) c.Nr[i] = c.Nr[i].split(',')
    this.setData({
      odri: c
    })
    this.fadeIO('knp', 1);
  },
  hideKnp: function () {
    this.fadeIO('knp', 0)
  },
  odrRevw: function (n) {
    let c = JSON.stringify(this.data.order[n].Ns)
    c = JSON.parse(c)
    for (let i = 0; i < c.length; i++) {
      c[i].f = 0
      c[i].r = ''
      c[i].v = []
      c[i].x = []
    }
    this.setData({
      odrr: c,
      reid: this.data.order[n].ID
    })
    this.fadeIO('rvw', 1);
  },
  odrRevf: function (e) {
    let d = this.data.odrr
    d[e.currentTarget.dataset['ci']].f = e.currentTarget.dataset['fi']
    this.setData({
      odrr: d
    })
  },
  odrRevr: function (e) {
    let d = this.data.odrr
    d[e.currentTarget.dataset['ci']].r = e.detail.value
    this.setData({
      odrr: d
    })
  },
  odrRevx: function (e) {
    let that = this
    let c = e.currentTarget.dataset['ci']
    wx.chooseImage({
      count: 9,
      success: function (res) {
        let d = that.data.odrr
        d[c].v = []
        d[c].x = res.tempFilePaths
        for (let i = 0; i < d[c].x.length; i++) d[c].v[i] = wx.getFileSystemManager().readFileSync(d[c].x[i], "base64")
        that.setData({
          odrr: d
        })
      }
    })
  },
  odrRevs: function () {
    let that = this
    let d = this.data.odrr
    let c = [];
    for (let i = 0; i < d.length; i++) {
      if (d[i].f == 0) {
        app.alt('一定要打分哦~~')
        return
      }
      c[i] = {
        i: d[i].i,
        x: d[i].m,
        t: d[i].r,
        f: d[i].f,
        p: d[i].v
      }
    }
    wx.showLoading({
      title: '正在提交......'
    })
    app.xhr({
      act: 'orev',
      ID: this.data.reid,
      Re: c
    }, function (r) {
      wx.hideLoading()
      app.alt('评论发表成功！' + (r.une > 0 ? '获得好评返现' + (r.une / 100) + '元！' : (r.une < 0 ? ('好评返现' + (-r.une / 100) + '元将等待小二审核后到账！') : '')))
      that.hideRvw()
      let u = that.data.user
      u.Ne = u.Ne * 1 + r.une
      that.setData({
        user: u
      })
      that.loadOdr()
    })
  },
  hideRvw: function () {
    this.fadeIO('rvw', 0)
  },
  odrFtex: function (n) {
    let c = this.data.order[n].Ni
    let d = this.data.order[n].Nr
    this.data.text.texNo = ''
    d.i = c;
    this.setData({
      ftex: d
    })
    this.fadeIO('tex', 1);
  },
  saveTex: function () {
    let c = this.data.ftex
    let d = this.data.text.texNo || ''
    if (d == '') {
      app.alt(('请输入快递单号！'))
      return
    }
    let that = this
    app.xhr({
      act: 'otex',
      Ni: c.i,
      No: d
    }, function (r) {
      that.hideTex()
      that.setData({
        pg: 1,
        oi: 3,
        order: []
      })
      that.loadOdr()
    })
  },
  hideTex: function () {
    this.fadeIO('tex', 0)
  },
  odrRefd: function (n) {
    let c = this.data.order[n]
    let e = this.data.text
    let d = {}
    d.ID = c.ID
    d.Ni = c.Ni
    d.Nm = (c.Np * 1 - c.Nf * 1) / 100
    d.Nz = '七天无理由退款'
    d.Nt = []
    d.Nh = []
    d.Nr = c.Nr
    e.refNm = d.Nm
    e.refNz = d.Nz
    this.setData({
      refs: d,
      text: e
    })
    this.fadeIO('ref', 1);
  },
  odrRefm: function () {
    let that = this
    wx.chooseImage({
      count: 5,
      success: function (res) {
        let d = that.data.refs
        d.Nt = []
        d.Nh = res.tempFilePaths
        for (let i = 0; i < d.Nh.length; i++) d.Nt[i] = wx.getFileSystemManager().readFileSync(d.Nh[i], "base64")
        that.setData({
          refs: d
        })
      }
    })
  },
  saveRef: function () {
    let c = this.data.text
    let d = this.data.refs
    let that = this
    if (c.refNm * 1 > d.Nm * 1) {
      app.alt('退款金额超限，最多' + d.Nm + '元（不含运费）')
      return;
    }
    d.Nm = Math.round(c.refNm * 100)
    d.Nz = c.refNz
    d.act = 'oref'
    wx.requestSubscribeMessage({
      tmplIds: [that.data.tpl[2]],
      success: function (res) {},
      complete: function (res) {
        wx.showLoading({
          title: '正在发表...',
          mask: true
        })
        app.xhr(d, function (r) {
          wx.hideLoading()
          app.alt('退款请求已提交，请等待商家处理！')
          that.setData({
            pg: 1,
            oi: 3,
            order: []
          })
          that.fadeIO('ref', 0)
          that.loadOdr()
        })
      }
    })
  },
  hideRef: function () {
    this.fadeIO('ref', 0)
  },
  odrExpn: function (n, m, w) {
    let that = this
    this.setData({
      exps: {}
    })
    this.fadeIO('exp', 1);
    let c = this.data.order[n].Nk;
    let d = this.data.order[n].Na;
    app.xhr({
      act: 'oexp',
      ID: this.data.order[n].ID,
      kr: m ? false : true,
      nu: m || c.d
    }, function (r) {
      r.h = w || (d.p + d.c + d.a + d.d);
      that.setData({
        exps: r
      })
    });
  },
  odrExpm: function (n) {
    let c = this.data.order[n].Nr
    this.odrExpn(n, c.k.d, c.w)
  },
  odrStat: function (i, s) {
    let that = this
    wx.showModal({
      title: '提示',
      content: '确认操作？',
      success(res) {
        if (res.confirm) {
          app.xhr({
            act: 'oset',
            ID: i,
            Nt: s
          }, function (r) {
            that.setData({
              pg: 1,
              oi: -1,
              order: []
            })
            that.loadOdr()
          })
        }
      }
    })
  },
  hideExp: function () {
    this.fadeIO('exp', 0)
  },
  setText: function (e) {
    let v = e.detail.value
    let o = e.currentTarget.dataset['nm']
    let s = e.currentTarget.dataset['xs'] || false
    let t = this.data.text
    if (s !== false) {
      v = parseFloat(v) || 0
      v = Math.round(v * Math.pow(10, s)) / Math.pow(10, s);
    }
    t[o] = v;
    this.setData({
      text: t
    })
  },
  showIco: function () {
    let that = this
    wx.chooseImage({
      count: 1,
      success: function (res) {
        wx.showLoading({
          title: '正在上传...',
          mask: true
        })
        app.xhr({
          act: 'uico',
          icon: wx.getFileSystemManager().readFileSync(res.tempFilePaths[0], "base64")
        }, function (r) {
          let c = that.data.user
          c.Ni = 1
          that.setData({
            rand: Math.random(),
            user: c
          })
          wx.hideLoading()
        })
      },
    })
  },
  navMain: function () {
    wx.redirectTo({
      url: '../main/main'
    })
  },
  showCrt: function () {
    wx.navigateTo({
      url: '../cart/cart'
    })
  },
  showDay: function () {
    let that = this
    app.xhr({
      act: 'uday'
    }, function (r) {
      app.alt('签到成功' + (r.mny > 0 ? ('，获得现金' + (r.mny / 100) + '元') : '') + '！您已连续签到' + r.cnt + '天，继续哦~~')
      let c = that.data.user
      c.Ne = c.Ne * 1 + r.mny
      that.setData({
        user: c
      })
    })
  },
  showSet: function () {
    let c = this.data.text
    c.userNm = this.data.user.Nm
    c.userNc = this.data.user.Nc
    c.userNt = this.data.user.Nt
    c.userNd = this.data.user.Nt
    this.setData({
      text: c
    })
    this.fadeIO('set', 1)
  },
  hideSet: function () {
    this.fadeIO('set', 0)
  },
  saveSet: function () {
    let that = this
    let m = this.data.text.userNm
    let c = this.data.text.userNc
    let t = this.data.cfg.Ft ? this.data.text.userNt : this.data.text.userNd
    app.xhr({
      act: 'uset',
      Nm: m,
      Nc: c,
      Nt: t
    }, function (r) {
      that.fadeIO('set', 0)
      app.alt('保存成功', 1)
      let u = that.data.user
      u.Nm = m
      u.Nc = c
      u.Nt = t
      that.setData({
        user: u
      })
    })
  },
  showEwm: function () {
    let that = this
    wx.chooseImage({
      count: 1,
      success: function (res) {
        wx.showLoading({
          title: '正在上传...',
          mask: true
        })
        app.xhr({
          act: 'uewm',
          icon: wx.getFileSystemManager().readFileSync(res.tempFilePaths[0], "base64")
        }, function (r) {
          wx.hideLoading()
          if (r.url && r.url.substr(0, 6) == 'wxp://') {
            let c = that.data.text
            c.userNd = r.url
            that.setData({
              text: c
            })
          } else alt('收款码解码失败或非微信收款码！')
        })
      },
    })
  },
  showFav: function () {
    this.fadeIO('fav', 1)
  },
  hideFav: function () {
    this.fadeIO('fav', 0)
  },
  viewFav: function (e) {
    wx.navigateTo({
      url: '../item/item?id=' + e.currentTarget.dataset['fi']
    })
  },
  deleFav: function (e) {
    let f = e.currentTarget.dataset['fi']
    let that = this
    wx.showModal({
      title: '提示',
      content: '是否从收藏夹删除此商品？',
      success: function (res) {
        if (res.confirm) {
          let c = that.data.user
          let d = c.Nf
          let e = ''
          let b = []
          for (let i = 1; i < d.length; i++) {
            if (f * 1 != i) {
              e += ',' + c.Nf[i].ID;
              b.push(d[i])
            }
          }
          app.xhr({
            act: 'favs',
            Nf: e
          }, function (r) {
            c.Nf = b
            that.setData({
              user: c
            })
          })
        }
      }
    })
  },
  showCpn: function () {
    this.fadeIO('cpn', 1)
  },
  hideCpn: function () {
    this.fadeIO('cpn', 0)
  },
  viewCpn: function (e) {
    let u = this.data.user
    let i = e.currentTarget.dataset['id']
    u.Nh[i].Nh = 1 - u.Nh[i].Nh
    this.setData({
      user: u
    })
  },
  showCtx: function () {
    let that = this
    app.xhr({
      act: 'uctx'
    }, function (r) {
      let t = that.data.text
      t.ctxCz = 100;
      t.ctxTx = that.data.user.Ne / 100
      that.setData({
        ctxf: r.ctxf,
        text: t
      })
      that.fadeIO('ctx', 1)
    })
  },
  chonCtx: function (e) {
    let that = this
    let n = e.currentTarget.dataset['ct'] * 1
    let c = Math.round([0, this.data.text.ctxCz, this.data.text.ctxTx][n] * 100)
    if (n == 2 && (c <= 0 || c > this.data.user.Ne * 1)) return;
    if (n == 2 && this.data.user.Nt == '') {
      app.alt('请先点击会员名称会员设置中' + (this.data.cfg.Ft == 1 ? '填写真实姓名（实时到账）' : '上传收款码') + '！');
      return;
    }
    wx.showModal({
      title: '提示',
      content: (n == 2 ? '提现（手续费' + that.data.cfg.Ff + '%）' : '充值') + (c / 100) + '元，' + '确认操作？',
      success: function (res) {
        if (res.confirm) {
          app.xhr({
            act: 'ucts',
            Ns: n,
            Nm: c
          }, function (r) {
            if (n * 1 == 2) {
              wx.requestSubscribeMessage({
                tmplIds: [that.data.tpl[3]],
                success: function (res) {},
                complete: function (res) {
                  app.alt('提现请求已发出，请等待小二处理！')
                  that.showCtx()
                }
              })
            } else that.wxPay(r.odr)
          })
        }
      }
    })
  },
  actsCtx: function (e) {
    let i = e.currentTarget.dataset['ni'] * 1
    let s = e.currentTarget.dataset['ns'] * 1
    let t = e.currentTarget.dataset['nt'] * 1
    if (s == 0 || s == 3) {
      app.alt('订单号：' + this.data.ctxf[i].Nc)
    } else if (s == 2 && t == 0) {
      let that = this
      wx.showModal({
        title: '提示',
        content: '确认撤销提现请求？',
        success(res) {
          if (res.confirm) {
            app.xhr({
              act: 'ucte',
              ID: that.data.ctxf[i].ID
            }, function (r) {
              that.showCtx()
            })
          }
        }
      })
    }
  },
  hideCtx: function () {
    this.fadeIO('ctx', 0)
  },
  showShr: function () {
    this.fadeIO('shr', 1)
  },
  hideShr: function () {
    this.fadeIO('shr', 0)
  },
  codeShr: function () {
    wx.previewImage({
      urls: [app.globalData.url + 'wxcode.php?u=' + app.globalData.uid + '_0' + '&p=images/!system/mini.jpg&t=' + encodeURI(app.globalData.www) + '&k=' + encodeURI('长按图片弹出菜单选择保存然后将图片分享给您的好友')]
    })
  },
  codeUsr: function () {
    let that = this
    app.xhr({
      act: 'umbr'
    }, function (r) {
      that.setData({
        mbrs: r.mbrs
      })
      that.fadeIO('usr', 1, 1)
    })
  },
  hideUsr: function () {
    this.fadeIO('usr', 0, 1)
  },
  codeMny: function () {
    let that = this
    app.xhr({
      act: 'umny'
    }, function (r) {
      let c = 0;
      for (let i = 0; i < r.mnys.length; i++) c += r.mnys[i].Ns * 1
      that.setData({
        mnys: r.mnys,
        mnyc: c / 100,
        qp: '取消'
      })
      that.fadeIO('mny', 1, 1)
    })
  },
  hideMny: function () {
    this.fadeIO('mny', 0, 1)
  },
  hidePay: function () {
    wx.redirectTo({
      url: '../user/user'
    })
  },
  exitPay: function () {
    this.setData({
      qp: '完成'
    })
  },
  fadeIO: function (obj, io, bk) {
    this.setData(JSON.parse('{"d_' + obj + '":"block"}'))
    this.setData({
      d_msk: 'block',
      h_msk: wx.getSystemInfoSync().windowHeight
    })
    let ao = wx.createAnimation({
      duration: 500,
      timingFunction: 'ease',
      delay: 0
    });
    ao.opacity(io ? 1 : 0).translateY(io ? 0 : 100).step()
    let am = wx.createAnimation({
      duration: 500,
      timingFunction: 'ease',
      delay: 0
    });
    am.opacity(bk ? 0.3 : (io ? 0.3 : 0)).step()
    let jo = JSON.parse('{"' + obj + '":""}')
    jo[obj] = ao.export()
    jo.msk = am.export()
    this.setData(jo)
    if (!io) {
      let that = this
      setTimeout(function () {
        that.setData(JSON.parse('{"d_' + obj + '":"none"' + (bk ? '' : ',"h_msk":0') + '}'))
      }, 550)
    }
  },
  onShareAppMessage: function (options) {
    return {
      title: app.globalData.www,
      path: '/pages/index/index?fr=' + app.globalData.uid + '_0',
      imageUrl: app.globalData.url + 'images/!system/mini.jpg',
      success: function (res) {
        app.alt('分享成功', 1)
      },
      fail: function (res) {},
      complete: function (res) {}
    }
  },
  onReachBottom: function () {
    if (this.data.pt >= this.data.pg) this.loadOdr()
  }
})