<?php

namespace app\admin\controller;
use think\facade\View;
use think\facade\Db;
use think\facade\Lang;

/**
 * ============================================================================
 * DSMall多用户商城
 * ============================================================================
 * 版权所有 2014-2028 长沙德尚网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.csdeshang.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！您只能在不用于商业目的的前提下对程序代码进行修改和使用 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 控制器
 */
class Adminlog extends AdminControl
{
    const EXPORT_SIZE = 5000;
    public function initialize()
    {
        parent::initialize(); // TODO: Change the autogenerated stub
        Lang::load(base_path() . 'admin/lang/'.config('lang.default_lang').'/adminlog.lang.php');
    }

    /**
     * 日志列表
     *
     */
    public function loglist()
    {
        $condition = array();
        $time1='';
        $time2='';
        if (!empty(input('param.admin_name'))) {
            $condition[]=array('admin_name','=',input('param.admin_name'));
        }
        if (!empty(input('param.time_from'))) {
            $time1 = strtotime(input('param.time_from'));
        }
        if (!empty(input('param.time_to'))) {
            $time2 = strtotime(input('param.time_to'));
            if ($time2 !== false)
                $time2 = $time2 + 86400;
        }
        if ($time1 && $time2) {
            $condition[] = array('adminlog_time','between', array($time1, $time2));
        }
        elseif ($time1) {
            $condition[]=array('adminlog_time','>=', $time1);
        }
        elseif ($time2) {
            $condition[]=array('adminlog_time','<=', $time2);
        }
        $adminlog_model= model('adminlog');
        $order='adminlog_id desc';
        $adminlog_list = $adminlog_model->getAdminlogList($condition,10,$order);
        View::assign('adminlog_list', $adminlog_list);
        View::assign('show_page', $adminlog_model->page_info->render());
        
        View::assign('filtered', $condition ? 1 : 0); //是否有查询条件
        
        $this->setAdminCurItem('loglist');
        return View::fetch();
    }

    /**
     * 删除日志
     *
     */
    public function list_del()
    {
        $adminlog_id = input('param.adminlog_id');
        $adminlog_id_array = ds_delete_param($adminlog_id);
        if ($adminlog_id_array == FALSE) {
            ds_json_encode('10001', lang('param_error'));
        }
        $condition = array();
        $condition[] = array('adminlog_id','in',$adminlog_id_array);
        $adminlog_model=model('adminlog');
        if (!$adminlog_model->delAdminlog($condition)) {
            $this->log(lang('ds_del').lang('admin_log'), 0);
            ds_json_encode('10001', lang('ds_common_del_fail'));
        }
        else {
            $this->log(lang('ds_del').lang('admin_log'), 1);
            ds_json_encode('10000', lang('ds_common_del_succ'));
        }
    }

    /**
     * 导出第一步
     */
    public function export_step1()
    {
        $time1='';
        $time2='';
        $condition = array();
        if (!empty(input('param.admin_name'))) {
            $condition[]=array('admin_name','=',input('param.admin_name'));
        }
        if (!empty(input('param.time_from'))) {
            $time1 = strtotime(input('param.time_from'));
        }
        if (!empty(input('param.time_to'))) {
            $time2 = strtotime(input('param.time_to'));
            if ($time2 !== false)
                $time2 = $time2 + 86400;
        }
        if ($time1 && $time2) {
            $condition[] = array('createtime','between', array($time1, $time2));
        }
        elseif ($time1) {
            $condition[]=array('createtime','>=', $time1);
        }
        elseif ($time2) {
            $condition[]=array('createtime','<=', $time2);
        }
        if (!is_numeric(input('param.page'))) {
            $adminlog_model=model('adminlog');
            $count = $adminlog_model->getAdminlogCount($condition);
            $export_list = array();
            if ($count > self::EXPORT_SIZE) {    //显示下载链接
                $page = ceil($count / self::EXPORT_SIZE);
                for ($i = 1; $i <= $page; $i++) {
                    $limit1 = ($i - 1) * self::EXPORT_SIZE + 1;
                    $limit2 = $i * self::EXPORT_SIZE > $count ? $count : $i * self::EXPORT_SIZE;
                    $export_list[$i] = $limit1 . ' ~ ' . $limit2;
                }
                View::assign('export_list', $export_list);
                return View::fetch('/public/excel');
            }
            else {    //如果数量小，直接下载
                $data = Db::name('adminlog')->where($condition)->order('adminlog_id desc')->limit(self::EXPORT_SIZE)->select()->toArray();
                $this->createExcel($data);
            }
        }
        else {    //下载
            $limit1 = (input('param.page') - 1) * self::EXPORT_SIZE;
            $limit2 = self::EXPORT_SIZE;
            $data = Db::name('adminlog')->where($condition)->order('adminlog_id desc')->limit($limit1,$limit2)->select()->toArray();
            $this->createExcel($data);
        }
    }

    /**
     * 生成excel
     *
     * @param array $data
     */
    private function createExcel($data = array())
    {
        Lang::load(base_path() .'admin/lang/'.config('lang.default_lang').'/export.lang.php');
        $excel_obj = new \excel\Excel();
        $excel_data = array();
        //设置样式
        $excel_obj->setStyle(array(
                                 'id' => 's_title', 'Font' => array('FontName' => lang('ds_song_typeface'), 'Size' => '12', 'Bold' => '1')
                             ));
        //header
        $excel_data[0][] = array('styleid' => 's_title', 'data' => lang('admin_log_man'));
        $excel_data[0][] = array('styleid' => 's_title', 'data' => lang('admin_log_do'));
        $excel_data[0][] = array('styleid' => 's_title', 'data' => lang('admin_log_dotime'));
        $excel_data[0][] = array('styleid' => 's_title', 'data' => 'IP');
        foreach ((array)$data as $k => $v) {
            $tmp = array();
            $tmp[] = array('data' => $v['admin_name']);
            $tmp[] = array('data' => $v['adminlog_content']);
            $tmp[] = array('data' => date('Y-m-d H:i:s', $v['adminlog_time']));
            $tmp[] = array('data' => $v['adminlog_ip']);
            $excel_data[] = $tmp;
        }
        $excel_data = $excel_obj->charset($excel_data, CHARSET);
        $excel_obj->addArray($excel_data);
        $excel_obj->addWorksheet($excel_obj->charset(lang('admin_log'), CHARSET));
        $excel_obj->generateXML($excel_obj->charset(lang('admin_log'), CHARSET) . input('param.page') . '-' . date('Y-m-d-H', TIMESTAMP));
    }

    protected function getAdminItemList()
    {
        $menu_array = array(
            array(
                'name' => 'loglist',
                'text' => lang('admin_log'),
                'url' => (string)url('Adminlog/loglist')
            )
            );
        return $menu_array;

    }
}