<?php

namespace app\admin\controller;
use think\facade\View;
use think\facade\Lang;

/**
 * ============================================================================
 * DSMall多用户商城
 * ============================================================================
 * 版权所有 2014-2028 长沙德尚网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.csdeshang.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！您只能在不用于商业目的的前提下对程序代码进行修改和使用 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 控制器
 */
class Chain extends AdminControl
{
    public function initialize()
    {
        parent::initialize(); // TODO: Change the autogenerated stub
        Lang::load(base_path() . 'admin/lang/'.config('lang.default_lang').'/chain.lang.php');
    }

    /**
     * 门店列表
     */
    public function index()
    {
        $chain_model = model('chain');
        $where = array();
        if (input('param.search_name') != '') {
            $where[]=array('chain_truename','like', '%' . input('param.search_name') . '%');
            View::assign('search_name', input('param.search_name'));
        }
        if (input('param.sign') == 'verify') {
            View::assign('sign', 'verify');
            $dp_list = $chain_model->getChainWaitVerifyList($where, 10);
            $this->setAdminCurItem('verify');
        }
        else {
            $dp_list = $chain_model->getChainList($where, 10);
            $this->setAdminCurItem('index');
        }
        View::assign('show_page', $chain_model->page_info->render());
        View::assign('dp_list', $dp_list);

        View::assign('chain_state', $chain_model->getChainState());
        return View::fetch();
    }

    /**
     * 门店设置
     */
    public function setting()
    {
        if (!request()->isPost()) {
            $list_setting = rkcache('config', true);
            View::assign('list_setting', $list_setting);
            return View::fetch();
        } else {
            $update_array = array();
            $update_array['chain_isuse'] = intval(input('post.chain_isuse'));
            $result = model('config')->editConfig($update_array);
            $log = lang('ds_open');
            if ($result === true) {
                if ($update_array['chain_isuse'] == 0) {
                    $log = lang('ds_close');
                    // 删除相关联的收货地址
                    model('address')->delAddress(array(array('chain_id','<>', 0)));
                }
                $this->log($log . lang('chain_function'), 1);
                dsLayerOpenSuccess(lang('ds_common_save_succ'));
            } else {
                $this->log($log . lang('chain_function'), 0);
                $this->error(lang('ds_common_save_fail'));
            }
        }
    }

    /**
     * 编辑门店信息
     */
    public function edit_chain()
    {
        $chain_id = intval(input('param.d_id'));
        if ($chain_id <= 0) {
            $this->error(lang('param_error'));
        }
        $chain_info = model('chain')->getChainInfo(array('chain_id' => $chain_id));
        if (empty($chain_info)) {
            $this->error(lang('param_error'));
        }
        View::assign('chain_info', $chain_info);
        $this->setAdminCurItem('edit_chain');
        return View::fetch();
    }

    /**
     * 编辑保存
     */
    public function save_edit()
    {
        $chain_id = intval(input('param.did'));
        if (!request()->isPost() || $chain_id <= 0) {
            $this->error(lang('param_error'));
        }
        $where = array('chain_id' => $chain_id);
        $update = array();
        $update['chain_mobile'] = input('post.dmobile');
        $update['chain_telephony'] = input('post.dtelephony');
        $update['chain_addressname'] = input('post.daddressname');
        $update['chain_address'] = input('post.daddress');
        
        $chain_passwd = input('post.dpasswd');
        if (!empty($chain_passwd)) {
            $update['chain_passwd'] = md5($chain_passwd);
        }
        $update['chain_state'] = intval(input('post.dstate'));
        $update['chain_failreason'] = input('post.fail_reason');
        $result = model('chain')->editChain($update, $where);
        if ($result) {
            // 删除相关联的收货地址
            model('address')->delAddress(array('chain_id' => $chain_id));
            $this->log(lang('ds_edit').lang('chain_function').'，ID：' . $chain_id, 1);
            $this->success(lang('ds_common_op_succ'), (string)url('Chain/index'));
        }
        else {
            $this->log(lang('ds_edit').lang('chain_function').'，ID：' . $chain_id, 0);
            $this->error(lang('ds_common_op_fail'));
        }
    }

    protected function getAdminItemList()
    {
        $menu_array = array(
            array(
                'name' => 'index',
                'text' => lang('ds_manage'),
                'url' => (string)url('Chain/index')
            )/*, array(
                'name' => 'verify',
                'text' => lang('chain_verify'),
                'url' => (string)url('Chain/index',['sign'=>'verify'])
            ), array(
                'name' => 'setting', 
                'text' => lang('ds_set'),
                'url' => "javascript:dsLayerOpen('".(string)url('Chain/setting')."','".lang('ds_set')."')"
            ),*/
        );
        if (request()->action() == 'edit_chain') {
            $menu_array[] = array('name' => 'edit_chain', 'text' => lang('ds_edit'), 'url' => (string)url('Chain/edit_chain'));
        }
        return $menu_array;
    }
}