<?php

namespace app\admin\controller;
use think\facade\View;
use think\facade\Lang;

/**
 * ============================================================================
 * DSMall多用户商城
 * ============================================================================
 * 版权所有 2014-2028 长沙德尚网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.csdeshang.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！您只能在不用于商业目的的前提下对程序代码进行修改和使用 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 控制器
 */
class Consulting extends AdminControl {

    public function initialize() {
        parent::initialize(); // TODO: Change the autogenerated stub
        Lang::load(base_path() . 'admin/lang/'.config('lang.default_lang').'/consulting.lang.php');
    }

    /**
     * 咨询管理
     */
    public function consulting() {
        $condition = array();
        $member_name = trim(input('param.member_name'));
        if ($member_name != '') {
            $condition[]=array('member_name','like', '%' . $member_name . '%');
            View::assign('member_name', $member_name);
        }
        $consult_content = trim(input('param.consult_content'));
        if ($consult_content != '') {
            $condition[]=array('consult_content','like', '%' . $consult_content . '%');
            View::assign('consult_content', $consult_content);
        }
        $ctid = intval(input('param.ctid'));
        if ($ctid > 0) {
            $condition[]=array('consulttype_id','=',$ctid);
            View::assign('ctid', $ctid);
        }
        $consult_model = model('consult');
        $consult_list = $consult_model->getConsultList($condition, '*');
        
        View::assign('filtered', $condition ? 1 : 0); //是否有查询条件
        
        View::assign('show_page', $consult_model->page_info->render());
        View::assign('consult_list', $consult_list);


        // 咨询类型
        $consult_type = rkcache('consulttype', true);
        View::assign('consult_type', $consult_type);
        $this->setAdminCurItem('index');
        return View::fetch();
    }

    public function delete() {
        $consult_id = input('param.consult_id');
        $consult_id_array = ds_delete_param($consult_id);
        if($consult_id_array === FALSE){
            $this->error(lang('param_error'));
        }
        $condition=array();
        $condition[] = array('consult_id','in', $consult_id_array);
        $consult = model('consult');
        if ($consult->delConsult($condition)) {
            $this->log(lang('delete_consulting') . '[ID:' . $consult_id . ']', null);
            ds_json_encode('10000', lang('ds_common_del_succ'));
        } else {
            ds_json_encode('10001', lang('ds_common_del_fail'));
        }
    }


    /**
     * 咨询类型列表
     */
    public function type_list() {
        $consulttype_model = model('consulttype');
        $type_list = $consulttype_model->getConsulttypeList(array(), 'consulttype_id,consulttype_name,consulttype_sort');
        View::assign('type_list', $type_list);
        $this->setAdminCurItem('type_list');
        return View::fetch();
    }

    /**
     * 新增咨询类型
     */
    public function type_add() {
        if (request()->isPost()) {
            // 验证
            $data = [
                'consulttype_name' => input('post.consulttype_name'),
                'consulttype_sort' => input('post.consulttype_sort'),
            ];
            $consulting_validate = ds_validate('consulting');
            if (!$consulting_validate->scene('type_add')->check($data)) {
                $this->error($consulting_validate->getError());
            }

            $insert = array();
            $insert['consulttype_name'] = trim(input('post.consulttype_name'));
            $insert['consulttype_sort'] = intval(input('post.consulttype_sort'));
            $insert['consulttype_introduce'] = input('post.consulttype_introduce');
            $result = model('consulttype')->addConsulttype($insert);
            if ($result) {
                $this->log(lang('add_consulttype'), 1);
                dsLayerOpenSuccess(lang('ds_common_save_succ'));
            } else {
                $this->log(lang('add_consulttype'), 0);
                $this->error(lang('ds_common_save_fail'));
            }
        }
        $consulttype_info = array(
            'consulttype_id' => '',
            'consulttype_name' => '',
            'consulttype_sort' => '',
            'consulttype_introduce' => '',
        );
        View::assign('build_editor', build_editor(array(
            'name' => 'consulttype_introduce',
        )));
        View::assign('consulttype_info', $consulttype_info);
        return View::fetch('type_edit');
    }

    /**
     * 编辑咨询类型
     */
    public function type_edit() {
        $consulttype_model = model('consulttype');
        $consulttype_id = intval(input('param.consulttype_id'));
        if ($consulttype_id <= 0) {
            $this->error(lang('param_error'));
        }
        if (request()->isPost()) {
            // 验证
            $data = [
                'consulttype_name' => input('post.consulttype_name'),
                'consulttype_sort' => input('post.consulttype_sort'),
            ];
            $consulting_validate = ds_validate('consulting');
            if (!$consulting_validate->scene('type_edit')->check($data)) {
                $this->error($consulting_validate->getError());
            }

            $condition = array();
            $condition[] = array('consulttype_id','=',$consulttype_id);
            $update = array();
            $update['consulttype_name'] = trim(input('post.consulttype_name'));
            $update['consulttype_sort'] = intval(input('post.consulttype_sort'));
            $update['consulttype_introduce'] = input('post.consulttype_introduce');
            $result = $consulttype_model->editConsulttype($condition, $update);
            if ($result) {
                $this->log(lang('edit_consulttype').' ID:' . $consulttype_id, 1);
                dsLayerOpenSuccess(lang('ds_common_op_succ'));
            } else {
                $this->log(lang('edit_consulttype').' ID:' . $consulttype_id, 0);
                $this->error(lang('ds_common_op_fail'));
            }
        }else {
            $consulttype_info = $consulttype_model->getConsulttypeInfo(array('consulttype_id' => $consulttype_id));
            View::assign('build_editor', build_editor(array(
                'name' => 'consulttype_introduce',
                'content' => htmlspecialchars_decode($consulttype_info['consulttype_introduce']),
            )));
            $this->setAdminCurItem('type_list');
            View::assign('consulttype_info', $consulttype_info);
            return View::fetch();
        }
    }

    /**
     * 删除咨询类型
     */
    public function type_del() {
        $consulttype_id = input('param.consulttype_id');
        $consulttype_id_array = ds_delete_param($consulttype_id);
        if ($consulttype_id_array === FALSE) {
            ds_json_encode('10001', lang('param_error'));
        }
        $condition=array();
        $condition[]=array('consulttype_id','in',$consulttype_id_array);
        $result = model('consulttype')->delConsulttype($condition);
        if ($result) {
            $this->log(lang('del_consulttype').' ID:' . $consulttype_id, 1);
            ds_json_encode('10000', lang('ds_common_op_succ'));
        } else {
            $this->log(lang('del_consulttype').' ID:' . $consulttype_id, 0);
            ds_json_encode('10001', lang('ds_common_op_fail'));
        }
    }

    /**
     * 获取卖家栏目列表,针对控制器下的栏目
     */
    protected function getAdminItemList() {
        $menu_array = array(
            array(
                'name' => 'index',
                'text' => lang('ds_manage'),
                'url' => (string)url('Consulting/consulting')
            ),
            array(
                'name' => 'type_list',
                'text' => lang('consulting_index_type'),
                'url' => (string)url('Consulting/type_list')
            ),
            array(
                'name' => 'type_add',
                'text' => lang('add_consulttype'),
                'url' =>"javascript:dsLayerOpen('".(string)url('Consulting/type_add')."','".lang('add_consulttype')."')"

            )
        );
        return $menu_array;
    }

}