<?php

namespace app\admin\controller;
use think\facade\View;
use think\facade\Lang;

/**
 * ============================================================================
 * DSMall多用户商城
 * ============================================================================
 * 版权所有 2014-2028 长沙德尚网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.csdeshang.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！您只能在不用于商业目的的前提下对程序代码进行修改和使用 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 控制器
 */
class Evaluate extends AdminControl
{
    public function initialize()
    {
        parent::initialize(); // TODO: Change the autogenerated stub
        Lang::load(base_path().'admin/lang/'.config('lang.default_lang').'/evaluate.lang.php');
    }

    /**
     * 商品来自买家的评价列表
     */
    public function evalgoods_list() {
        $evaluategoods_model = model('evaluategoods');

        $condition = array();
        //商品名称
        if (input('param.goods_name')) {
            $condition[]=array('geval_goodsname','like', '%'.input('param.goods_name').'%');
        }
        //店铺名称
        if (input('param.store_name')) {
            $condition[]=array('geval_storename','like', '%'.input('param.store_name').'%');
        }
        if(input('param.stime')) {
            $stime = strtotime(input('param.stime'));
            $condition[]=array('geval_addtime','>=', $stime);
        }
        if(input('param.etime')) {
            $etime = strtotime(input('param.etime'))+86399;
            $condition[]=array('geval_addtime','<=', $etime);
        }
        $evalgoods_list	= $evaluategoods_model->getEvaluategoodsList($condition, 10);

        View::assign('show_page',$evaluategoods_model->page_info->render());
        View::assign('evalgoods_list',$evalgoods_list);
        
        View::assign('filtered', $condition ? 1 : 0); //是否有查询条件
        
        $this->setAdminCurItem('evalgoods_list');
        return View::fetch('index');
    }

    /**
     * 删除商品评价
     */
    public function evalgoods_del() {
        $geval_id = intval(input('param.geval_id'));
        if ($geval_id <= 0) {
            ds_json_encode(10001, lang('param_error'));
        }
        $evaluategoods_model = model('evaluategoods');
        $result = $evaluategoods_model->delEvaluategoods(array('geval_id'=>$geval_id));
        if ($result) {
            $this->log(lang('del_evaluategoods').$geval_id);
            ds_json_encode(10000, lang('ds_common_del_succ'));
        } else {
            ds_json_encode(10001, lang('ds_common_del_fail'));
        }
    }

    /**
     * 店铺动态评价列表
     */
    public function evalstore_list() {
        $evaluatestore_model = model('evaluatestore');

        $condition = array();
        //评价人
        if (input('param.from_name')) {
            $condition[]=array('seval_membername','like', '%'.input('param.from_name').'%');
        }
        //店铺名称
        if (input('param.store_name')) {
            $condition[]=array('seval_storename','like', '%'.input('param.store_name').'%');
        }
        if(input('param.stime')) {
            $stime = strtotime(input('param.stime'));
            $condition[]=array('seval_addtime','>=', $stime);
        }
        if(input('param.etime')) {
            $etime = strtotime(input('param.etime'));
            $condition[]=array('seval_addtime','<=', $etime);
        }

        $evalstore_list	= $evaluatestore_model->getEvaluatestoreList($condition, 10);
        View::assign('show_page',$evaluatestore_model->page_info->render());
        View::assign('evalstore_list',$evalstore_list);
        $this->setAdminCurItem('evalstore_list');
        return View::fetch();
    }

    /**
     * 删除店铺评价
     */
    public function evalstore_del() {
        $seval_id = intval(input('param.seval_id'));
        if ($seval_id <= 0) {
            ds_json_encode(10001, lang('param_error'));
        }
        $evaluatestore_model = model('evaluatestore');
        $result = $evaluatestore_model->delEvaluatestore(array('seval_id'=>$seval_id));
        if ($result) {
            $this->log(lang('del_evaluatestore').$seval_id);
            ds_json_encode(10000, lang('ds_common_del_succ'));
        } else {
            ds_json_encode(10001, lang('ds_common_del_fail'));
        }
    }
    protected function getAdminItemList()
    {
        $menu_array = array(
            array(
                'name' => 'evalgoods_list',
                'text' => lang('admin_evaluate_list'),
                'url' => (string)url('Evaluate/evalgoods_list')
            ),
            array(
                'name' => 'evalstore_list',
                'text' => lang('admin_evalstore_list'),
                'url' => (string)url('Evaluate/evalstore_list')
            )
        );
        return $menu_array;
    }
}