<?php

namespace app\admin\controller;
use think\facade\View;
use think\facade\Lang;

/**
 * ============================================================================
 * DSMall多用户商城
 * ============================================================================
 * 版权所有 2014-2028 长沙德尚网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.csdeshang.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！您只能在不用于商业目的的前提下对程序代码进行修改和使用 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 控制器
 */
class Offpayarea extends AdminControl
{
    public function initialize()
    {
        parent::initialize(); // TODO: Change the autogenerated stub
        Lang::load(base_path() . 'admin/lang/'.config('lang.default_lang').'/offpayarea.lang.php');
        
    }

    public function index()
    {

        \areacache::deleteCacheFile();
        \areacache::updateAreaArrayJs();
        \areacache::updateAreaPhp();
        $offpayarea_model = model('offpayarea');
        $area_model = model('area');
        
        //默认平台店铺id
        $store_id = 1;
        if (request()->isPost()) {
            
            $county_array = input('post.county');
            if (!preg_match('/^[\d,]+$/', $county_array)) {
                $county_array = '';
            }
            //内置自营店ID
            $area_info = $offpayarea_model->getOffpayareaInfo(array('store_id' => $store_id));
            $data = array();
            $county = trim($county_array, ',');
            //地区修改
            $county_array = explode(',', $county);

            $all_array = array();

            $province_array = input('post.province/a');
            if (!empty($province_array) && is_array($province_array)) {
                foreach ($province_array as $v) {
                    $all_array[$v] = $v;
                }
            }

            $city_array = input('post.city/a');
            if (!empty($city_array) && is_array($city_array)) {
                foreach ($city_array as $v) {
                    $all_array[$v] = $v;
                }
            }


            if(is_array($county_array)) {
                foreach ($county_array as $pid) {
                    if($pid=='') continue;
                    $all_array[$pid] = $pid;
                    $temp = $area_model->getChildsByPid($pid);
                    if (!empty($temp) && is_array($temp)) {
                        foreach ($temp as $v) {
                            $all_array[$v] = $v;
                        }
                    }
                }
            }

            $all_array = array_values($all_array);
            $data['area_id'] = serialize($all_array);
            if (!$area_info) {
                $data['store_id'] = $store_id;
                $result = $offpayarea_model->addOffpayarea($data);
            } else {
                $result = $offpayarea_model->editOffpayarea(array('store_id' => $store_id), $data);
            }
            if ($result) {
                $this->success(lang('ds_common_op_succ'));
            } else {
                $this->error(lang('ds_common_op_fail'));
            }
        }
        //取出支持货到付款的县ID及上级市ID
        $parea_info = $offpayarea_model->getOffpayareaInfo(array('store_id' => $store_id));
        if (!empty($parea_info['area_id'])) {
            $parea_ids = @unserialize($parea_info['area_id']);
        }
        if (empty($parea_ids)) {
            $parea_ids = array();
        }
        View::assign('parea_ids',$parea_ids);
        //取出支持货到付款县ID的上级市ID
        $city_checked_child_array = array();
        //地区修改
        $county_array = $area_model->getAreaList(array('area_deep' => 3), 'area_id,area_parent_id');
        foreach ($county_array as $v) {
            if (in_array($v['area_id'], $parea_ids)) {
                $city_checked_child_array[$v['area_parent_id']][] = $v['area_id'];
            }
        }
        //halt($city_checked_child_array);
        View::assign('city_checked_child_array', $city_checked_child_array);
        //市级下面的县是不是全部支持货到付款，如果全部支持，默认选中，如果其中部分县支持货到付款，默认不选中但显示一个支付到付县的数量

        //格式 city_id => 下面支持到付的县ID数量
        $city_count_array = array();
        //格式 city_id => 是否选中true/false
        $city_checked_array = array();
        $list = $area_model->getAreaList(array('area_deep' => 3), 'area_parent_id,count(area_id) as child_count', 'area_parent_id');
        foreach ($list as $k => $v) {
            $city_count_array[$v['area_parent_id']] = $v['child_count'];
        }
        foreach ($city_checked_child_array as $city_id => $city_child) {
            if (count($city_child) > 0) {
                if (count($city_child) == $city_count_array[$city_id]) {
                    $city_checked_array[$city_id] = true;
                }
            }
        }
        View::assign('city_checked_array', $city_checked_array);

        //取得省级地区及直属子地区(循环输出)
        require(PUBLIC_PATH . DIRECTORY_SEPARATOR . "static" . DIRECTORY_SEPARATOR . "plugins" . DIRECTORY_SEPARATOR .  '/area_datas.php');
        //地区修改 修改地区从3级变成5级，以及N级引发的错误
        $province_array = array();
        foreach ($area_array as $k => $v) {
            if ($v['area_parent_id'] == '0') {
                $province_array[$k] = $k;
            }
        }

        foreach ($area_array as $k => $v) {
            if ($v['area_parent_id'] != '0') {
                if (in_array($v['area_parent_id'], $province_array)) {
                    $area_array[$v['area_parent_id']]['child'][$k] = $v['area_name'];
                }
                unset($area_array[$k]);
            }
        }

        View::assign('province_array', $area_array);

        //计算哪些省需要默认选中(即该省下面的所有县都支持到付，即所有市都是选中状态)
        $province_array = $area_array;
        foreach ($province_array as $pid => $value) {
            if (isset($value['child']) && is_array($value['child'])) {
                foreach ($value['child'] as $k => $v) {
                    if (!array_key_exists($k, $city_checked_array)) {
                        unset($province_array[$pid]);
                        break;
                    }
                }
            }
        }
        View::assign('province_checked_array', $province_array);
        $this->setAdminCurItem('index');
        return View::fetch();
    }

    protected function getAdminItemList() {
        $menu_array = array(
            array(
                'name' => 'index',
                'text' => lang('ds_offpayarea'),
                'url' => (string)url('Offpayarea/index')
            )
        );
        return $menu_array;
    }
}