<?php

namespace app\admin\controller;

use think\facade\View;
use think\facade\Lang;

/**
 * ============================================================================
 * DSMall多用户商城
 * ============================================================================
 * 版权所有 2014-2028 长沙德尚网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.csdeshang.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！您只能在不用于商业目的的前提下对程序代码进行修改和使用 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 控制器
 */
class Snsmember extends AdminControl {

    public function initialize() {
        parent::initialize(); // TODO: Change the autogenerated stub
        Lang::load(base_path() . 'admin/lang/' . config('lang.default_lang') . '/snsmember.lang.php');
    }

    /**
     * 标签列表
     */
    public function index() {
        // 实例化模型
        $snsmember_model = model('snsmember');
        $tag_list = $snsmember_model->getSnsmembertagList('mtag_sort asc', 10);
        View::assign('showpage', $snsmember_model->page_info->render());
        View::assign('tag_list', $tag_list);
        $this->setAdminCurItem('index');
        return View::fetch();
    }

    /**
     * 添加标签
     */
    public function tag_add() {
        if (request()->isPost()) {
            /**
             * 验证
             */
            $data = [
                'membertag_name' => input('post.membertag_name'), 'membertag_sort' => input('post.membertag_sort'),
            ];

            $snsmember_validate = ds_validate('snsmember');
            if (!$snsmember_validate->scene('tag_add')->check($data)) {
                $this->error($snsmember_validate->getError());
            } else {
                /**
                 * 上传图片
                 */
                $img = '';
                if (!empty($_FILES['membertag_img']['name'])) {
                    $res = ds_upload_pic(ATTACH_PATH . '/membertag', 'membertag_img');
                    if ($res['code']) {
                        $img = $res['data']['file_name'];
                    } else {
                        $this->error($res['msg']);
                    }
                }
                $insert = array(
                    'mtag_name' => input('post.membertag_name'),
                    'mtag_sort' => intval(input('post.membertag_sort')),
                    'mtag_recommend' => intval(input('post.membertag_recommend')),
                    'mtag_desc' => trim(input('post.membertag_desc')),
                    'mtag_img' => $img
                );
                $snsmember_model = model('snsmember');
                $result = $snsmember_model->addSnsmembertag($insert);
                if ($result) {
                    $this->log(lang('ds_add') . lang('sns_member_tag') . '[' . input('post.membertag_name') . ']', 1);
                    dsLayerOpenSuccess(lang('ds_common_op_succ'));
                } else {
                    $this->error(lang('ds_common_op_fail'));
                }
            }
        } else {
            return View::fetch();
        }
    }

    /**
     * 编辑标签
     */
    public function tag_edit() {
        // 实例化模型
        if (request()->isPost()) {
            /**
             * 验证
             */
            $data = [
                'membertag_name' => input('post.membertag_name'), 'membertag_sort' => input('post.membertag_sort'),
            ];
            $snsmember_validate = ds_validate('snsmember');
            if (!$snsmember_validate->scene('tag_edit')->check($data)) {
                $this->error($snsmember_validate->getError());
            } else {
                /**
                 * 上传图片
                 */

                $input = '';
                if (!empty($_FILES['membertag_img']['name'])) {
                    $res = ds_upload_pic(ATTACH_PATH . '/membertag', 'membertag_img');
                    if ($res['code']) {
                        $input = $res['data']['file_name'];
                    } else {
                        $this->error($res['msg']);
                    }
                }
                $update = array();
                $update['mtag_id'] = intval(input('post.id'));
                $update['mtag_name'] = trim(input('post.membertag_name'));
                $update['mtag_sort'] = intval(input('post.membertag_sort'));
                $update['mtag_recommend'] = intval(input('post.membertag_recommend'));
                $update['mtag_desc'] = trim(input('post.membertag_desc'));
                $update['mtag_img'] = $input;

                $snsmember_model = model('snsmember');
                $result = $snsmember_model->editSnsmembertag($update);
                if ($result >= 0) {
                    $this->log(lang('ds_edit') . lang('sns_member_tag') . '[' . input('post.membertag_name') . ']', 1);
                    dsLayerOpenSuccess(lang('ds_common_op_succ'));
                } else {
                    $this->error(lang('ds_common_op_fail'));
                }
            }
        } else {
            // 验证
            $mtag_id = intval(input('param.id'));
            if ($mtag_id <= 0) {
                $this->error(lang('param_error'));
            }
            $snsmember_model = model('snsmember');
            $mtag_info = $snsmember_model->getOneSnsmembertag($mtag_id);
            if (empty($mtag_info)) {
                $this->error(lang('param_error'));
            }
            $this->setAdminCurItem('tag_edit');
            //halt($mtag_info);
            View::assign('mtag_info', $mtag_info);
            return View::fetch();
        }
    }

    /**
     * 删除标签
     */
    public function tag_del() {
        $mtag_id = input('param.id');
        $mtag_id_array = ds_delete_param($mtag_id);
        if ($mtag_id_array == FALSE) {
            ds_json_encode('10001', lang('param_error'));
        }
        $condition = array();
        $condition[] = array('mtag_id', 'in', $mtag_id_array);
        $snsmember_model = model('snsmember');
        $result = $snsmember_model->delSnsmembertag($condition);
        if ($result) {
            $this->log(lang('ds_del') . lang('sns_member_tag') . '[ID:' . $mtag_id . ']', 1);
            ds_json_encode('10000', lang('ds_common_del_succ'));
        } else {
            ds_json_encode('10001', lang('ds_common_del_fail'));
        }
    }

    /**
     * 标签所属会员列表
     */
    public function tag_member() {
        // 验证
        $mtag_id = intval(input('param.id'));
        if ($mtag_id <= 0) {
            $this->error(lang('param_error'));
        }
        $snsmember_model = model('snsmember');
        $count = $snsmember_model->getSnstagmemberCount(array('mtag_id' => $mtag_id));
        $tagmember_list = $snsmember_model->getSnsmtagmemberList(array('s.mtag_id' => $mtag_id), 's.*,m.member_avatar,m.member_name', 10, 's.recommend desc, s.member_id asc', $count);
        View::assign('tagmember_list', $tagmember_list);
        View::assign('showpage', $snsmember_model->page_info->render());
        $this->setAdminCurItem('tag_member');
        return View::fetch();
    }

    /**
     * 删除添加标签会员
     */
    public function mtag_del() {
        $snsmember_model = model('snsmember');
        $mtag_id = intval(input('param.id'));
        $member_id = intval(input('param.mid'));
        if ($mtag_id <= 0 || $member_id <= 0) {
            $this->error(lang('miss_argument'));
        }
        // 条件
        $condition = array();
        $condition[] = array('mtag_id', '=', $mtag_id);
        $condition[] = array('member_id', '=', $member_id);
        $result = $snsmember_model->delSnsmtagmember($condition);
        if ($result) {
            $this->log(lang('ds_del') . lang('sns_member_tag') . '[ID:' . $mtag_id . ']', 1);
            $this->success(lang('ds_common_del_succ'));
        } else {
            $this->error(lang('ds_common_del_fail'));
        }
    }

    /**
     * ajax修改
     */
    public function ajax() {
        // 实例化模型
        $snsmember_model = model('snsmember');
        switch (input('param.branch')) {
            /**
             * 更新名称、排序、推荐
             */
            case 'membertag_name':
            case 'membertag_sort':
            case 'membertag_recommend':
                $update = array(
                    'mtag_id' => intval(input('param.id')), input('param.column') => input('param.value')
                );
                $snsmember_model->editSnsmembertag($update);
                echo 'true';
                break;
            /**
             * sns_mtagmember表推荐
             */
            case 'mtagmember_recommend':
                list($where['mtag_id'], $where['member_id']) = explode(',', input('param.id'));
                $update = array(
                    input('param.column') => input('param.value')
                );
                $snsmember_model->editSnsmtagmember($where, $update);
                echo 'true';
                break;
        }
    }

    protected function getAdminItemList() {
        $menu_array = array(
            array(
                'name' => 'index', 'text' => lang('sns_member_tag_manage'), 'url' => (string) url('Snsmember/index')
            ), array(
                'name' => 'tag_add',
                'text' => lang('ds_new'),
                'url' => "javascript:dsLayerOpen('" . (string) url('Snsmember/tag_add') . "','" . lang('ds_new') . "')"
            ),
        );
        if (request()->action() == 'tag_member') {
            $menu_array[] = array(
                'name' => 'tag_member', 'text' => lang('sns_member_member_list'), 'url' => ('#')
            );
        }
        return $menu_array;
    }

}
