<?php

namespace app\admin\controller;
use think\facade\View;
use think\facade\Lang;

/**
 * ============================================================================
 * DSMall多用户商城
 * ============================================================================
 * 版权所有 2014-2028 长沙德尚网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.csdeshang.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！您只能在不用于商业目的的前提下对程序代码进行修改和使用 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 控制器
 */
class Vrgroupbuy extends AdminControl {

    public function initialize() {
        parent::initialize(); // TODO: Change the autogenerated stub
        Lang::load(base_path() . 'admin/lang/'.config('lang.default_lang').'/vrgroupbuy.lang.php');
    }

    /*
     * 列表分类
     */

    public function index() {
        $vrgroupbuyclass_model = model('vrgroupbuyclass');
        $vrgroupbuyclass_list = $vrgroupbuyclass_model->getVrgroupbuyclassList();
        View::assign('vrgroupbuyclass_list', $vrgroupbuyclass_list);
        $this->setAdminCurItem('index');
        return View::fetch();
    }

    /*
     * 添加分类
     */

    public function class_add() {
        if (request()->isPost()) { //添加虚拟抢购分类
            // 数据验证
            $data = [
                'vrgclass_name' => input('post.vrgclass_name'),
                'vrgclass_sort' => input('post.vrgclass_sort'),
            ];
            $vrgroupbuy_validate = ds_validate('vrgroupbuy');
            if (!$vrgroupbuy_validate->scene('class_add')->check($data)) {
                $this->error($vrgroupbuy_validate->getError());
            }

            $params = array();
            $params['vrgclass_name'] = trim(input('post.vrgclass_name'));
            $params['vrgclass_sort'] = intval(input('post.vrgclass_sort'));
            if (intval(input('post.vrgclass_parent_id')) > 0) {
                $params['vrgclass_parent_id'] = input('post.vrgclass_parent_id');
            } else {
                $params['vrgclass_parent_id'] = 0;
            }

            $vrgroupbuyclass_model = model('vrgroupbuyclass');
            $res = $vrgroupbuyclass_model->addVrgroupbuyclass($params); //添加分类
            if ($res) {
                // 删除虚拟抢购分类缓存
                model('groupbuy')->dropCachedData('groupbuyvrclasses');

                $this->log('添加虚拟抢购分类[ID:' . $res . ']', 1);
                
                dsLayerOpenSuccess(lang('ds_common_op_succ'));
            } else {
                $this->error(lang('ds_common_op_fail'));
                
            }
        } else {
            $vrgroupbuyclass_model = model('vrgroupbuyclass'); //一级分类
            $vrgroupbuyclass_list = $vrgroupbuyclass_model->getVrgroupbuyclassList(array('vrgclass_parent_id' => 0));
            View::assign('vrgroupbuyclass_list', $vrgroupbuyclass_list);
            $this->setAdminCurItem('class_add');
            $parent_id = input('param.vrgclass_parent_id');
            View::assign('vrgclass_parent_id', !empty($parent_id) ? intval($parent_id) : 0);
            return View::fetch('class_form');
        }
    }

    /*
     * 编辑分类
     */

    public function class_edit() {
        if (request()->isPost()) {
            // 数据验证
            $data = [
                'vrgclass_name' => input('post.vrgclass_name'),
                'vrgclass_sort' => input('post.vrgclass_sort'),
            ];
            $vrgroupbuy_validate = ds_validate('vrgroupbuy');
            if (!$vrgroupbuy_validate->scene('class_edit')->check($data)) {
                $this->error($vrgroupbuy_validate->getError());
            }

            $params = array();
            $params['vrgclass_name'] = trim(input('post.vrgclass_name'));
            $params['vrgclass_sort'] = intval(input('post.vrgclass_sort'));
            if (intval(input('post.vrgclass_parent_id')) > 0) {
                $params['vrgclass_parent_id'] = input('post.vrgclass_parent_id');
            } else {
                $params['vrgclass_parent_id'] = 0;
            }

            $condition = array(); //条件
            $condition[] = array('vrgclass_id','=',intval(input('param.vrgclass_id')));

            $vrgroupbuyclass_model = model('vrgroupbuyclass');
            $result = $vrgroupbuyclass_model->editVrgroupbuyclass($condition, $params);

            if ($result >= 0) {
                // 删除虚拟抢购分类缓存
                model('groupbuy')->dropCachedData('groupbuyvrclasses');

                $this->log('编辑虚拟抢购分类[ID:' . intval(input('param.vrgclass_id')) . ']', 1);
                dsLayerOpenSuccess(lang('ds_common_op_succ'));
            } else {
                $this->error(lang('ds_common_op_fail'));
            }
        } else {
            $vrgroupbuyclass_model = model('vrgroupbuyclass'); //分类信息
            $class = $vrgroupbuyclass_model->getVrgroupbuyclassInfo(array('vrgclass_id' => intval(input('param.vrgclass_id'))));
            if (empty($class)) {
                $this->error(lang('vrgclass_not_exist'));
            }
            View::assign('class', $class);

            $vrgroupbuyclass_list = $vrgroupbuyclass_model->getVrgroupbuyclassList(array('vrgclass_parent_id' => 0));
            View::assign('vrgroupbuyclass_list', $vrgroupbuyclass_list);
            $this->setAdminCurItem('class_edit');
            return View::fetch('class_form');
        }
    }

    /*
     * 删除分类
     */

    public function class_del() {
        $vrgclass_id =  input('param.vrgclass_id');
        $vrgclass_id_array = ds_delete_param($vrgclass_id);
        if ($vrgclass_id_array == FALSE) {
            ds_json_encode(10001, lang('param_error'));
        }
        $vrgroupbuy_model = model('vrgroupbuyclass');
        foreach ($vrgclass_id_array as $val) {
            $class = $vrgroupbuy_model->getVrgroupbuyclassInfo(array('vrgclass_id' => $val));
            if ($class['vrgclass_parent_id'] == 0) {
                $class = $vrgroupbuy_model->delVrgroupbuyclass(array('vrgclass_parent_id' => $class['vrgclass_id']));
            }
            $class = $vrgroupbuy_model->delVrgroupbuyclass(array('vrgclass_id' => $val));
        }
        // 删除虚拟抢购分类缓存
        model('groupbuy')->dropCachedData('groupbuy_vr_classes');
        $this->log('删除虚拟抢购分类[ID:' . input('post.vrgclass_id') . ']', 1);
        ds_json_encode(10000, lang('ds_common_del_succ'));
    }

    public function ajax() {
        $field = input('param.column');
        $id = input('param.id');
        $value = input('param.value');

        switch (input('param.column')) {
            case 'vrgclass_name':
                if (mb_strlen((string) $value, 'utf-8') > 10)
                    return;
                break;
            case 'vrgclass_sort':
                if ($value < 0 || $value > 255)
                    return;
                break;

            default:
                return;
        }

        switch (input('param.branch')) {
            case 'class':
                $vrgroupbuyclass_model = model('vrgroupbuyclass');
                $res = $vrgroupbuyclass_model->editVrgroupbuyclass(array('vrgclass_id' => $id), array($field => $value));
                if ($res) {
                    // 删除虚拟抢购分类缓存
                    model('groupbuy')->dropCachedData('groupbuy_vr_classes');

                    $this->log('编辑虚拟抢购分类[ID:' . $id . ']', 1);
                    echo 'true';
                } else {
                    echo 'false';
                }
                exit;

            default:
                return;
        }
    }

    protected function getAdminItemList() {

        $menu_array = array(
            array(
                'name' => 'index', 'text' => lang('vrgroupbuy_cate_manage'), 'url' => (string)url('Vrgroupbuy/index')
            ), array(
                'name' => 'class_add', 'text' => lang('vrgclass_add'), 'url' => "javascript:dsLayerOpen('".(string)url('Vrgroupbuy/class_add')."','".lang('vrgclass_add')."')"
            )
        );
        return $menu_array;
    }

}
