<?php

namespace app\common\model;

use think\facade\Db;

/**
 * ============================================================================
 * DSKMS多用户商城
 * ============================================================================
 * 版权所有 2014-2028 长沙德尚网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.csdeshang.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！您只能在不用于商业目的的前提下对程序代码进行修改和使用 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 数据层模型
 */
class MiniproLiveRoomGoods extends BaseModel {

    public $page_info;

    public function getMiniproLiveRoomGoodsList($condition, $field = '*', $pagesize=10, $order = 'minipro_live_room_goods_id desc') {
        if ($pagesize) {
            $result = Db::name('minipro_live_room_goods')->field($field)->where($condition)->order($order)->paginate(['list_rows' => $pagesize, 'query' => request()->param()], false);
            $this->page_info = $result;
            return $result->items();
        } else {
            $result = Db::name('minipro_live_room_goods')->field($field)->where($condition)->order($order)->select()->toArray();
            return $result;
        }
    }

    /**
     * 取单个内容
     * @access public
     * @author csdeshang
     * @param int $id 分类ID
     * @return array 数组类型的返回结果
     */
    public function getMiniproLiveRoomGoodsInfo($condition) {
        $result = Db::name('minipro_live_room_goods')->where($condition)->find();
        return $result;
    }

    /**
     * 新增
     * @access public
     * @author csdeshang
     * @param array $data 参数内容
     * @return bool 布尔类型的返回结果
     */
    public function addMiniproLiveRoomGoods($data) {
        $result = Db::name('minipro_live_room_goods')->insertGetId($data);
        return $result;
    }

    /**
     * 更新信息
     * @access public
     * @author csdeshang
     * @param array $data 数据
     * @param array $condition 条件
     * @return bool
     */
    public function editMiniproLiveRoomGoods($data, $condition) {
        $result = Db::name('minipro_live_room_goods')->where($condition)->update($data);
        return $result;
    }

    /**
     * 删除分类
     * @access public
     * @author csdeshang
     * @param int $condition 记录ID
     * @return bool 
     */
    public function delMiniproLiveRoomGoods($condition) {
        return Db::name('minipro_live_room_goods')->where($condition)->delete();
    }


}
