<?php

namespace app\home\controller;
use think\facade\View;

use think\facade\Lang;

/**
 * ============================================================================
 * DSMall多用户商城
 * ============================================================================
 * 版权所有 2014-2028 长沙德尚网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.csdeshang.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！您只能在不用于商业目的的前提下对程序代码进行修改和使用 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 控制器
 */
class Showhelp extends BaseMall
{
    public function initialize()
    {
        parent::initialize(); // TODO: Change the autogenerated stub
        Lang::load(base_path() . 'home/lang/'.config('lang.default_lang').'/showhelp.lang.php');
    }

    /**
     * 店铺帮助页
     *
     */
    public function index()
    {
        $help_model = model('help');
        $help_list = $help_model->getShowStoreHelpList();
        $helptype_id = intval(input('param.t_id'));//帮助类型编号
        if ($helptype_id < 1 || empty($help_list[$helptype_id])) {
            $type_array = current($help_list);
            $helptype_id = $type_array['helptype_id'];
        }
        View::assign('helptype_id', $helptype_id);
        $help_id = intval(input('param.help_id'));//帮助编号

        if ($help_id < 1 || empty($help_list[$helptype_id]['help_list'][$help_id])) {
            $help = @current($help_list[$helptype_id]['help_list']);
            $help_id = $help['help_id'];
        }else{
            $help = $help_list[$helptype_id]['help_list'][$help_id];
        }
        View::assign('help_id', $help_id);
        View::assign('help_list', $help_list);//左侧帮助类型及帮助
        View::assign('help', $help);//当前帮助
        View::assign('article_list', '');//底部不显示首页的文章分类
        $phone_array = explode(',', config('ds_config.site_phone'));
        View::assign('phone_array', $phone_array);
        View::assign('html_title', config('ds_config.site_name') . ' - ' . lang('business_management_center'));
        return View::fetch($this->template_dir.'store_help');
    }
}