/**
 * wangEditor扩展,增加全屏 查看源码功能
 * 传入均为 editor实例,非css选择器
 * 依赖jquery 如果是layui之类的需要在layui.use方法中使用
 * 全屏功能需要引入 wangEditor-fullscreen.css
 * @author mrzhou@miw.cn
 * @date 2018.8.30 am 10:00
 * @date 2018.9.18 pm 15:00 支持多个编辑器
 * 使用方法:
 * E.fullscreen.init(editor);
 * E.viewSource.init(editor);
 */
 var FullEditor={};
window.wangEditor.fullscreen = {
    init: function(editor) {
    	id = editor.id;
    	FullEditor[id]=editor;
    	editor.isFullScreen = false;
    	toolbar = editor.$toolbarElem[0];
        $(toolbar).append('<div class="w-e-menu btn_fullscreen" οnclick="window.wangEditor.fullscreen.run(\''+id+'\')">全屏</div>');
    },
    run: function(id) {
    	editor = FullEditor[id]; 
    	editor.isFullScreen = editor.isFullScreen;
    	container = $(editor.toolbarSelector);
        container.toggleClass('fullscreen-editor');
        container.find('.btn_fullscreen').text(this.isFullScreen ? '退出全屏': '全屏');
    }
};
var SourceEditor={};
var eid;
window.wangEditor.viewSource = {
    init: function(editor) {
    	id = editor.id;
    	eid=id;
    	editor.isHTML = false;
    	SourceEditor[id]=editor;
        toolbar = editor.$toolbarElem[0];
        
        $(toolbar).append('<div class="w-e-menu btn_viewSource"><a class="_wangEditor_btn_viewsource" href="javascript:window.wangEditor.viewSource.run();">源码</a></div>');
    },
    run: function() {
    	id=eid;
    	editor = SourceEditor[id];
        editor.isHTML = !editor.isHTML;
        _source = editor.txt.html();
        toolbar = editor.$toolbarElem[0];
        if (editor.isHTML) {
            _source = _source.replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/ /g, "&nbsp;");
            $(toolbar).find('.btn_viewSource').css({ "font-weight": "bold" });
        } else {
            _source = editor.txt.text().replace(/&lt;/ig, "<").replace(/&gt;/ig, ">").replace(/&nbsp;/ig, " ");
            $(toolbar).find('.btn_viewSource').css({ "font-weight": "normal" });
            editor.change && editor.change();
        }
        editor.txt.html(_source);
    }
};