package com.lerx.dao.iface;

import java.util.List;

import com.lerx.entities.AlbumArticle;
import com.lerx.entities.AlbumArticleContent;
import com.lerx.entities.User;
import com.lerx.hql.entities.Rs;
import com.lerx.portal.obj.PortalStatInfo;
import com.lerx.portal.obj.WeightValuesOfVisit;

public interface IAlbumArticleDao {
	
	public AlbumArticle add(AlbumArticle article);
	public void modify (AlbumArticle a);
	public void modify (AlbumArticle a, boolean whis,User operator);
	public AlbumArticle findByID(long id);
	public AlbumArticle findByUuid(String uuid);
	public boolean delByID(long id,User deler);
	public void undelByID(long id);
	public void modifyProhibitByID(long id,User arbitrator);
	public void modifyReleaseByID(long id,User arbitrator);
	public void modifyTopOne(long id,boolean state);
	public Rs queryByAid(long aid,int status,int unprohibit,int main,long startT,long endT,int firstResult,int page,int pagesize,boolean asc,int img,int soul,int orderby,WeightValuesOfVisit wvov);
	public Rs queryByAidAndCid(long aid,long cid,int status,int unprohibit,int main,long startT,long endT,int firstResult,int page,int pagesize,boolean asc,int img,int soul,int orderby,WeightValuesOfVisit wvov);
	public Rs queryByGid(long gid,int status,int unprohibit,int main,long startT,long endT,int firstResult,int page,int pagesize,boolean asc,int img,int soul,int orderby,WeightValuesOfVisit wvov);
	public Rs queryByGidAndCid(long gid,long cid,int status,int unprohibit,int main,long startT,long endT,int firstResult,int page,int pagesize,boolean asc,int img,int soul,int orderby,WeightValuesOfVisit wvov);
	public Rs findContentByAlbID(long albID,int firstResult, int page, int pageSize,boolean asc);
	public Rs findByFansUid(long uid,int firstResult, int page, int pageSize,boolean asc, int orderby);
	public Rs findByFansGroupID(long gid,int firstResult, int page, int pageSize,boolean asc, int orderby);
	public long countByAlbumID(long id);
	public long countByOwnUID(long uid);
	public long countByAlbumIDAndOwnUID(long aid,long uid,boolean soul);
	public long countProhibitByAlbumID(long id);
	public long countByPartnerID(long id);
	public AlbumArticleContent findCurrContentByID(long id);
	public AlbumArticleContent findContentByCID(long id);
	public long countAfterArticleID(long aid);
	public long findMaxArtID(long aid);
	public AlbumArticle findNeighbour(long aid,int mod,long albID);
	public List<Long> queryAllPassedID(long aid);
	public PortalStatInfo stat(PortalStatInfo psi);
	public Rs search(long gid,long aid,String key,boolean fulltext,int firstResult,int page,int pagesize);
//	public List<Long> queryNewByFansUid(long uid);
	public boolean moveAllByAid(long fid,long tid);
	
	public List<Long> queryCbHostUrlNull();
	public void excuteDisableAll(long aid);
	public void excuteAbleAll(long aid);

}
