package com.lerx.dao.iface;

import java.util.List;

import com.lerx.entities.User;
import com.lerx.hql.entities.Rs;
import com.lerx.portal.obj.PortalStatInfo;

public interface IUserDao {
	
	public User add(User user);
	public User addAndUuid(User user);
	public void modify(User user);
	public void modifySafely(User user);
	public User findByKeywords(String keywords);
	public User findByID(long id);
	public User findByUsername(String username);
	public User findByUuid(String uuid);
	public User findByMobile(String mobile,long excludeID);
	public User findByEmail(String email,long excludeID);
	public User findByNickname(String nickname);
	public boolean delByID(long id);
	public Rs find(long gid,int page,int pagesize);
	public Rs findByName(String name,int page,int pagesize);
	public User login(User user);
	public void modifypw(User user, String newpw) ;
	public PortalStatInfo stat(PortalStatInfo psi);
	public Rs artsPassedRank(int page,int pagesize);
	public List<Long> findNeverValidPhone();
	public void updateNeverValidPhone(List<Long> list);

}
