package com.lerx.dao.impl;

import java.util.List;

import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

import com.lerx.dao.iface.IAlbgenreDao;
import com.lerx.entities.Albgenre;
import com.lerx.hql.entities.Rs;
import com.lerx.hql.util.HibernateCallbackUtil;

public class AlbgenreDaoImpl extends HibernateDaoSupport implements IAlbgenreDao {

	@Override
	public Albgenre add(Albgenre ag) {
		if (ag.getQuota()<0) {
			ag.setQuota(0);
		}
		if (findByName(ag.getName())!=null) {
			return null;
		}
		this.getHibernateTemplate().save(ag);
		return ag;
	}

	@Override
	public void modify(Albgenre ag) {
		if (ag.getQuota()<0) {
			ag.setQuota(0);
		}
		this.getHibernateTemplate().update(ag);

	}

	@Override
	public Albgenre findByID(long id) {
		return this.getHibernateTemplate().get(Albgenre.class, id);
	}
	
	@Override
	public Albgenre findByName(String name) {
		DetachedCriteria criteria=DetachedCriteria.forClass(Albgenre.class);
		criteria.add(Restrictions.eq("name", name ) );
		List<?> lu=this.getHibernateTemplate().findByCriteria(criteria);
		
		if (lu.size() > 0) { // 如果有子对象，则拒绝删除
			return (Albgenre) lu.get(0);
		}else{
			return null;
		}
	}
	
	@Override
	public Albgenre findByUuid(String uuid) {
		DetachedCriteria criteria=DetachedCriteria.forClass(Albgenre.class);
		criteria.add(Restrictions.eq("uuid", uuid ) );
		@SuppressWarnings("unchecked")
		List<Albgenre> lu = (List<Albgenre>) this.getHibernateTemplate().findByCriteria(criteria);
		if (lu.size() > 0) { 
			return lu.get(0);
		}else{
			return null;
		}
	}
	
	@Override
	public Albgenre findByFolder(String folder) {
		DetachedCriteria criteria=DetachedCriteria.forClass(Albgenre.class);
		criteria.add(Restrictions.eq("folder", folder ) );
		List<?> lu=this.getHibernateTemplate().findByCriteria(criteria);
		if (lu.size() > 0) { // 如果有子对象，则拒绝删除
			return (Albgenre) lu.get(0);
		}else{
			return null;
		}
	}

	@Override
	public boolean delByID(long id) {
		this.getHibernateTemplate().delete(findByID(id));

		if (findByID(id) == null) {
			return true;
		} else {
			return false;
		}
	}

	@Override
	public Rs query(int page, int pagesize, int status, int open) {
		String sqladd="",statusSql,openSql;
		switch (status) {
		case -1:
			statusSql=" a.status is false ";
			break;
		case 0:
			statusSql="";
			break;
		default:
			statusSql=" a.status is true ";
		}
		sqladd += statusSql;
		
		switch (open) {
		case -1:
			openSql=" a.open is false ";
			break;
		case 0:
			openSql="";
			break;
		default:
			openSql=" a.open is true ";
		}
		
		if (!sqladd.trim().equals("") && !openSql.trim().equals("")) {
			sqladd += " and ";
		}
		
		sqladd += openSql;
		
		
		if (!sqladd.trim().equals("")) {
			sqladd = " where " + sqladd;
		}
		
		String hql = "from Albgenre a " + sqladd + " order by a.id desc";
		int firstPlace = 0;
		return HibernateCallbackUtil.getRs(this.getHibernateTemplate(), hql, firstPlace, page, pagesize);
	}

	@Override
	public List<Albgenre> queryAll() {
		List<Albgenre> list = this.getHibernateTemplate().loadAll(Albgenre.class);
		return list;
	}

	

}
