package com.lerx.dao.impl;

import java.util.ArrayList;
import java.util.List;

import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

import com.lerx.dao.iface.IAlbumArticleAttaDao;
import com.lerx.entities.AlbumArticleAtta;

public class AlbumArticleAttaDaoImpl extends HibernateDaoSupport implements IAlbumArticleAttaDao {

	@Override
	public long add(AlbumArticleAtta aa) {
		List<AlbumArticleAtta> list;
		if (aa.getArticle()!=null) {
			list=findByArticleAndFileID(aa.getArticle().getId(),aa.getUf().getId());
			if (list.isEmpty() || list.size()==0) {
				this.getHibernateTemplate().save(aa);
				return aa.getId();
			}else {
				return -409;
			}
		}else {
			if (aa.getUf()==null){
				return -404;
			}
			list=findByFidAndTmpID(aa.getUf().getId(),aa.getTmpID());
			if (list.isEmpty() || list.size()==0) {
				this.getHibernateTemplate().save(aa);
				return aa.getId();
			}else {
				return -409;
			}
		}
		
	}
	
	@Override
	public void modify(AlbumArticleAtta aa) {
		this.getHibernateTemplate().update(aa);
	}

	@Override
	public AlbumArticleAtta findByID(long id) {
		return this.getHibernateTemplate().get(AlbumArticleAtta.class, id);
	}

	@Override
	public boolean delByID(long id) {
		this.getHibernateTemplate().delete(findByID(id));

		if (findByID(id) == null) {
			return true;
		} else {
			return false;
		}
	}

	@Override
	public List<AlbumArticleAtta> findByArticleID(long aid) {
		DetachedCriteria criteria=DetachedCriteria.forClass(AlbumArticleAtta.class);
		criteria.createAlias("article", "a"); 
		criteria.add(Restrictions.eq("a.id", aid ) );
		criteria.addOrder(Order.asc("id") );
		@SuppressWarnings("unchecked")
		List<AlbumArticleAtta> list = (List<AlbumArticleAtta>) this.getHibernateTemplate().findByCriteria(criteria);
		/*String hql="from AlbumArticleAtta a where a.article.id="+aid;
		@SuppressWarnings("unchecked")
		List<AlbumArticleAtta> list = (List<AlbumArticleAtta>) this.getHibernateTemplate().find(hql);*/
		return list;
	}
	
	@Override
	public List<AlbumArticleAtta> findByAidOrTmpID(long aid, long tid) {
		DetachedCriteria criteria=DetachedCriteria.forClass(AlbumArticleAtta.class);
		if (aid>0) {
			criteria.createAlias("article", "a");
			criteria.add(Restrictions.or(Restrictions.eq("tmpID", tid ),Restrictions.eq("a.id", aid ) ));
		}else {
			criteria.add(Restrictions.eq("tmpID", tid ));
		}
		
		criteria.addOrder(Order.asc("id") );
		@SuppressWarnings("unchecked")
		List<AlbumArticleAtta> list = (List<AlbumArticleAtta>) this.getHibernateTemplate().findByCriteria(criteria);
		
		return list;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public List<AlbumArticleAtta> findByFidAndTmpID(long fid, long tid) {
		List<AlbumArticleAtta> list;
		if (fid<=0L || tid<=0L){
			list=new ArrayList<AlbumArticleAtta>();
			return list;
		}
		DetachedCriteria criteria=DetachedCriteria.forClass(AlbumArticleAtta.class);
		criteria.createAlias("uf", "u");
		criteria.add(Restrictions.eq("u.id", fid ) );
		criteria.add(Restrictions.eq("tmpID", tid ) );
		list = (List<AlbumArticleAtta>) this.getHibernateTemplate().findByCriteria(criteria);
		
		/*String hql="from AlbumArticleAtta a where a.uf.id="+fid+" and a.tmpID="+tid;
		list = (List<AlbumArticleAtta>) this.getHibernateTemplate().find(hql);*/
		return list;
	}

	@Override
	public List<AlbumArticleAtta> findByArticleAndFileID(long aid, long uid) {
		
		DetachedCriteria criteria=DetachedCriteria.forClass(AlbumArticleAtta.class);
		criteria.createAlias("article", "a");
		criteria.createAlias("uf", "u");
		criteria.add(Restrictions.eq("a.id", aid ) );
		criteria.add(Restrictions.eq("u.id", uid ) );
		@SuppressWarnings("unchecked")
		List<AlbumArticleAtta> list = (List<AlbumArticleAtta>) this.getHibernateTemplate().findByCriteria(criteria);
		/*String hql="from AlbumArticleAtta a where a.article.id="+aid + " and a.uf.id="+uid;
		@SuppressWarnings("unchecked")
		List<AlbumArticleAtta> list = (List<AlbumArticleAtta>) this.getHibernateTemplate().find(hql);*/
		return list;
	}

	

	

	

}
