package com.lerx.dao.impl;

import java.util.ArrayList;
import java.util.List;

import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

import com.lerx.dao.iface.IAlbumArticleClassifyDao;
import com.lerx.entities.Album;
import com.lerx.entities.AlbumArticleClassify;
import com.lerx.hql.entities.Rs;
import com.lerx.hql.util.HibernateCallbackUtil;
import com.lerx.hql.util.HibernateUtil;

public class AlbumArticleClassifyDaoImpl extends HibernateDaoSupport implements IAlbumArticleClassifyDao {

	@Override
	public AlbumArticleClassify add(AlbumArticleClassify aac) {
		this.getHibernateTemplate().save(aac);
		return aac;
	}

	@Override
	public void modify(AlbumArticleClassify aac) {
		this.getHibernateTemplate().update(aac);

	}

	@Override
	public boolean delByID(long id) {
		AlbumArticleClassify aac = findByID(id);
		aac.setDeled(true);
		aac.setMain(false);
		aac.setOrdn(-99);
		this.getHibernateTemplate().update(aac);
		return true;
	}

	@Override
	public void setMain(long id) {
		AlbumArticleClassify aac = findByID(id);
		String hql = "update AlbumArticleClassify a set a.main=false , a.ordn=(a.ordn+1)"
				+ " where a.deled is false and a.genre.id=" + aac.getGenre().getId();
		HibernateUtil.executeHql(this.getHibernateTemplate(), hql);

		aac = findByID(id);
		aac.setMain(true);
		aac.setOrdn(0);
		this.getHibernateTemplate().update(aac);

		DetachedCriteria criteria = DetachedCriteria.forClass(AlbumArticleClassify.class);
		criteria.add(Restrictions.eq("deled", false));
		criteria.add(Restrictions.eq("genre.id", aac.getGenre().getId()));
		criteria.add(Restrictions.gt("ordn", 0));
		criteria.addOrder(Order.asc("ordn"));
		@SuppressWarnings("unchecked")
		List<AlbumArticleClassify> list = (List<AlbumArticleClassify>) this.getHibernateTemplate()
				.findByCriteria(criteria);
		int n = 0;
		for (AlbumArticleClassify a : list) {
			n++;
			a.setOrdn(n);
			this.getHibernateTemplate().update(a);
		}
		/*
		 * hql="update AlbumArticleClassify a set a.main=true where a.id="+id+
		 * " and a.genre.id="+aac.getGenre().getId();
		 * HibernateUtil.executeHql(this.getHibernateTemplate(), hql);
		 */

	}

	@Override
	public AlbumArticleClassify findByID(long id) {
		return this.getHibernateTemplate().get(AlbumArticleClassify.class, id);
	}

	@Override
	public List<AlbumArticleClassify> findByGID(long gid) {
		DetachedCriteria criteria = DetachedCriteria.forClass(AlbumArticleClassify.class);
		criteria.add(Restrictions.eq("deled", false));
		criteria.add(Restrictions.eq("genre.id", gid));
		criteria.addOrder(Order.asc("ordn"));
		@SuppressWarnings("unchecked")
		List<AlbumArticleClassify> list = (List<AlbumArticleClassify>) this.getHibernateTemplate()
				.findByCriteria(criteria);
		return list;
	}

	@Override
	public List<AlbumArticleClassify> findByAID(long aid) {
		DetachedCriteria criteria = DetachedCriteria.forClass(AlbumArticleClassify.class);
		criteria.add(Restrictions.eq("deled", false));
		criteria.add(Restrictions.eq("album.id", aid));
		@SuppressWarnings("unchecked")
		List<AlbumArticleClassify> list = (List<AlbumArticleClassify>) this.getHibernateTemplate()
				.findByCriteria(criteria);
		return list;
	}

	@Override
	public AlbumArticleClassify findMainByGID(long gid) {

		DetachedCriteria criteria = DetachedCriteria.forClass(AlbumArticleClassify.class);
		criteria.add(Restrictions.eq("genre.id", gid));
		criteria.add(Restrictions.eq("deled", false));
		criteria.add(Restrictions.eq("main", true));

		@SuppressWarnings("unchecked")
		List<AlbumArticleClassify> list = (List<AlbumArticleClassify>) this.getHibernateTemplate()
				.findByCriteria(criteria);
		if (list.isEmpty() || list.size() < 1) {

			return null;
		} else {
			return list.get(0);
		}
	}

	@Override
	public List<AlbumArticleClassify> findReMainByGID(long gid) {
		DetachedCriteria criteria = DetachedCriteria.forClass(AlbumArticleClassify.class);
		criteria.add(Restrictions.eq("genre.id", gid));
		criteria.add(Restrictions.eq("deled", false));
		criteria.add(Restrictions.eq("main", false));

		@SuppressWarnings("unchecked")
		List<AlbumArticleClassify> list = (List<AlbumArticleClassify>) this.getHibernateTemplate()
				.findByCriteria(criteria);
		return list;
	}

	@Override
	public AlbumArticleClassify findMainByAID(long aid) {
		Album album = this.getHibernateTemplate().get(Album.class, aid);
		AlbumArticleClassify aac = findMainByGID(album.getGenre().getId());
		if (aac != null) {
			return aac;
		} else {
			DetachedCriteria criteria = DetachedCriteria.forClass(AlbumArticleClassify.class);
			criteria.add(Restrictions.eq("album.id", aid));
			criteria.add(Restrictions.eq("deled", false));
			criteria.add(Restrictions.eq("main", true));

			@SuppressWarnings("unchecked")
			List<AlbumArticleClassify> list = (List<AlbumArticleClassify>) this.getHibernateTemplate()
					.findByCriteria(criteria);
			if (list.isEmpty() || list.size() < 1) {
				return null;
			} else {
				return list.get(0);
			}
		}
	}

	@Override
	public List<AlbumArticleClassify> findSecondaryByAID(long aid) {
		Album album = this.getHibernateTemplate().get(Album.class, aid);
		DetachedCriteria criteria = DetachedCriteria.forClass(AlbumArticleClassify.class);
		criteria.add(Restrictions.eq("genre.id", album.getGenre().getId()));
		criteria.add(Restrictions.eq("deled", false));
		criteria.add(Restrictions.eq("main", false));
		criteria.addOrder(Order.asc("ordn"));
		List<AlbumArticleClassify> listend = new ArrayList<AlbumArticleClassify>();

		@SuppressWarnings("unchecked")
		List<AlbumArticleClassify> list = (List<AlbumArticleClassify>) this.getHibernateTemplate()
				.findByCriteria(criteria);

		for (AlbumArticleClassify aac : list) {
			listend.add(aac);
		}
		DetachedCriteria criteria2 = DetachedCriteria.forClass(AlbumArticleClassify.class);
		criteria2.add(Restrictions.eq("album.id", album.getId()));
		criteria2.add(Restrictions.eq("deled", false));
		criteria2.add(Restrictions.eq("main", false));
		criteria2.addOrder(Order.asc("ordn"));
		@SuppressWarnings("unchecked")
		List<AlbumArticleClassify> list2 = (List<AlbumArticleClassify>) this.getHibernateTemplate()
				.findByCriteria(criteria2);
		for (AlbumArticleClassify aac : list2) {
			listend.add(aac);
		}

		return listend;

	}

	@Override
	public int maxOrdn(long gid) {
		DetachedCriteria criteria = DetachedCriteria.forClass(AlbumArticleClassify.class);
		criteria.add(Restrictions.eq("genre.id", gid));
		criteria.add(Restrictions.eq("deled", false));
		criteria.setProjection(Projections.max("ordn"));

		@SuppressWarnings("unchecked")
		List<Integer> list = (List<Integer>) this.getHibernateTemplate().findByCriteria(criteria);
		if (list == null || list.isEmpty() || list.size() == 0 || list.get(0) == null) {
			return 0;
		} else {
			return list.get(0);
		}

	}

	@Override
	public int maxOrdnAtAid(long aid) {
		DetachedCriteria criteria = DetachedCriteria.forClass(AlbumArticleClassify.class);
		criteria.add(Restrictions.eq("album.id", aid));
		criteria.add(Restrictions.eq("deled", false));
		criteria.setProjection(Projections.max("ordn"));

		@SuppressWarnings("unchecked")
		List<Integer> list = (List<Integer>) this.getHibernateTemplate().findByCriteria(criteria);
		if (list == null || list.isEmpty() || list.size() == 0 || list.get(0) == null) {
			return 0;
		} else {
			return list.get(0);
		}
	}

	@Override
	public Rs findByMod(int mod, int page, int pagesize) {
		String hql;
		switch (mod) {
		case 1:
			hql = "from AlbumArticleClassify a where a.deled is false and a.album is null order by a.id desc";
			break;
		case 2:
			hql = "from AlbumArticleClassify a where a.deled is false and a.genre is null order by a.id desc";
			break;
		default:
			hql = "from AlbumArticleClassify a where a.deled is false order by a.id desc";
		}
	
		int firstPlace = 0;
		return HibernateCallbackUtil.getRs(this.getHibernateTemplate(), hql, firstPlace, page, pagesize);
	}

}
