package com.lerx.dao.impl;

import java.util.List;

import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

import com.lerx.dao.iface.IAlbumArtsCountDao;
import com.lerx.entities.Album;
import com.lerx.entities.AlbumArtsCount;
import com.lerx.hql.entities.Rs;
import com.lerx.hql.util.HibernateCallbackUtil;

public class AlbumArtsCountDaoImpl extends HibernateDaoSupport implements IAlbumArtsCountDao {

	@Override
	public void modify(AlbumArtsCount aac) {
		this.getHibernateTemplate().saveOrUpdate(aac);
	}

	@Override
	public AlbumArtsCount findByAK(Album album, int timeKey) {
		DetachedCriteria criteria = DetachedCriteria.forClass(AlbumArtsCount.class);
		criteria.createAlias("album", "a");
		criteria.add(Restrictions.eq("a.id", album.getId()));
		criteria.add(Restrictions.eq("timeKey", timeKey));
		@SuppressWarnings("unchecked")
		List<AlbumArtsCount> list = (List<AlbumArtsCount>) this.getHibernateTemplate().findByCriteria(criteria);

		if (list.isEmpty()) {
			return null;
		} else {
			return list.get(0);
		}
	}

	@Override
	public Rs findTopByAKAndGroup(int aid, int timeKey, int mod, int page, int pagesize) {
		String hql;
		String order;
		switch (mod) {
		case 1:
			order = " order by a.passed desc";
			break;
		case 2:
			order = " order by a.soul desc";
			break;
		default:
			order = " order by a.total desc";
		}

		if (aid > 0) {
			hql = "from AlbumArtsCount a where a.album.genre.id=" + aid + "and a.timeKey=" + timeKey + order;
		} else {
			hql = "from AlbumArtsCount a where a.timeKey=" + timeKey + order;
		}

		return HibernateCallbackUtil.getRs(this.getHibernateTemplate(), hql, 0, page, pagesize);
	}

	@Override
	public Rs findTopByAKAndGroup(String gidStr, int timeKey, int mod, int page, int pagesize) {
		String hql;
		String order;
		switch (mod) {
		case 1:
			order = " order by a.passed desc";
			break;
		case 2:
			order = " order by a.soul desc";
			break;
		default:
			order = " order by a.total desc";
		}
		
		String[] sArray = gidStr.split("_");
		String hqlWhere="";
		int gidtmp;
		for (int step = 0; step < sArray.length; step++) {
			if (sArray[step]!=null && !sArray[step].trim().equals("")){
				gidtmp=Integer.parseInt(sArray[step]);
				if (gidtmp>0){
					if (hqlWhere.equals("")){
						hqlWhere += " a.album.genre.id="+gidtmp + " ";
					}else{
						hqlWhere += " or a.album.genre.id="+gidtmp + " ";
					}
				}
			}
		}

		if (hqlWhere.trim().equals("")) {
			hql = "from AlbumArtsCount a where a.timeKey="+timeKey+ order;
			
		} else {
			hqlWhere = " ("+hqlWhere + ") ";
			hql = "from AlbumArtsCount a where " + hqlWhere  + "and a.timeKey="+timeKey+ order;
		}

		return HibernateCallbackUtil.getRs(this.getHibernateTemplate(), hql, 0, page, pagesize);
	}

	@Override
	public long countByAid(long aid) {
		DetachedCriteria criteria=DetachedCriteria.forClass(AlbumArtsCount.class);
		criteria.createAlias("album", "a"); 
		criteria.add(Restrictions.eq("a.id", aid ) );
		criteria.setProjection(Projections.rowCount());
		@SuppressWarnings("unchecked")
		List<Long> list = (List<Long>) this.getHibernateTemplate().findByCriteria(criteria);
		
		return list.get(0);
	}

}
