package com.lerx.dao.impl;

import java.util.List;

import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

import com.lerx.dao.iface.IAlbumExternalLinkDao;
import com.lerx.entities.AlbumExternalLink;

public class AlbumExternalLinkDaoImpl extends HibernateDaoSupport implements IAlbumExternalLinkDao {

	@Override
	public AlbumExternalLink add(AlbumExternalLink link) {
		this.getHibernateTemplate().save(link);
		return link;
	}
	
	@Override
	public void modify(AlbumExternalLink link) {
		this.getHibernateTemplate().update(link);
		
	}

	@Override
	public AlbumExternalLink findByID(long id) {
		return this.getHibernateTemplate().get(AlbumExternalLink.class, id);
	}

	@Override
	public boolean delByID(long id) {
		AlbumExternalLink link=findByID(id);
		link.setDeled(true);
		this.getHibernateTemplate().update(link);
		return true;
	}

	@Override
	public List<AlbumExternalLink> findByAid(long aid,int ord) {
		if (aid<=0) {
			return null;
		}
		DetachedCriteria criteria=DetachedCriteria.forClass(AlbumExternalLink.class);
		criteria.createAlias("album", "a");
		criteria.add(Restrictions.eq("a.id", aid ));
		criteria.add(Restrictions.eq("deled", false ));
		if (ord==0) {
			criteria.addOrder(Order.asc("id") );
		}else {
			criteria.addOrder(Order.desc("id") );
		}
		
		@SuppressWarnings("unchecked")
		List<AlbumExternalLink> list = (List<AlbumExternalLink>) this.getHibernateTemplate().findByCriteria(criteria);
		
		return list;
	}

}
