package com.lerx.dao.impl;

import java.util.List;

import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

import com.lerx.dao.iface.IAlbumFansDao;
import com.lerx.entities.AlbumFans;
import com.lerx.hql.entities.Rs;
import com.lerx.hql.util.HibernateCallbackUtil;

public class AlbumFansDaoImpl extends HibernateDaoSupport implements IAlbumFansDao {

	@Override
	public long add(AlbumFans fans) {
		this.getHibernateTemplate().save(fans);
		return fans.getId();
	}

	@Override
	public AlbumFans findByID(long id) {
		return this.getHibernateTemplate().get(AlbumFans.class, id);
	}

	@Override
	public boolean delByID(long id) {
		this.getHibernateTemplate().delete(findByID(id));

		if (findByID(id) == null) {
			return true;
		} else {
			return false;
		}
	}
	
	@Override
	public void modify(AlbumFans fans) {
		this.getHibernateTemplate().update(fans);
		
	}

	@Override
	public AlbumFans findByUidAndAid(long uid, long aid) {
		DetachedCriteria criteria=DetachedCriteria.forClass(AlbumFans.class);
		criteria.createAlias("user", "u");
		criteria.createAlias("tagAlb", "a");
		criteria.add(Restrictions.eq("u.id", uid ) );
		criteria.add(Restrictions.eq("a.id", aid ) );
		
		@SuppressWarnings("unchecked")
		List<AlbumFans> lu=(List<AlbumFans>) this.getHibernateTemplate().findByCriteria(criteria);
		
		/*String hql = "from AlbumFans f where f.user.id=?0 and f.tagAlb.id=?1";
		@SuppressWarnings("unchecked")
		List<AlbumFans> lu=(List<AlbumFans>) this.getHibernateTemplate().find(hql,uid,aid);*/
		
		if (lu.size() > 0) { 
			return lu.get(0);
		}else{
			return null;
		}
	}

	@Override
	public List<AlbumFans> findByAid(long aid) {
		DetachedCriteria criteria=DetachedCriteria.forClass(AlbumFans.class);
		criteria.createAlias("tagAlb", "a");
		criteria.add(Restrictions.eq("a.id", aid ) );
		
		@SuppressWarnings("unchecked")
		List<AlbumFans> lu=(List<AlbumFans>) this.getHibernateTemplate().findByCriteria(criteria);
		
		/*String hql = "from AlbumFans f where f.tagAlb.id=?0";
		@SuppressWarnings("unchecked")
		List<AlbumFans> lu=(List<AlbumFans>) this.getHibernateTemplate().find(hql,aid);*/
		return lu;
	}

	@Override
	public Rs queryByAid(long aid, int firstResult, int page, int pagesize) {
		String hql = "from AlbumFans f where f.tagAlb.id="+aid;
		int firstPlace = 0;
		return HibernateCallbackUtil.getRs(this.getHibernateTemplate(), hql, firstPlace, page, pagesize);
	}

	@Override
	public List<AlbumFans> findByUid(long uid) {
		DetachedCriteria criteria=DetachedCriteria.forClass(AlbumFans.class);
		criteria.createAlias("user", "u");
		criteria.add(Restrictions.eq("u.id", uid ) );
		
		@SuppressWarnings("unchecked")
		List<AlbumFans> lu=(List<AlbumFans>) this.getHibernateTemplate().findByCriteria(criteria);
		
		/*String hql = "from AlbumFans f where f.user.id=?0";
		@SuppressWarnings("unchecked")
		List<AlbumFans> lu=(List<AlbumFans>) this.getHibernateTemplate().find(hql,uid);*/
		return lu;
	}
	
	@Override
	public List<AlbumFans> findByGid(long gid) {
		DetachedCriteria criteria=DetachedCriteria.forClass(AlbumFans.class);
		criteria.createAlias("fg", "g");
		criteria.add(Restrictions.eq("g.id", gid ) );
		
		@SuppressWarnings("unchecked")
		List<AlbumFans> lu=(List<AlbumFans>) this.getHibernateTemplate().findByCriteria(criteria);
		
		return lu;
	}

	@Override
	public Rs queryByUid(long uid, int firstResult, int page, int pagesize) {
		String hql = "from AlbumFans f where f.user.id="+uid + " order by f.id desc";
		int firstPlace = 0;
		return HibernateCallbackUtil.getRs(this.getHibernateTemplate(), hql, firstPlace, page, pagesize);
	}
	
	@Override
	public Rs queryByFGid(long fgid, int firstResult, int page, int pagesize) {
		String hql = "from AlbumFans f where f.fg.id="+fgid + " order by f.id desc";
		int firstPlace = 0;
		return HibernateCallbackUtil.getRs(this.getHibernateTemplate(), hql, firstPlace, page, pagesize);
	}

	@Override
	public Rs queryNewPublishAlbumByUid(long uid, int firstResult, int page, int pagesize) {
		String hql = "from Album a,AlbumArticle b,AlbumFans f where f.user.id="+uid+" and b.album.id=a.id and f.tagAlb.id=a.id and max(b.id)>f.lastViewedID";
		int firstPlace = 0;
		return HibernateCallbackUtil.getRs(this.getHibernateTemplate(), hql, firstPlace, page, pagesize);
	}
	

}
