package com.lerx.dao.impl;

import java.util.List;

import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

import com.lerx.dao.iface.IAlbumPartnerDao;
import com.lerx.entities.Album;
import com.lerx.entities.AlbumPartner;
import com.lerx.hql.util.HibernateUtil;

public class AlbumPartnerDaoImpl extends HibernateDaoSupport implements IAlbumPartnerDao {

	@Override
	public AlbumPartner add(AlbumPartner partner) {
		this.getHibernateTemplate().save(partner);
		return partner;
	}

	@Override
	public AlbumPartner findByID(long id) {
		return this.getHibernateTemplate().get(AlbumPartner.class, id);
	}

	@Override
	public boolean delByID(long id) {
		this.getHibernateTemplate().delete(findByID(id));

		if (findByID(id) == null) {
			return true;
		} else {
			return false;
		}
	}

	@Override
	public void modify(AlbumPartner partner) {
		this.getHibernateTemplate().update(partner);

	}
	
	@Override
	public AlbumPartner findByAIDAndUid(long aid, long uid) {
		DetachedCriteria criteria=DetachedCriteria.forClass(AlbumPartner.class);
		criteria.createAlias("album", "a");
		criteria.createAlias("user", "u");
		criteria.add(Restrictions.eq("u.id", uid ) );
		criteria.add(Restrictions.eq("a.id", aid ) );
		
		@SuppressWarnings("unchecked")
		List<AlbumPartner> lu=(List<AlbumPartner>) this.getHibernateTemplate().findByCriteria(criteria);
		
		/*String hql = "from AlbumPartner a where a.album.id=?0 and a.user.id=?1";
		@SuppressWarnings("unchecked")
		List<AlbumPartner> lu=(List<AlbumPartner>) this.getHibernateTemplate().find(hql,aid,uid);*/
		if (lu.isEmpty() || lu.size()==0) {
			return null;
		}else {
			return lu.get(0);
		}
	}
	
	@Override
	public List<AlbumPartner> findByUid(long uid) {
		DetachedCriteria criteria=DetachedCriteria.forClass(AlbumPartner.class);
		criteria.createAlias("user", "u");
		criteria.add(Restrictions.eq("u.id", uid ) );
		
		@SuppressWarnings("unchecked")
		List<AlbumPartner> lu=(List<AlbumPartner>) this.getHibernateTemplate().findByCriteria(criteria);
		return lu;
		/*String hql = "from AlbumPartner a where a.album.id=?0 and a.user.id=?1";
		@SuppressWarnings("unchecked")
		List<AlbumPartner> lu=(List<AlbumPartner>) this.getHibernateTemplate().find(hql,aid,uid);*/
		
	}


	@Override
	public List<AlbumPartner> queryByAid(long aid) {
		DetachedCriteria criteria=DetachedCriteria.forClass(AlbumPartner.class);
		criteria.createAlias("album", "a");
		criteria.add(Restrictions.eq("a.id", aid ) );
		
		@SuppressWarnings("unchecked")
		List<AlbumPartner> lu=(List<AlbumPartner>) this.getHibernateTemplate().findByCriteria(criteria);
		
		/*
		String hql = "from AlbumPartner a where a.album.id=?0";
		@SuppressWarnings("unchecked")
		List<AlbumPartner> lu=(List<AlbumPartner>) this.getHibernateTemplate().find(hql,aid);*/
		return lu;
	}

	@Override
	public long countByAlbumID(long id) {
		DetachedCriteria criteria=DetachedCriteria.forClass(AlbumPartner.class);
		criteria.setProjection(Projections.rowCount());
		criteria.createAlias("album", "a");
		criteria.add(Restrictions.eq("a.id", id ) );
		
		@SuppressWarnings("unchecked")
		List<Long> list = (List<Long>) this.getHibernateTemplate().findByCriteria(criteria);
		return list.get(0);
		
//		String hql = "select count(*) from AlbumPartner a where a.album.id="+id;
		/*@SuppressWarnings("unchecked")
		List<Long> list = (List<Long>) this.getHibernateTemplate().find(hql,id);*/
//		return HibernateUtil.countHql(this.getHibernateTemplate(), hql);
	}

	@Override
	public void excuteLead(long id, boolean status) {
		String hql="";
		AlbumPartner partner=findByID(id);
		if (!status) {
			
			partner.setLead(false);
			this.getHibernateTemplate().update(partner);
			
		}else {
			
			hql="update AlbumPartner p set p.lead=false where p.album.id="+partner.getAlbum().getId();
			HibernateUtil.executeHql(this.getHibernateTemplate(), hql);
			partner.setLead(true);
			this.getHibernateTemplate().update(partner);
			
		}
		
	}

	@Override
	public long findLeaderUid(long aid) {
		DetachedCriteria criteria=DetachedCriteria.forClass(AlbumPartner.class);
		criteria.createAlias("album", "a");
		criteria.add(Restrictions.eq("a.id", aid ) );
		criteria.add(Restrictions.eq("lead", true ) );
		
		@SuppressWarnings("unchecked")
		List<AlbumPartner> lu=(List<AlbumPartner>) this.getHibernateTemplate().findByCriteria(criteria);
		if (lu!=null && !lu.isEmpty() && lu.size()>0) {
			AlbumPartner partner=lu.get(0);
			return partner.getUser().getId();
		}else {
			Album album=this.getHibernateTemplate().get(Album.class, aid);
			return album.getLeader().getId();
		}
		
	}


}
