package com.lerx.dao.impl;

import java.util.List;

import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

import com.lerx.dao.iface.ICommentBridgeDao;
import com.lerx.entities.CommentBridge;

public class CommentBridgeDaoImpl extends HibernateDaoSupport implements ICommentBridgeDao {

	@Override
	public void modify(CommentBridge cb) {
		this.getHibernateTemplate().update(cb);

	}

	@Override
	public CommentBridge findByID(long id) {
		return this.getHibernateTemplate().get(CommentBridge.class, id);
	}
	
	@Override
	public CommentBridge findByUuid(String uuid) {
		DetachedCriteria criteria=DetachedCriteria.forClass(CommentBridge.class);
		criteria.add(Restrictions.eq("uuid", uuid ) );
		@SuppressWarnings("unchecked")
		List<CommentBridge> lu = (List<CommentBridge>) this.getHibernateTemplate().findByCriteria(criteria);
		if (lu.size() > 0) { 
			return lu.get(0);
		}else{
			return null;
		}
	}

	@Override
	public long countByUid(long uid) {
		DetachedCriteria criteria=DetachedCriteria.forClass(CommentBridge.class);
		criteria.setProjection(Projections.rowCount());
		criteria.createAlias("user", "u");
		criteria.add(Restrictions.eq("u.id", uid ) );
		
		@SuppressWarnings("unchecked")
		List<Long> list = (List<Long>) this.getHibernateTemplate().findByCriteria(criteria);
		return list.get(0);
		
		/*String hql="select count(*) from CommentBridge c where c.user.id="+uid;
		return HibernateUtil.countHql(this.getHibernateTemplate(), hql);*/
		/*@SuppressWarnings("unchecked")
		List<Long> list = (List<Long>) this.getHibernateTemplate().find(hql,uid);
		return list.get(0);*/
	}

}
