package com.lerx.dao.impl;

import java.util.List;

import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

import com.lerx.dao.iface.ICommentThreadDao;
import com.lerx.entities.CommentThread;
import com.lerx.hql.entities.Rs;
import com.lerx.hql.util.HibernateCallbackUtil;
import com.lerx.sys.util.StringUtil;

public class CommentThreadDaoImpl extends HibernateDaoSupport implements ICommentThreadDao {

	@Override
	public CommentThread add(CommentThread ct) {
		ct.setContent(StringUtil.htmlFilter(ct.getContent(),true));
		this.getHibernateTemplate().save(ct.getPoll());
		this.getHibernateTemplate().save(ct.getSrt());
		this.getHibernateTemplate().save(ct);
		return ct;
	}

	@Override
	public CommentThread findByID(long id) {
		return this.getHibernateTemplate().get(CommentThread.class, id);
	}
	
	@Override
	public CommentThread findByUuid(String uuid) {
		DetachedCriteria criteria=DetachedCriteria.forClass(CommentThread.class);
		criteria.add(Restrictions.eq("uuid", uuid ) );
		@SuppressWarnings("unchecked")
		List<CommentThread> lu = (List<CommentThread>) this.getHibernateTemplate().findByCriteria(criteria);
		if (lu.size() > 0) { 
			return lu.get(0);
		}else{
			return null;
		}
	}

	@Override
	public boolean delByID(long id) {
		this.getHibernateTemplate().delete(findByID(id));

		if (findByID(id) == null) {
			return true;
		} else {
			return false;
		}
	}

	@Override
	public void modify(CommentThread ct) {
		this.getHibernateTemplate().update(ct);

	}

	@Override
	public Rs queryByBid(long bid, int page, int pagesize, boolean asc, int status,boolean deletedShow) {
		String statusSql;
		switch (status) {
		case -1:
			statusSql="and c.status is false ";
			break;
		case 0:
			statusSql="";
			break;
		default:
			statusSql="and c.status is true ";
		}
		String deletedSql="";
		if (!deletedShow) {
			deletedSql="and c.deleted=false ";
		}
		String hql;
		if (bid>0) {
			
			hql = "from CommentThread c where c.cb.id="+bid+deletedSql+statusSql+" order by c.id desc";
		}else {
			
			hql = "from CommentThread c where "+deletedSql+statusSql+" order by c.id desc";
			hql=StringUtil.strReplace(hql, "  ", " ");
			hql=StringUtil.strReplace(hql, "where and", "where ");
			
		}
		
		int firstPlace = 0;
		return HibernateCallbackUtil.getRs(this.getHibernateTemplate(), hql, firstPlace, page, pagesize);
	}

	@Override
	public long countByUid(long uid) {
		DetachedCriteria criteria=DetachedCriteria.forClass(CommentThread.class);
		criteria.setProjection(Projections.rowCount());
		criteria.createAlias("user", "u");
		criteria.add(Restrictions.eq("u.id", uid ) );
		
		@SuppressWarnings("unchecked")
		List<Long> list = (List<Long>) this.getHibernateTemplate().findByCriteria(criteria);
		return list.get(0);
		/*String hql="select count(*) from CommentThread c where c.user.id="+uid;
		@SuppressWarnings("unchecked")
		List<Long> list = (List<Long>) this.getHibernateTemplate().find(hql,uid);
		return list.get(0);*/
	}

	@SuppressWarnings("unchecked")
	@Override
	public long countByBid(long bid) {
		DetachedCriteria criteria=DetachedCriteria.forClass(CommentThread.class);
		criteria.setProjection(Projections.rowCount());
		criteria.add(Restrictions.eq("status", true ) );
		criteria.add(Restrictions.eq("deleted", false ) );
		
		if (bid>0L) {
			criteria.add(Restrictions.eq("deleted", false ) );
			criteria.createAlias("cb", "c");
			criteria.add(Restrictions.eq("c.id", bid ) );
//			hql="select count(*) from CommentThread c where c.status is true and c.deleted=false and c.cb.id="+bid;
//			list = (List<Long>) this.getHibernateTemplate().find(hql,bid);
		}/*else {
			hql="select count(*) from CommentThread c where c.status is true and c.deleted=false";
			list = (List<Long>) this.getHibernateTemplate().find(hql);
		}*/
		
		List<Long> list = (List<Long>) this.getHibernateTemplate().findByCriteria(criteria);
		
		return list.get(0);
	}

}
