package com.lerx.dao.impl;

import java.util.List;

import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

import com.lerx.dao.iface.IFansGroupDao;
import com.lerx.entities.FansGroup;
import com.lerx.hql.entities.Rs;
import com.lerx.hql.util.HibernateCallbackUtil;

public class FansGroupDaoImpl extends HibernateDaoSupport implements IFansGroupDao {

	@Override
	public FansGroup add(FansGroup fg) {
		this.getHibernateTemplate().save(fg);
		return fg;
	}

	@Override
	public void modify(FansGroup fg) {
		this.getHibernateTemplate().update(fg);
	}

	@Override
	public FansGroup findByID(long id) {
		return this.getHibernateTemplate().get(FansGroup.class, id);
	}
	
	@Override
	public FansGroup findByName(long uid, String name,long excludeID) {
		if (name==null || name.trim().equals("")) {
			return null;
		}
		name=name.trim();
		DetachedCriteria criteria=DetachedCriteria.forClass(FansGroup.class);
		criteria.createAlias("founder", "u"); 
		criteria.add(Restrictions.eq("u.id", uid ) );
		criteria.add(Restrictions.eq("name", name ) );
		criteria.add(Restrictions.eq("deled", false ) );
		if (excludeID>0L) {
			criteria.add(Restrictions.ne("id", excludeID ) );
		}
		List<?> lu=this.getHibernateTemplate().findByCriteria(criteria);
		if (lu.size() > 0) { 
			return (FansGroup) lu.get(0);
		}else{
			return null;
		}
	}


	@Override
	public void delByID(long id) {
		FansGroup fg=findByID(id);
		fg.setDeled(true);
		modify(fg);
	}

	@Override
	public Rs find(long uid, int page, int pagesize, int ordn) {
		String ordstr;
		if (ordn==0) {
			ordstr="desc";
		}else {
			ordstr="asc";
		}
		String hql = "from FansGroup f where f.founder.id="+uid+" and f.deled is false order by f.id "+ordstr;
		int firstPlace = 0;
		return HibernateCallbackUtil.getRs(this.getHibernateTemplate(), hql, firstPlace, page, pagesize);
	}

	@Override
	public List<FansGroup> find(long uid, int ordn) {
		DetachedCriteria criteria=DetachedCriteria.forClass(FansGroup.class);
		criteria.createAlias("founder", "u"); 
		criteria.add(Restrictions.eq("u.id", uid ) );
		criteria.add(Restrictions.eq("deled", false ) );
		if (ordn==0) {
			criteria.addOrder( Order.desc("id") );
		}else {
			criteria.addOrder( Order.asc("id") );
		}
		@SuppressWarnings("unchecked")
		List<FansGroup> list = (List<FansGroup>) this.getHibernateTemplate().findByCriteria(criteria);
		return list;
	}
	
}
