package com.lerx.dao.impl;

import java.util.List;

import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

import com.lerx.dao.iface.ILoginConnecterDao;
import com.lerx.entities.LoginConnecter;
import com.lerx.entities.User;
import com.lerx.hql.entities.Rs;
import com.lerx.hql.util.HibernateCallbackUtil;
import com.lerx.hql.util.HibernateUtil;

public class LoginConnecterDaoImpl extends HibernateDaoSupport implements ILoginConnecterDao {

	@Override
	public LoginConnecter add(LoginConnecter lc,int otype) {
		this.getHibernateTemplate().save(lc);
		return lc;
		
	}

	@Override
	public LoginConnecter findByID(long id) {
		return this.getHibernateTemplate().get(LoginConnecter.class, id);
	}

	@Override
	public LoginConnecter findByUID(long uid) {
		DetachedCriteria criteria=DetachedCriteria.forClass(LoginConnecter.class);
		criteria.createAlias("user", "u"); 
		criteria.add(Restrictions.eq("u.id", uid ) );
		
		@SuppressWarnings("unchecked")
		List<LoginConnecter> list=(List<LoginConnecter>) this.getHibernateTemplate().findByCriteria(criteria);
		if (list==null || list.isEmpty()) {
			return null;
		}
		return list.get(0);
		
		/*String hql = "from LoginConnecter l where l.user is not null and l.user.id=?0";
		List<?> lu =  this.getHibernateTemplate().find(hql, uid);
		if (lu.size() > 0) { // 如果有子对象，则拒绝删除
			return (LoginConnecter) lu.get(0);
		} else {
			return null;
		}*/
	}

	@Override
	public LoginConnecter findByOpenID(String openID, int otype) {
		if (openID==null || openID.trim().equals("")) {
			return null;
		}
		
		DetachedCriteria criteria=DetachedCriteria.forClass(LoginConnecter.class);
		
		switch (otype) {
		case 1:
			criteria.add(Restrictions.eq("openIDAtWeChat", openID ) );
//			hql = "from LoginConnecter l where l.openIDAtWeChat=?0";
			break;
		case 2:
			criteria.add(Restrictions.eq("openIDAtWeibo", openID ) );
//			hql = "from LoginConnecter l where l.openIDAtWeibo=?0";
			break;
		default:
			criteria.add(Restrictions.eq("openIDAtQQ", openID ) );
//			hql = "from LoginConnecter l where l.openIDAtQQ=?0";

		}

		@SuppressWarnings("unchecked")
		List<LoginConnecter> lu=(List<LoginConnecter>) this.getHibernateTemplate().findByCriteria(criteria);
		
		
		/*@SuppressWarnings("unchecked")
		List<LoginConnecter> lu = (List<LoginConnecter>) this.getHibernateTemplate().find(hql, openID);*/
		if (lu.size() > 0) { // 如果有子对象，则拒绝删除
			return lu.get(0);
		} else {
			return null;
		}
	}
	
	@Override
	public User findUserByOpenID(String openID, int otype) {
		LoginConnecter lc = findByOpenID(openID, otype);
		if (lc!=null) {
			return lc.getUser();
		}else {
			return null;
		}
		
	}

	@Override
	public void modify(LoginConnecter lc) {
		this.getHibernateTemplate().update(lc);

	}

	@Override
	public boolean delByID(long id) {
		this.getHibernateTemplate().delete(findByID(id));

		if (findByID(id) == null) {
			return true;
		} else {
			return false;
		}
	}
	
	@Override
	public void delByUID(long uid) {
		
		
		String hql = "delete from LoginConnecter l where l.user.id="+uid;
		HibernateUtil.executeHql(this.getHibernateTemplate(), hql);
		
		/*
		 * DetachedCriteria criteria=DetachedCriteria.forClass(LoginConnecter.class);
		 * criteria.createAlias("user", "u"); criteria.add(Restrictions.eq("u.id", uid )
		 * );
		 * 
		 * this.getHibernateTemplate().delete(entity);
		 */
		
		// TODO Auto-generated method stub
	}

	@Override
	public Rs find(int page, int pagesize, int otype) {
		String hql = "from LoginConnecter l where l.otype="+otype+" order by l.id desc";
		int firstPlace = 0;
		return HibernateCallbackUtil.getRs(this.getHibernateTemplate(), hql, firstPlace, page, pagesize);
	}

	


}
