package com.lerx.dao.impl;

import java.util.List;

import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

import com.lerx.dao.iface.IMailTeamUnitDao;
import com.lerx.entities.MailTeamUnit;
import com.lerx.hql.entities.Rs;
import com.lerx.hql.util.HibernateCallbackUtil;

public class MailTeamUnitDaoImpl extends HibernateDaoSupport implements IMailTeamUnitDao {

	@Override
	public MailTeamUnit add(MailTeamUnit unit) {
		this.getHibernateTemplate().save(unit);
		return unit;
	}

	@Override
	public void modify(MailTeamUnit unit) {
		this.getHibernateTemplate().update(unit);

	}

	@Override
	public MailTeamUnit findByID(long id) {
		return this.getHibernateTemplate().get(MailTeamUnit.class, id);
	}

	@Override
	public void delByID(long id) {
		this.getHibernateTemplate().delete(findByID(id));

	}

	@Override
	public List<MailTeamUnit> findCurr() {
		DetachedCriteria criteria = DetachedCriteria.forClass(MailTeamUnit.class);
		criteria.add(Restrictions.eq("deled", false));
		criteria.add(Restrictions.eq("status", false));
		@SuppressWarnings("unchecked")
		List<MailTeamUnit> lu = (List<MailTeamUnit>) this.getHibernateTemplate().findByCriteria(criteria);
		return lu;
	}

	@Override
	public Rs find(int status, int page, int pagesize) {
		String hqlAdd = "";

		switch (status) {
		case 1:
			hqlAdd = " and a.status is true ";
			break;
		case -1:
			hqlAdd = " and a.status is false ";
			break;
		case 0:
			break;
		}
		String hql = "from MailTeamUnit a where a.deled is false " + hqlAdd + " order by a.id desc";
		int firstPlace = 0;
		return HibernateCallbackUtil.getRs(this.getHibernateTemplate(), hql, firstPlace, page, pagesize);
	}

	@Override
	public Rs findByUserID(int status, long uid, int page, int pagesize) {
		String hqlAdd = "";

		switch (status) {
		case 1:
			hqlAdd = " and a.status is true ";
			break;
		case -1:
			hqlAdd = " and a.status is false ";
			break;
		case 0:
			break;
		}
		String hql = "from MailTeamUnit a where a.deled is false and a.creater.id=" + uid + hqlAdd
				+ " order by a.id desc";
		int firstPlace = 0;
		return HibernateCallbackUtil.getRs(this.getHibernateTemplate(), hql, firstPlace, page, pagesize);
	}

}
