package com.lerx.dao.impl;

import java.util.List;

import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

import com.lerx.dao.iface.IMsgDao;
import com.lerx.entities.Msg;
import com.lerx.hql.entities.Rs;
import com.lerx.hql.util.HibernateCallbackUtil;
import com.lerx.hql.util.HibernateUtil;

public class MsgDaoImpl extends HibernateDaoSupport implements IMsgDao {

	@Override
	public Msg add(Msg msg) {
		this.getHibernateTemplate().save(msg);
		return msg;
	}

	@Override
	public Msg findByID(long id) {
		return this.getHibernateTemplate().get(Msg.class, id);
	}
	
	@Override
	public Msg findByUrl(String url) {
		if (url==null || url.trim().equals("")) {
			return null;
		}
		DetachedCriteria criteria=DetachedCriteria.forClass(Msg.class);
		criteria.add(Restrictions.eq("url", url ) );
		@SuppressWarnings("unchecked")
		List<Msg> lu=(List<Msg>) this.getHibernateTemplate().findByCriteria(criteria);
		if (lu!=null && !lu.isEmpty() && lu.size()>0) {
			return lu.get(0);
		}else {
			return null;
		}
		
	}
	
	@Override
	public boolean delByID(long id) {
		this.getHibernateTemplate().delete(findByID(id));
		return true;
	}

	
	@Override
	public void readByID(long id) {
		Msg msg=findByID(id);
		msg.setStatus(false);
		this.getHibernateTemplate().update(msg);
	}

	@Override
	public List<Msg> findByRecipientUID(long uid) {
		DetachedCriteria criteria=DetachedCriteria.forClass(Msg.class);
		criteria.createAlias("recipient", "ru");
		criteria.add(Restrictions.eq("ru.id", uid ) );
		criteria.add(Restrictions.eq("status", true ) );
		@SuppressWarnings("unchecked")
		List<Msg> lu=(List<Msg>) this.getHibernateTemplate().findByCriteria(criteria);
		return lu;
	}

	@Override
	public List<Long> findIDByRecipientUID(long uid) {
		DetachedCriteria criteria=DetachedCriteria.forClass(Msg.class);
		criteria.createAlias("recipient", "ru");
		criteria.add(Restrictions.eq("ru.id", uid ) );
		criteria.add(Restrictions.eq("status", true ) );
		criteria.setProjection(Projections.property("id"));
		@SuppressWarnings("unchecked")
		List<Long> lu= (List<Long>) this.getHibernateTemplate().findByCriteria(criteria);
		return lu;
	}

	@Override
	public void setAllReadByUID(long uid) {
		String hql="update Msg m set status = false where m.recipient.id="+uid;
		HibernateUtil.executeHql(this.getHibernateTemplate(), hql);
//		this.getHibernateTemplate().bulkUpdate(hql, uid);
		/*
		 * User user= this.getHibernateTemplate().get(User.class, uid);
		 * user.setMsgResetDt(System.currentTimeMillis());
		 * this.getHibernateTemplate().update(user);
		 */
	}
	
	
	@Override
	public Rs queryByUid(long uid, int page, int pagesize) {
		String hql = "from Msg m where m.status is true and m.recipient.id="+uid + " order by m.id desc";
		int firstPlace = 0;
		return HibernateCallbackUtil.getRs(this.getHibernateTemplate(), hql, firstPlace, page, pagesize);
	}

	@Override
	public void excuteBatchSave(List<Msg> list) {
		int i=0;
		for (Msg msg:list) {
			i++;
			this.getHibernateTemplate().save(msg);
			
			 if(i%500 == 0){   //每500条刷新并写入数据库  
				 this.getHibernateTemplate().flush();  
				 this.getHibernateTemplate().clear();  
             }

		}

	}

	@Override
	public void excuteCleanByUuid(String uuid) {
		String hql="delete from Msg m where m.mainUuid='"+uuid+"'";
		HibernateUtil.executeHql(this.getHibernateTemplate(), hql);
		
	}

	@Override
	public long countByRecipientUID(long uid) {
		DetachedCriteria criteria=DetachedCriteria.forClass(Msg.class);
		criteria.createAlias("recipient", "ru"); 
		criteria.add(Restrictions.eq("ru.id", uid ) );
		criteria.add(Restrictions.eq("status", true ) );
		criteria.setProjection(Projections.rowCount());
		@SuppressWarnings("unchecked")
		List<Long> list = (List<Long>) this.getHibernateTemplate().findByCriteria(criteria);
		int total=Integer.valueOf(String.valueOf(list.get(0)));
		return total;
	}

}
