package com.lerx.dao.impl;

import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

import com.lerx.dao.iface.IPollDao;
import com.lerx.entities.Poll;

public class PollDaoImpl extends HibernateDaoSupport implements IPollDao {

	
	@Override
	public void modify(Poll poll) {
		this.getHibernateTemplate().update(poll);
	}
	
	@Override
	public Poll modifyPoll(Poll poll, int status) {
		Poll parent=poll.getParent();
		switch (status) {
		case -1:
			poll.setAntis(poll.getAntis()+1);
			if (parent!=null) {
				parent.setAntis(parent.getAntis()+1);
			}
			break;
		case 1:
			poll.setAgrees(poll.getAgrees()+1);
			if (parent!=null) {
				parent.setAgrees(parent.getAgrees()+1);
			}
			break;
		default:
			poll.setPassbys(poll.getPassbys()+1);
			if (parent!=null) {
				parent.setPassbys(parent.getPassbys()+1);
			}
		}
		poll.setTotal(poll.getTotal()+1);
		this.getHibernateTemplate().update(poll);
		if (parent!=null) {
			parent.setTotal(parent.getTotal()+1);
			this.getHibernateTemplate().update(parent);
		}
		return poll;
	}

	@Override
	public Poll findByID(long id) {
		return this.getHibernateTemplate().get(Poll.class, id);
	}

	

}
