package com.lerx.dao.impl;

import java.util.List;

import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

import com.lerx.dao.iface.IPollIPRecordDao;
import com.lerx.entities.PollIPRecord;
import com.lerx.hql.entities.Rs;
import com.lerx.hql.util.HibernateCallbackUtil;

public class PollIPRecordDaoImpl extends HibernateDaoSupport implements IPollIPRecordDao {

	@Override
	public PollIPRecord add(PollIPRecord pir) {
		this.getHibernateTemplate().save(pir);
		return pir;
	}

	@Override
	public PollIPRecord findLast(long pid) {
		
		DetachedCriteria criteria=DetachedCriteria.forClass(PollIPRecord.class);
		criteria.createAlias("poll", "p"); 
		criteria.add(Restrictions.eq("p.id", pid ) );
		criteria.setProjection(Projections.max("id"));
		
		@SuppressWarnings("unchecked")
		List<Long> list= (List<Long>) this.getHibernateTemplate().findByCriteria(criteria);
		
		/*
		String hql="select max(p.id) from PollIPRecord p where p.poll.id=?0";
		@SuppressWarnings("unchecked")
		List<Long> list= (List<Long>) this.getHibernateTemplate().find(hql,pid);*/
		if (list.size()>0) {
			long id=list.get(0);
			return this.getHibernateTemplate().get(PollIPRecord.class, id);
		}
		return null;
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<PollIPRecord> findSameIPAfterDatetime(long pid, long datetime,String ip) {
		DetachedCriteria criteria=DetachedCriteria.forClass(PollIPRecord.class);
		criteria.createAlias("poll", "p"); 
		criteria.add(Restrictions.eq("p.id", pid ) );
		criteria.add(Restrictions.eq("ip", ip ) );
		criteria.add(Restrictions.gt("pollDatetime", datetime ) );
		
		List<PollIPRecord> list= (List<PollIPRecord>) this.getHibernateTemplate().findByCriteria(criteria);
		return list;
		/*String hql="from PollIPRecord p where p.poll.id="+pid+" and p.pollDatetime>"+datetime+" and p.ip=?0";
		return (List<PollIPRecord>) this.getHibernateTemplate().find(hql,ip);*/
	}

	@Override
	public Rs findSameIPAfterDatetime(long pid, long datetime,String ip, int page, int pagesize) {
		String hql="from PollIPRecord p where p.poll.id="+pid+" and p.pollDatetime>"+datetime+" and p.ip='"+ip+ "' order by p.id desc";
		int firstPlace = 0;
		return HibernateCallbackUtil.getRs(this.getHibernateTemplate(), hql, firstPlace, page, pagesize);
	}

	@Override
	public Rs find(long pid, int page, int pagesize) {
		String hql="from PollIPRecord p where p.poll.id="+pid + " order by p.id desc";
		int firstPlace = 0;
		return HibernateCallbackUtil.getRs(this.getHibernateTemplate(), hql, firstPlace, page, pagesize);
	}

}
