package com.lerx.dao.impl;

import java.util.ArrayList;
import java.util.List;

import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

import com.lerx.dao.iface.IRoleDao;
import com.lerx.entities.Role;
import com.lerx.entities.User;
import com.lerx.hql.util.HibernateUtil;



public class RoleDaoImpl extends HibernateDaoSupport implements IRoleDao {

	@Override
	public Role add(Role role) {
		this.getHibernateTemplate().save(role);
		return role;
	}

	@Override
	public Role findByID(long id) {
		return this.getHibernateTemplate().get(Role.class, id);
	}

	@Override
	public boolean delByID(long id) {
		this.getHibernateTemplate().delete(findByID(id));

		if (findByID(id) == null) {
			return true;
		} else {
			return false;
		}
	}

	@Override
	public void modify(Role role) {
		if (role.isDef()) {
			String hql="";
			hql="update Role r set r.def=false";
			HibernateUtil.executeHql(this.getHibernateTemplate(), hql);
//			this.getHibernateTemplate().bulkUpdate(hql);
		}
		
		this.getHibernateTemplate().saveOrUpdate(role);

	}
	
	
	@Override
	public int countUserByRoleID(long rid) {
		DetachedCriteria criteria=DetachedCriteria.forClass(User.class);
		criteria.setProjection(Projections.rowCount());
		criteria.createAlias("role", "r"); 
		criteria.add(Restrictions.eq("r.id", rid ) );
		@SuppressWarnings("unchecked")
		List<Long> list = (List<Long>) this.getHibernateTemplate().findByCriteria(criteria);
		Long count = list.get(0);
		return Integer.valueOf(String.valueOf(count));
		/*String hql="select count(*) from User u where u.role.id=?0";
		int count = (int) this.getHibernateTemplate()
				.find(hql,id).get(0);
		return count;*/
	}

	@Override
	public List<Role> queryAll() {
		List<Role> list = this.getHibernateTemplate().loadAll(Role.class);
		// TODO Auto-generated method stub
		return list;
	}

	@Override
	public List<Role> queryAllAndCounts() {
		DetachedCriteria criteria=DetachedCriteria.forClass(Role.class);
		criteria.addOrder( Order.desc("id") );
		
		@SuppressWarnings("unchecked")
		List<Role> list = (List<Role>) this.getHibernateTemplate().findByCriteria(criteria);
		
		List<Role> listnew = new ArrayList<Role>();
		long count;
		for (Role r : list) {
			count = countUserByRoleID(r.getId());
			r.setCounts(count);
			listnew.add(r);
		}
		return listnew;
	}

	@Override
	public void setDef(long id) {
		String hql="";
		hql="update Role r set r.def=false";
		HibernateUtil.executeHql(this.getHibernateTemplate(), hql);
		hql="update Role r set r.def=true where r.id="+id;
		HibernateUtil.executeHql(this.getHibernateTemplate(), hql);
	}

	@Override
	public Role findDef() {
		DetachedCriteria criteria=DetachedCriteria.forClass(Role.class);
		criteria.add(Restrictions.eq("def", true ) );
		
		@SuppressWarnings("unchecked")
		List<Role> list = (List<Role>) this.getHibernateTemplate().findByCriteria(criteria);
		
		if (list.size()>0){
			return list.get(0);
		}else{
			return null;
		}
		
	}

	@Override
	public List<Role> findByName(String name) {
		DetachedCriteria criteria=DetachedCriteria.forClass(Role.class);
		criteria.add(Restrictions.eq("name", name ) );
		
		@SuppressWarnings("unchecked")
		List<Role> lu = (List<Role>) this.getHibernateTemplate().findByCriteria(criteria);
		if (lu.size() > 0) { // 如果有子对象，则拒绝删除
			return lu;
		}else{
			return null;
		}
	}

	@Override
	public List<Role> findByNameOutID(String name, long id) {
		
		DetachedCriteria criteria=DetachedCriteria.forClass(Role.class);
		criteria.add(Restrictions.eq("name", name ) );
		
		criteria.add(Restrictions.ne("id", id ) );
		
		@SuppressWarnings("unchecked")
		List<Role> lu = (List<Role>) this.getHibernateTemplate().findByCriteria(criteria);
		
		if (lu.size() > 0) { // 如果有子对象，则拒绝删除
			return lu;
		}else{
			return null;
		}
	}

}
