package com.lerx.dao.impl;

import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

import com.lerx.dao.iface.ITeamDao;
import com.lerx.entities.Team;

public class TeamDaoImpl extends HibernateDaoSupport implements ITeamDao {

	@Override
	public Team add(Team team) {
		this.getHibernateTemplate().save(team);
		return team;
	}

	@Override
	public Team findByID(long id) {
		return this.getHibernateTemplate().get(Team.class, id);
	}

	@Override
	public boolean delByID(long id) {
		this.getHibernateTemplate().delete(findByID(id));

		if (findByID(id) == null) {
			return true;
		} else {
			return false;
		}
	}

	@Override
	public void modify(Team team) {
		this.getHibernateTemplate().update(team);

	}

}
