package com.lerx.dao.impl;

import java.util.List;

import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

import com.lerx.dao.iface.ITempletAlbgenreMainDao;
import com.lerx.entities.Albgenre;
import com.lerx.entities.TempletAlbgenreMain;
import com.lerx.hql.entities.Rs;
import com.lerx.hql.util.HibernateCallbackUtil;
import com.lerx.hql.util.HibernateUtil;

public class TempletAlbgenreMainDaoImpl extends HibernateDaoSupport implements ITempletAlbgenreMainDao {

	@Override
	public long add(TempletAlbgenreMain templet) {
		List<TempletAlbgenreMain> findedResult=findByTitle(templet.getName(),0);
		if (findedResult.size()==0){
			this.getHibernateTemplate().save(templet);
			return templet.getId();
		}else{
			return -1;
		}
		
	}

	@Override
	public boolean delByID(long id) {
		if (isUsedByID(id)) {
			return false;
		}
		TempletAlbgenreMain templet=findByID(id);
		templet.setDeled(true);
		modify(templet);
		return true;
		/*this.getHibernateTemplate().delete(findByID(id));
		
		if (findByID(id)==null){
			return true;
		}else{
			return false;
		}*/
	}

	@Override
	public void modify(TempletAlbgenreMain templet) {
		this.getHibernateTemplate().update(templet);

	}

	@Override
	public TempletAlbgenreMain findByID(long id) {
		return this.getHibernateTemplate().get(TempletAlbgenreMain.class, id);
	}

	@Override
	public List<TempletAlbgenreMain> findByTitle(String title,long exceptID) {
		
		DetachedCriteria criteria=DetachedCriteria.forClass(TempletAlbgenreMain.class);
		criteria.add(Restrictions.eq("name", title ) );
		criteria.add(Restrictions.eq("deled", false ) );
		
		if (exceptID>0L) {
			criteria.add(Restrictions.ne("id", exceptID ) );
		}
		@SuppressWarnings("unchecked")
		List<TempletAlbgenreMain> list = (List<TempletAlbgenreMain>) this.getHibernateTemplate().findByCriteria(criteria);
		return list;
	}

	/*
	 * 分页查询
	 */
	
	@Override
	public Rs query(int page, int pagesize) {
		String hql;
		hql="from TempletAlbgenreMain t where t.deled is false order by t.def desc,t.orderNum asc,t.id desc";
		
		int firstPlace=0;
		return HibernateCallbackUtil.getRs(this.getHibernateTemplate(), hql,firstPlace, page, pagesize);
	}
	
	@Override
	public Rs queryByAllow(int page, int pagesize) {
		String hql;
		hql="from TempletAlbgenreMain t where t.deled is false and t.state is true order by t.def desc,t.orderNum asc,t.id desc";
		
		int firstPlace=0;
		return HibernateCallbackUtil.getRs(this.getHibernateTemplate(), hql,firstPlace, page, pagesize);
	}

	@Override
	public List<TempletAlbgenreMain> queryAll() {
		DetachedCriteria criteria=DetachedCriteria.forClass(TempletAlbgenreMain.class);
		criteria.add(Restrictions.eq("deled", false ) );
		criteria.addOrder( Order.desc("def") );
		criteria.addOrder( Order.asc("orderNum") );
		criteria.addOrder( Order.desc("id") );
		
		@SuppressWarnings("unchecked")
		List<TempletAlbgenreMain> list = (List<TempletAlbgenreMain>) this.getHibernateTemplate().findByCriteria(criteria);
		return list;
	}

	@Override
	public void setDef(long id) {
		String hql="update TempletAlbgenreMain t set t.def=false";
		HibernateUtil.executeHql(this.getHibernateTemplate(), hql);
		
		hql="update TempletAlbgenreMain t set t.def=true where t.id="+id;
		HibernateUtil.executeHql(this.getHibernateTemplate(), hql);
	}

	@Override
	public TempletAlbgenreMain findDef() {
		DetachedCriteria criteria=DetachedCriteria.forClass(TempletAlbgenreMain.class);
		criteria.add(Restrictions.eq("def", true ) );
		criteria.add(Restrictions.eq("deled", false ) );
		criteria.addOrder( Order.asc("orderNum") );
		criteria.addOrder( Order.desc("id") );
		
		@SuppressWarnings("unchecked")
		List<TempletAlbgenreMain> list = (List<TempletAlbgenreMain>) this.getHibernateTemplate().findByCriteria(criteria);
		
		if (list.size()>0){
			return list.get(0);
		}
		return null;
	}

	@Override
	public TempletAlbgenreMain findByUuid(String uuid) {
		DetachedCriteria criteria=DetachedCriteria.forClass(TempletAlbgenreMain.class);
		criteria.add(Restrictions.eq("uuid", uuid ) );
		@SuppressWarnings("unchecked")
		List<TempletAlbgenreMain> list = (List<TempletAlbgenreMain>) this.getHibernateTemplate().findByCriteria(criteria);
		
		if (list.size()>0){
			return list.get(0);
		}
		return null;
	}

	@Override
	public boolean isUsedByID(long id) {
		if (findByID(id).isDef()) {
			return true;
		}
		DetachedCriteria criteria=DetachedCriteria.forClass(Albgenre.class);
		criteria.createAlias("templet", "t");
		criteria.add(Restrictions.eq("t.id", id ) );
		
		@SuppressWarnings("unchecked")
		List<TempletAlbgenreMain> list = (List<TempletAlbgenreMain>) this.getHibernateTemplate().findByCriteria(criteria);
		
		if (list.size()>0){
			return true;
		}
		return false;
	}

	

	

}
