package com.lerx.dao.impl;

import java.util.List;

import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

import com.lerx.dao.iface.ITempletPortalMainDao;
import com.lerx.entities.ArticleGroup;
import com.lerx.entities.TempletPortalMain;
import com.lerx.hql.entities.Rs;
import com.lerx.hql.util.HibernateCallbackUtil;
import com.lerx.hql.util.HibernateUtil;
import com.lerx.sys.util.StringUtil;

public class TempletPortalMainDaoImpl extends HibernateDaoSupport implements ITempletPortalMainDao {

	@Override
	public long add(TempletPortalMain templet) {
		List<TempletPortalMain> findedResult=findByTitle(templet.getName(),0);
		if (findedResult.size()==0){
			this.getHibernateTemplate().save(templet);
			return templet.getId();
		}else{
			return -1;
		}
		
	}

	@Override
	public boolean delByID(long id) {
		if (isUsedByID(id)) {
			return false;
		}
		TempletPortalMain templet=findByID(id);
		templet.setDeled(true);
		modify(templet);
		return true;
		/*this.getHibernateTemplate().delete(findByID(id));
		
		if (findByID(id)==null){
			return true;
		}else{
			return false;
		}*/
	}

	@Override
	public void modify(TempletPortalMain templet) {
		this.getHibernateTemplate().update(templet);

	}

	@Override
	public TempletPortalMain findByID(long id) {
		TempletPortalMain main=this.getHibernateTemplate().get(TempletPortalMain.class, id);
		if (main!=null && (main.getUuid()==null || main.getUuid().trim().equals(""))) {
			main.setUuid(StringUtil.uuidStr());
			modify(main);
		}
		return main;
	}

	@Override
	public List<TempletPortalMain> findByTitle(String title,long exceptID) {
		
		DetachedCriteria criteria=DetachedCriteria.forClass(TempletPortalMain.class);
		criteria.add(Restrictions.eq("name", title ) );
		criteria.add(Restrictions.eq("deled", false ) );
		
		if (exceptID>0L) {
			criteria.add(Restrictions.ne("id", exceptID ) );
		}
		@SuppressWarnings("unchecked")
		List<TempletPortalMain> list = (List<TempletPortalMain>) this.getHibernateTemplate().findByCriteria(criteria);
		return list;
		
	}

	/*
	 * 分页查询
	 */
	
	@Override
	public Rs query(int page, int pagesize) {
		String hql;
		hql="from TempletPortalMain t where t.deled is false order by t.def desc,t.orderNum asc,t.id desc";
		
		int firstPlace=0;
		return HibernateCallbackUtil.getRs(this.getHibernateTemplate(), hql,firstPlace, page, pagesize);
	}
	
	@Override
	public Rs queryByAllow(int page, int pagesize) {
		String hql;
		hql="from TempletPortalMain t where t.deled is false and t.state is true order by t.orderNum asc,t.id desc";
		
		int firstPlace=0;
		return HibernateCallbackUtil.getRs(this.getHibernateTemplate(), hql,firstPlace, page, pagesize);
	}

	@Override
	public List<TempletPortalMain> queryAll() {
		
		DetachedCriteria criteria=DetachedCriteria.forClass(TempletPortalMain.class);
		criteria.add(Restrictions.eq("deled", false ) );
		criteria.addOrder( Order.desc("def") );
		criteria.addOrder( Order.asc("orderNum") );
		criteria.addOrder( Order.desc("id") );
		@SuppressWarnings("unchecked")
		List<TempletPortalMain> list = (List<TempletPortalMain>) this.getHibernateTemplate().findByCriteria(criteria);
		return list;
		
	}

	@Override
	public void setDef(long id) {
		String hql="update TempletPortalMain t set t.def=false";
		HibernateUtil.executeHql(this.getHibernateTemplate(), hql);
		hql="update TempletPortalMain t set t.def=true where t.id="+id;
		HibernateUtil.executeHql(this.getHibernateTemplate(), hql);
	}

	@Override
	public TempletPortalMain findDef() {
		
		DetachedCriteria criteria=DetachedCriteria.forClass(TempletPortalMain.class);
		criteria.add(Restrictions.eq("def", true ) );
		criteria.add(Restrictions.eq("deled", false ) );
		criteria.addOrder( Order.asc("orderNum") );
		criteria.addOrder( Order.desc("id") );
		
		@SuppressWarnings("unchecked")
		List<TempletPortalMain> list = (List<TempletPortalMain>) this.getHibernateTemplate().findByCriteria(criteria);
		
		if (list.size()>0){
			return list.get(0);
		}
		return null;
		
	}

	@Override
	public TempletPortalMain findByUuid(String uuid) {
		DetachedCriteria criteria=DetachedCriteria.forClass(TempletPortalMain.class);
		criteria.add(Restrictions.eq("uuid", uuid ) );
		@SuppressWarnings("unchecked")
		List<TempletPortalMain> list = (List<TempletPortalMain>) this.getHibernateTemplate().findByCriteria(criteria);
		
		if (list.size()>0){
			return list.get(0);
		}
		return null;
		
	}

	@Override
	public List<TempletPortalMain> queryAllUsable() {
		DetachedCriteria criteria=DetachedCriteria.forClass(TempletPortalMain.class);
		criteria.add(Restrictions.eq("state", true ) );
		criteria.add(Restrictions.eq("deled", false ) );
		criteria.addOrder( Order.desc("id") );
		@SuppressWarnings("unchecked")
		List<TempletPortalMain> list = (List<TempletPortalMain>) this.getHibernateTemplate().findByCriteria(criteria);
		
		return list;
	}

	@Override
	public boolean isUsedByID(long id) {
		if (findByID(id).isDef()) {
			return true;
		}
		DetachedCriteria criteria=DetachedCriteria.forClass(ArticleGroup.class);
		criteria.createAlias("templet", "t");
		criteria.add(Restrictions.eq("t.id", id ) );
		
		@SuppressWarnings("unchecked")
		List<TempletPortalMain> list = (List<TempletPortalMain>) this.getHibernateTemplate().findByCriteria(criteria);
		
		if (list.size()>0){
			return true;
		}
		return false;
	}

}
