package com.lerx.dao.impl;

import java.util.List;

import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

import com.lerx.dao.iface.ITempletWareAlbumDao;
import com.lerx.entities.CommentBridge;
import com.lerx.entities.MagnetBell;
import com.lerx.entities.Poll;
import com.lerx.entities.TempletWareAlbum;
import com.lerx.entities.VisitorsBook;
import com.lerx.hql.entities.Rs;
import com.lerx.hql.util.HibernateCallbackUtil;

public class TempletWareAlbumDaoImpl extends HibernateDaoSupport implements ITempletWareAlbumDao {

	@Override
	public TempletWareAlbum add(TempletWareAlbum ware) {
		CommentBridge cb=new CommentBridge();
		Poll poll=new Poll();
		poll.setStatus(true);
		cb.setStatus(true);
		VisitorsBook vbook = new VisitorsBook();
		
		this.getHibernateTemplate().save(vbook);
		this.getHibernateTemplate().save(cb);
		this.getHibernateTemplate().save(poll);
		ware.setCb(cb);
		ware.setPoll(poll);
		ware.setVbook(vbook);
		
		MagnetBell bell = new MagnetBell();
		bell.setTmpkey(ware.getKey());
		bell.setTmpstamp(2);
		this.getHibernateTemplate().save(bell);
		ware.setBell(bell);
		
		this.getHibernateTemplate().save(ware);
		return ware;
	}

	@Override
	public void modify(TempletWareAlbum ware) {
		this.getHibernateTemplate().update(ware);
		this.getHibernateTemplate().flush();

	}

	@Override
	public TempletWareAlbum findByID(long id) {
		return this.getHibernateTemplate().get(TempletWareAlbum.class, id);
	}

	@Override
	public boolean delByID(long id) {

		this.getHibernateTemplate().delete(findByID(id));

		if (findByID(id) == null) {
			return true;
		} else {
			return false;
		}
	}

	@Override
	public Rs query(int firstResult, int page, int pagesize, int orderby) {
		String orderCmd;
		switch (orderby) {
		case 1:
			orderCmd=" t.cb.total desc ";
			break;
		case 2:
			orderCmd=" t.poll.agrees desc ";
			break;
			
		default:
			orderCmd=" t.templet.downs desc ";	
		}
		String hql = "from TempletWareAlbum t  where t.templet.state is true order by t.bell.tmpvalue desc,"+orderCmd;
		return HibernateCallbackUtil.getRs(this.getHibernateTemplate(), hql, firstResult, page, pagesize);
	}

	@Override
	public TempletWareAlbum findByTempletID(long tid) {
		
		DetachedCriteria criteria=DetachedCriteria.forClass(TempletWareAlbum.class);
		
		criteria.createAlias("templet", "t"); 
		criteria.add(Restrictions.eq("t.id", tid ) );
		@SuppressWarnings("unchecked")
		List<TempletWareAlbum> list = (List<TempletWareAlbum>) this.getHibernateTemplate().findByCriteria(criteria);
		
		if (list.size() > 0) { // 如果有子对象，则拒绝删除
			return list.get(0);
		}else{
			return null;
		}
	}

}
