package com.lerx.dao.impl;

import java.util.List;

import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

import com.lerx.dao.iface.IUserDao;
import com.lerx.entities.User;
import com.lerx.hql.entities.Rs;
import com.lerx.hql.util.HibernateCallbackUtil;
import com.lerx.login.util.LoginUtil;
import com.lerx.portal.obj.PortalStatInfo;
import com.lerx.sys.util.TimeUtil;

public class UserDaoImpl extends HibernateDaoSupport implements IUserDao {

	@Override
	public User add(User user) {
		if (findByUsername(user.getUsername())!=null) {
			return null;
		}
		user = (User) LoginUtil.create(user, true);
		this.getHibernateTemplate().save(user);
		return user;
	}
	
	@Override
	public User addAndUuid(User user) {
		String uuid=user.getUuid();
		String salt=user.getSalt();
		String password=user.getPassword();
				
		if (findByUsername(user.getUsername())!=null) {
			return null;
		}
		user = (User) LoginUtil.create(user, true);
		user.setUuid(uuid);
		user.setSalt(salt);
		user.setPassword(password);
		this.getHibernateTemplate().save(user);
	
		return user;
	}

	@Override
	public void modify(User user) {
		this.getHibernateTemplate().update(user);
	}
	
	@Override
	public void modifySafely(User user) {
		LoginUtil.safeSave(this.getHibernateTemplate(), user);
		
	}
	
	//通过用户名、手机号、邮箱来获取用户
	@Override
	public User findByKeywords(String keywords) {
		// TODO Auto-generated method stub
		User user=new User();
		user.setUsername(keywords);
		return (User) LoginUtil.find(this.getHibernateTemplate(), user);
	}


	@Override
	public User findByID(long id) {
		return this.getHibernateTemplate().get(User.class, id);
	}
	
	@Override
	public User findByUsername(String username) {
		DetachedCriteria criteria=DetachedCriteria.forClass(User.class);
		criteria.add(Restrictions.eq("username", username ) );
		@SuppressWarnings("unchecked")
		List<User> lu = (List<User>) this.getHibernateTemplate().findByCriteria(criteria);
		if (lu.size() > 0) { 
			return lu.get(0);
		}else{
			return null;
		}
	}
	
	@Override
	public User findByUuid(String uuid) {
		DetachedCriteria criteria=DetachedCriteria.forClass(User.class);
		criteria.add(Restrictions.eq("uuid", uuid ) );
		@SuppressWarnings("unchecked")
		List<User> lu = (List<User>) this.getHibernateTemplate().findByCriteria(criteria);
		if (lu.size() > 0) { 
			return lu.get(0);
		}else{
			return null;
		}
	}
	
	@Override
	public User findByNickname(String nickname) {
		DetachedCriteria criteria=DetachedCriteria.forClass(User.class);
		criteria.add(Restrictions.eq("nickname", nickname ) );
		@SuppressWarnings("unchecked")
		List<User> lu = (List<User>) this.getHibernateTemplate().findByCriteria(criteria);
		if (lu.size() > 0) { 
			return lu.get(0);
		}else{
			return null;
		}
		
	}
	
	@Override
	public User findByMobile(String mobile,long excludeID) {
		DetachedCriteria criteria=DetachedCriteria.forClass(User.class);
		criteria.add(Restrictions.eq("mobile", mobile ) );
		
		if (excludeID>0L) {
			criteria.add(Restrictions.ne("id", excludeID ) );
		}
		
		@SuppressWarnings("unchecked")
		List<User> lu = (List<User>) this.getHibernateTemplate().findByCriteria(criteria);
		if (lu.size() > 0) { 
			return lu.get(0);
		}else{
			return null;
		}
	}

	@Override
	public User findByEmail(String email,long excludeID) {
		
		DetachedCriteria criteria=DetachedCriteria.forClass(User.class);
		criteria.add(Restrictions.eq("email", email ) );
		
		if (excludeID>0L) {
			criteria.add(Restrictions.ne("id", excludeID ) );
		}
		
		@SuppressWarnings("unchecked")
		List<User> lu = (List<User>) this.getHibernateTemplate().findByCriteria(criteria);
		if (lu.size() > 0) { 
			return lu.get(0);
		}else{
			return null;
		}
		
	}

	@Override
	public boolean delByID(long id) {
		this.getHibernateTemplate().delete(findByID(id));

		if (findByID(id) == null) {
			return true;
		} else {
			return false;
		}
	}

	@Override
	public Rs find(long gid,int page, int pagesize) {
		String gcmd="";
		if (gid>0L) {
			gcmd=" where u.role.id="+gid;
		}
		String hql = "from User u "+gcmd+" order by u.id desc";
		int firstPlace = 0;
		return HibernateCallbackUtil.getRs(this.getHibernateTemplate(), hql, firstPlace, page, pagesize);
	}
	
	@Override
	public Rs findByName(String name, int page, int pagesize) {
		String hql = "from User u where u.username like '%"+name+"%' or u.nickname like '%"+name+"%' or u.truename like '%"+name+"%' or u.dept like '%"+name+"%' or u.mobile like '%"+name+"%' or u.email like '%"+name+"%' order by u.id desc";
		int firstPlace = 0;
		return HibernateCallbackUtil.getRs(this.getHibernateTemplate(), hql, firstPlace, page, pagesize);
	}

	@Override
	public User login(User user) {
		/*if (findByUsername(user.getUsername())==null){
			return null;
		}*/
		user = (User) LoginUtil.login(this.getHibernateTemplate(), user);
		return user;
	}

	@Override
	public void modifypw(User user, String newpw) {
		user.setSalt(null);
		user.setPassword(newpw);
		user = (User) LoginUtil.passwordMD5Create(user);
		user.setPwdChangeTime(System.currentTimeMillis());
		this.getHibernateTemplate().update(user);
		this.getHibernateTemplate().flush();
		
	}

	@SuppressWarnings("unchecked")
	@Override
	public PortalStatInfo stat(PortalStatInfo psi) {
		DetachedCriteria criteria=DetachedCriteria.forClass(User.class);
		criteria.setProjection(Projections.rowCount());
		List<Long> list = (List<Long>) this.getHibernateTemplate().findByCriteria(criteria);		
		psi.setUserTotal(list.get(0));
		criteria.add(Restrictions.eq("state", true ) );
		list = (List<Long>) this.getHibernateTemplate().findByCriteria(criteria);
		psi.setUserPassed(list.get(0));
		
		return psi;
	}

	@Override
	public Rs artsPassedRank(int page,int pagesize) {
		String hql="from User u where u.state is true order by u.artsPassed desc";
		int firstPlace = 0;
		return HibernateCallbackUtil.getRs(this.getHibernateTemplate(), hql, firstPlace, page, pagesize);
	}

	@Override
	public List<Long> findNeverValidPhone() {
		DetachedCriteria criteria=DetachedCriteria.forClass(User.class);
		criteria.setProjection(Projections.property("id"));
		criteria.add(Restrictions.eq("state", true ) );
		criteria.add(Restrictions.isNotNull("mobile"));
		criteria.add(Restrictions.ne("mobile", "" ) );
		criteria.add(Restrictions.or(Restrictions.isNull("contactsVerifyed"),Restrictions.eq("contactsVerifyed", ""),Restrictions.eq("contactsVerifyed", "1" ),Restrictions.eq("contactsVerifyed", "0" ),Restrictions.eq("contactsVerifyed", "01" ),Restrictions.eq("contactsVerifyed", "00" ) ));
		
		long curr=System.currentTimeMillis();
		long twoMonthGgo=TimeUtil.cal(curr, 1, -1);
		
		criteria.add(Restrictions.lt("lastMsgSendDt",twoMonthGgo));
		
		criteria.addOrder(Order.asc("lastMsgSendDt") );
		criteria.addOrder(Order.asc("lastLoginTime") );
		criteria.addOrder(Order.asc("id") );
		
//		System.out.println("criteria.toString():"+criteria.toString());
		
		@SuppressWarnings("unchecked")
		List<Long> list = (List<Long>) this.getHibernateTemplate().findByCriteria(criteria,0,50);		
		return list;
	}

	@Override
	public void updateNeverValidPhone(List<Long> list) {
		/*
		 * String inhql=""; for (long uid:list) { inhql+=uid+","; }
		 * 
		 * if (inhql.endsWith(",")) { inhql=inhql.substring(0, inhql.length()-1); }
		 */
		
		String hql="update User u set u.lastMsgSendDt = "+System.currentTimeMillis()+" where u.id in (:ulist)";
		Query<?> query = currentSession().createQuery(hql); 
		query.setParameterList("ulist", list);
		query.executeUpdate();
		
	}


}
