package com.lerx.dao.impl;

import java.util.List;

import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

import com.lerx.dao.iface.IVisitorIPRecordDao;
import com.lerx.entities.VisitorIPRecord;
import com.lerx.hql.entities.Rs;
import com.lerx.hql.util.HibernateCallbackUtil;
import com.lerx.sys.util.TimeUtil;

public class VisitorIPRecordDaoImpl extends HibernateDaoSupport implements IVisitorIPRecordDao {

	@Override
	public VisitorIPRecord add(VisitorIPRecord vipr) {
		this.getHibernateTemplate().save(vipr);
		return vipr;
	}
	
	@Override
	public void modify(VisitorIPRecord vipr) {
		this.getHibernateTemplate().update(vipr);
	}
	
	@Override
	public VisitorIPRecord findByID(long id) {
		if (id>0L) {
			return this.getHibernateTemplate().get(VisitorIPRecord.class, id);
		}else {
			DetachedCriteria criteria=DetachedCriteria.forClass(VisitorIPRecord.class);
			criteria.setProjection(Projections.min("id"));
			@SuppressWarnings("unchecked")
			List<Long> list= (List<Long>) this.getHibernateTemplate().findByCriteria(criteria);
			if (list!=null && !list.isEmpty() && list.size()>0) {
				if (list.get(0)==null) {
					return null;
				}
				id=list.get(0);
				return this.getHibernateTemplate().get(VisitorIPRecord.class, id);
			}
		}
		return null;
		
	}

	@Override
	public VisitorIPRecord findLast(long bid) {
		DetachedCriteria criteria=DetachedCriteria.forClass(VisitorIPRecord.class);
		criteria.createAlias("vbook", "v"); 
		criteria.add(Restrictions.eq("v.id", bid ) );
		criteria.setProjection(Projections.max("id"));
		@SuppressWarnings("unchecked")
		List<Long> list= (List<Long>) this.getHibernateTemplate().findByCriteria(criteria);
		
		if (list.size()>0) {
			long id=list.get(0);
			return this.getHibernateTemplate().get(VisitorIPRecord.class, id);
		}
		return null;
	}

	@Override
	public List<VisitorIPRecord> findSameIPAfterDatetime(long bid, long datetime,String ip) {
		DetachedCriteria criteria=DetachedCriteria.forClass(VisitorIPRecord.class);
		criteria.createAlias("vbook", "v"); 
		criteria.add(Restrictions.eq("v.id", bid ) );
		criteria.add(Restrictions.eq("ip", ip ) );
		criteria.add(Restrictions.gt("visitDatetime", datetime ) );
		
		@SuppressWarnings("unchecked")
		List<VisitorIPRecord> list= (List<VisitorIPRecord>) this.getHibernateTemplate().findByCriteria(criteria);
		return list;
	}

	@Override
	public Rs findSameIPAfterDatetime(long bid, long datetime,String ip, int page, int pagesize) {
		String hql="from VisitorIPRecord v where v.vbook.id="+bid+" and v.visitDatetime>"+datetime+" and v.ip=?0";
		int firstPlace = 0;
		return HibernateCallbackUtil.getRs(this.getHibernateTemplate(), hql, firstPlace, page, pagesize);
	}

	@Override
	public Rs find(long bid, int page, int pagesize) {
		String hql="from VisitorIPRecord v where v.vbook.id="+bid + " order by v.visitDatetime desc";
		int firstPlace = 0;
		return HibernateCallbackUtil.getRs(this.getHibernateTemplate(), hql, firstPlace, page, pagesize);
	}

	@Override
	public long currPeriod(long bid, int stamp) {
		long startT=TimeUtil.firstDay(stamp);
		DetachedCriteria criteria=DetachedCriteria.forClass(VisitorIPRecord.class);
		criteria.setProjection(Projections.rowCount());
		criteria.createAlias("vbook", "v"); 
		criteria.add(Restrictions.eq("v.id", bid ) );
		criteria.add(Restrictions.gt("visitDatetime", startT ) );
		
		@SuppressWarnings("unchecked")
		List<Long> list = (List<Long>) this.getHibernateTemplate().findByCriteria(criteria);
		return list.get(0);
	}


}
