package com.lerx.entities;

import java.util.List;

import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

import com.lerx.hibernate.search.fieldBridge.AlbgenreFieldBridge;
import com.lerx.interceptor.AlbumIndexStatusInterceptor;
import com.lerx.portal.obj.SimplePartner;

@Indexed(interceptor=AlbumIndexStatusInterceptor.class)
public class Album {
	
	@DocumentId
	private long id;
	private String name;
	private String description;
	private String mail;
	private String logo;
	private String banner;
	private String uuid;
	private String logoSmall;
	private String logo8831;
	private String bannerSmall;
	private String css;
	private String htmlOwn;
	private String color1;
	private String color2;
	private String color3;
	private String txt1;
	private String txt2;
	private String labels;
	private boolean deled;
	private boolean status;
	private boolean open;
	private boolean memberAdd;
	private boolean conservative;
	private boolean comm;
	private boolean mesback;				//反馈
	private long createTime;
	private long lastEditTime;
	private long lastViewTime;
	private String lastViewIP;
	private long lastModifyTime;
	private long expiredDate;				//结束时间
	private int hotn;
	private Poll poll;
	private CommentBridge cb;
	private VisitorsBook vbook;
	private int totalOfArts;
	private Albgenre genre;
	private User leader;
	private User passer;
	private TempletAlbumMain templet;
	private long totalArt;
	private long totalArtSoul;
	private long totalPartner;
	private long totalProhibit;
	private String url;
	private List<AlbumPartner> partnerList;
	private List<SimplePartner> spartnerList;
	
	private SearchTotalModel srt;
	
	public long getId() {
		return id;
	}
	public void setId(long id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}
	public String getMail() {
		return mail;
	}
	public void setMail(String mail) {
		this.mail = mail;
	}
	public String getLogo() {
		return logo;
	}
	public void setLogo(String logo) {
		this.logo = logo;
	}
	public String getBanner() {
		return banner;
	}
	public void setBanner(String banner) {
		this.banner = banner;
	}
	public String getTxt1() {
		return txt1;
	}
	public void setTxt1(String txt1) {
		this.txt1 = txt1;
	}
	public String getTxt2() {
		return txt2;
	}
	public void setTxt2(String txt2) {
		this.txt2 = txt2;
	}
	public String getLabels() {
		return labels;
	}
	public void setLabels(String labels) {
		this.labels = labels;
	}
	public String getUuid() {
		return uuid;
	}
	public void setUuid(String uuid) {
		this.uuid = uuid;
	}
	public String getLogoSmall() {
		return logoSmall;
	}
	public void setLogoSmall(String logoSmall) {
		this.logoSmall = logoSmall;
	}
	public String getLogo8831() {
		return logo8831;
	}
	public void setLogo8831(String logo8831) {
		this.logo8831 = logo8831;
	}
	public String getBannerSmall() {
		return bannerSmall;
	}
	public void setBannerSmall(String bannerSmall) {
		this.bannerSmall = bannerSmall;
	}
	
	@Field(index=Index.YES,analyze = Analyze.NO, store = Store.YES)
	@FieldBridge(impl = AlbgenreFieldBridge.class)
	public Albgenre getGenre() {
		return genre;
	}
	public void setGenre(Albgenre genre) {
		this.genre = genre;
	}
	public User getLeader() {
		return leader;
	}
	public void setLeader(User leader) {
		this.leader = leader;
	}
	public User getPasser() {
		return passer;
	}
	public void setPasser(User passer) {
		this.passer = passer;
	}
	public boolean isDeled() {
		return deled;
	}
	public void setDeled(boolean deled) {
		this.deled = deled;
	}
	public boolean isStatus() {
		return status;
	}
	public void setStatus(boolean status) {
		this.status = status;
	}
	public boolean isOpen() {
		return open;
	}
	public void setOpen(boolean open) {
		this.open = open;
	}
	public boolean isMemberAdd() {
		return memberAdd;
	}
	public void setMemberAdd(boolean memberAdd) {
		this.memberAdd = memberAdd;
	}
	public boolean isConservative() {
		return conservative;
	}
	public void setConservative(boolean conservative) {
		this.conservative = conservative;
	}
	public boolean isComm() {
		return comm;
	}
	public void setComm(boolean comm) {
		this.comm = comm;
	}
	public boolean isMesback() {
		return mesback;
	}
	public void setMesback(boolean mesback) {
		this.mesback = mesback;
	}
	public long getCreateTime() {
		return createTime;
	}
	public void setCreateTime(long createTime) {
		this.createTime = createTime;
	}
	public long getLastEditTime() {
		return lastEditTime;
	}
	public void setLastEditTime(long lastEditTime) {
		this.lastEditTime = lastEditTime;
	}
	public long getLastViewTime() {
		return lastViewTime;
	}
	public void setLastViewTime(long lastViewTime) {
		this.lastViewTime = lastViewTime;
	}
	public String getLastViewIP() {
		return lastViewIP;
	}
	public void setLastViewIP(String lastViewIP) {
		this.lastViewIP = lastViewIP;
	}
	public long getLastModifyTime() {
		return lastModifyTime;
	}
	public void setLastModifyTime(long lastModifyTime) {
		this.lastModifyTime = lastModifyTime;
	}
	public long getExpiredDate() {
		return expiredDate;
	}
	public void setExpiredDate(long expiredDate) {
		this.expiredDate = expiredDate;
	}
	public int getTotalOfArts() {
		return totalOfArts;
	}
	public void setTotalOfArts(int totalOfArts) {
		this.totalOfArts = totalOfArts;
	}
	public int getHotn() {
		return hotn;
	}
	public void setHotn(int hotn) {
		this.hotn = hotn;
	}
	public Poll getPoll() {
		return poll;
	}
	public void setPoll(Poll poll) {
		this.poll = poll;
	}
	public VisitorsBook getVbook() {
		return vbook;
	}
	public void setVbook(VisitorsBook vbook) {
		this.vbook = vbook;
	}
	public TempletAlbumMain getTemplet() {
		return templet;
	}
	public void setTemplet(TempletAlbumMain templet) {
		this.templet = templet;
	}
	public long getTotalArt() {
		return totalArt;
	}
	public void setTotalArt(long totalArt) {
		this.totalArt = totalArt;
	}
	public long getTotalArtSoul() {
		return totalArtSoul;
	}
	public void setTotalArtSoul(long totalArtSoul) {
		this.totalArtSoul = totalArtSoul;
	}
	public long getTotalPartner() {
		return totalPartner;
	}
	public void setTotalPartner(long totalPartner) {
		this.totalPartner = totalPartner;
	}
	public long getTotalProhibit() {
		return totalProhibit;
	}
	public void setTotalProhibit(long totalProhibit) {
		this.totalProhibit = totalProhibit;
	}
	public String getUrl() {
		return url;
	}
	public void setUrl(String url) {
		this.url = url;
	}
	public String getCss() {
		return css;
	}
	public void setCss(String css) {
		this.css = css;
	}
	public String getColor1() {
		return color1;
	}
	public void setColor1(String color1) {
		this.color1 = color1;
	}
	public String getColor2() {
		return color2;
	}
	public void setColor2(String color2) {
		this.color2 = color2;
	}
	public String getColor3() {
		return color3;
	}
	public void setColor3(String color3) {
		this.color3 = color3;
	}
	public String getHtmlOwn() {
		return htmlOwn;
	}
	public void setHtmlOwn(String htmlOwn) {
		this.htmlOwn = htmlOwn;
	}
	public CommentBridge getCb() {
		return cb;
	}
	public void setCb(CommentBridge cb) {
		this.cb = cb;
	}
	public SearchTotalModel getSrt() {
		return srt;
	}
	public void setSrt(SearchTotalModel srt) {
		this.srt = srt;
	}
	public List<AlbumPartner> getPartnerList() {
		return partnerList;
	}
	public void setPartnerList(List<AlbumPartner> partnerList) {
		this.partnerList = partnerList;
	}
	public List<SimplePartner> getSpartnerList() {
		return spartnerList;
	}
	public void setSpartnerList(List<SimplePartner> spartnerList) {
		this.spartnerList = spartnerList;
	}

}
