package com.lerx.entities;

import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.wltea.analyzer.lucene.IKAnalyzer;

import com.lerx.hibernate.search.fieldBridge.AlbgenreFieldBridge;
import com.lerx.hibernate.search.fieldBridge.AlbumFieldBridge;
import com.lerx.interceptor.AlbumArticleIndexStatusInterceptor;

@Indexed(interceptor=AlbumArticleIndexStatusInterceptor.class)
@Analyzer(impl = IKAnalyzer.class)
public class AlbumArticle {
	
	@DocumentId
	private long id;
	
	private Album album;
	
	private AlbumArticleClassify classify;
	private AlbumArticle target;
	@Field (index=Index.YES, analyze=Analyze.YES, store=Store.YES)
	private String subject;
	@Field (index=Index.YES, analyze=Analyze.YES, store=Store.YES)
	private String subjectShort;
	@Field (index=Index.YES, analyze=Analyze.YES, store=Store.YES)
	private String tmpSubject;
	@Field (index=Index.YES, analyze=Analyze.YES, store=Store.YES)
	private String tmpContent;
	private AlbumArticleContent content;
	private String uuid;
	private long views;
	private long creationTime;
	private long creationTimeOldest;
	private long lastModifyTime;
	private long lastViewTime;
	private boolean status;
	private boolean soul;
	private boolean topOne;
	private boolean prohibit;
	private int hotn;
	private User deler;
	private User owner;
	private User arbitrator;
	private Poll poll;
	private VisitorsBook vbook;
	private CommentBridge cb;
	private HtmlFileStatic hfs;
	private SearchTotalModel srt;
	public long getId() {
		return id;
	}
	public void setId(long id) {
		this.id = id;
	}
	
	@Field(index=Index.YES,analyze = Analyze.NO, store = Store.YES)
	@FieldBridge(impl = AlbumFieldBridge.class)
	public Album getAlbum() {
		return album;
	}
	
	@Field(index=Index.YES,analyze = Analyze.NO, store = Store.YES)
	@FieldBridge(impl = AlbgenreFieldBridge.class)
	public Albgenre getAlbgenre() {
		return album.getGenre();
	}
	
	public void setAlbum(Album album) {
		this.album = album;
	}
	public AlbumArticleClassify getClassify() {
		return classify;
	}
	public void setClassify(AlbumArticleClassify classify) {
		this.classify = classify;
	}
	public AlbumArticle getTarget() {
		return target;
	}
	public void setTarget(AlbumArticle target) {
		this.target = target;
	}
	public String getSubject() {
		return subject;
	}
	public void setSubject(String subject) {
		this.subject = subject;
	}
	public String getTmpSubject() {
		return tmpSubject;
	}
	public void setTmpSubject(String tmpSubject) {
		this.tmpSubject = tmpSubject;
	}
	public String getTmpContent() {
		return tmpContent;
	}
	public void setTmpContent(String tmpContent) {
		this.tmpContent = tmpContent;
	}
	public String getSubjectShort() {
		return subjectShort;
	}
	public void setSubjectShort(String subjectShort) {
		this.subjectShort = subjectShort;
	}
	public long getViews() {
		return views;
	}
	public void setViews(long views) {
		this.views = views;
	}
	public long getCreationTime() {
		return creationTime;
	}
	public void setCreationTime(long creationTime) {
		this.creationTime = creationTime;
	}
	public long getLastModifyTime() {
		return lastModifyTime;
	}
	public void setLastModifyTime(long lastModifyTime) {
		this.lastModifyTime = lastModifyTime;
	}
	public long getLastViewTime() {
		return lastViewTime;
	}
	public void setLastViewTime(long lastViewTime) {
		this.lastViewTime = lastViewTime;
	}
	public boolean isStatus() {
		return status;
	}
	public void setStatus(boolean status) {
		this.status = status;
	}
	public boolean isSoul() {
		return soul;
	}
	public void setSoul(boolean soul) {
		this.soul = soul;
	}
	public boolean isTopOne() {
		return topOne;
	}
	public void setTopOne(boolean topOne) {
		this.topOne = topOne;
	}
	public boolean isProhibit() {
		return prohibit;
	}
	public void setProhibit(boolean prohibit) {
		this.prohibit = prohibit;
	}
	public int getHotn() {
		return hotn;
	}
	public void setHotn(int hotn) {
		this.hotn = hotn;
	}
	public Poll getPoll() {
		return poll;
	}
	public void setPoll(Poll poll) {
		this.poll = poll;
	}
	public VisitorsBook getVbook() {
		return vbook;
	}
	public void setVbook(VisitorsBook vbook) {
		this.vbook = vbook;
	}
	public CommentBridge getCb() {
		return cb;
	}
	public void setCb(CommentBridge cb) {
		this.cb = cb;
	}
	public HtmlFileStatic getHfs() {
		return hfs;
	}
	public void setHfs(HtmlFileStatic hfs) {
		this.hfs = hfs;
	}
	public AlbumArticleContent getContent() {
		return content;
	}
	public void setContent(AlbumArticleContent content) {
		this.content = content;
	}
	public User getDeler() {
		return deler;
	}
	public void setDeler(User deler) {
		this.deler = deler;
	}
	public User getOwner() {
		return owner;
	}
	public void setOwner(User owner) {
		this.owner = owner;
	}
	public User getArbitrator() {
		return arbitrator;
	}
	public void setArbitrator(User arbitrator) {
		this.arbitrator = arbitrator;
	}
	public String getUuid() {
		return uuid;
	}
	public void setUuid(String uuid) {
		this.uuid = uuid;
	}
	public SearchTotalModel getSrt() {
		return srt;
	}
	public void setSrt(SearchTotalModel srt) {
		this.srt = srt;
	}
	public long getCreationTimeOldest() {
		return creationTimeOldest;
	}
	public void setCreationTimeOldest(long creationTimeOldest) {
		this.creationTimeOldest = creationTimeOldest;
	}

}
