package com.lerx.entities;

import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.wltea.analyzer.lucene.IKAnalyzer;

import com.lerx.interceptor.TotalIndexStatusInterceptor;

@Indexed(interceptor=TotalIndexStatusInterceptor.class)
@Analyzer(impl = IKAnalyzer.class)
public class SearchTotalModel {
	
	@DocumentId
	private long id;
	@Field (index=Index.YES, analyze=Analyze.YES, store=Store.YES)
	private String subject;
	@Field (index=Index.YES, analyze=Analyze.YES, store=Store.YES)
	private String subjectShort;
	@Field (index=Index.YES, analyze=Analyze.YES, store=Store.YES)
	private String content;
	@Field (index=Index.YES, analyze=Analyze.YES, store=Store.YES)
	private String synopsis; 
	@Field (index=Index.YES, analyze=Analyze.YES, store=Store.YES)
	private String author;
	@Field (index=Index.YES, analyze=Analyze.YES, store=Store.YES)
	private String dept;
	private int riskLevel;
	private String riskContent;
	private boolean status;
	private long creationTime;
	private long operationTime;
	private String href;
	private String dtype;
	private String dgroup;
	private String user;
	private User operator;
	
	public long getId() {
		return id;
	}
	public void setId(long id) {
		this.id = id;
	}
	public String getSubject() {
		return subject;
	}
	public void setSubject(String subject) {
		this.subject = subject;
	}
	public String getContent() {
		return content;
	}
	public void setContent(String content) {
		this.content = content;
	}
	public String getAuthor() {
		return author;
	}
	public void setAuthor(String author) {
		this.author = author;
	}
	public String getDept() {
		return dept;
	}
	public int getRiskLevel() {
		return riskLevel;
	}
	public void setRiskLevel(int riskLevel) {
		this.riskLevel = riskLevel;
	}
	public String getRiskContent() {
		return riskContent;
	}
	public void setRiskContent(String riskContent) {
		this.riskContent = riskContent;
	}
	public void setDept(String dept) {
		this.dept = dept;
	}
	public String getSubjectShort() {
		return subjectShort;
	}
	public void setSubjectShort(String subjectShort) {
		this.subjectShort = subjectShort;
	}
	public String getSynopsis() {
		return synopsis;
	}
	public void setSynopsis(String synopsis) {
		this.synopsis = synopsis;
	}
	public boolean isStatus() {
		return status;
	}
	public void setStatus(boolean status) {
		this.status = status;
	}
	public String getHref() {
		return href;
	}
	public void setHref(String href) {
		this.href = href;
	}
	public String getDtype() {
		return dtype;
	}
	public void setDtype(String dtype) {
		this.dtype = dtype;
	}
	public String getDgroup() {
		return dgroup;
	}
	public void setDgroup(String dgroup) {
		this.dgroup = dgroup;
	}
	public long getCreationTime() {
		return creationTime;
	}
	public void setCreationTime(long creationTime) {
		this.creationTime = creationTime;
	}
	public long getOperationTime() {
		return operationTime;
	}
	public void setOperationTime(long operationTime) {
		this.operationTime = operationTime;
	}
	public String getUser() {
		return user;
	}
	public void setUser(String user) {
		this.user = user;
	}
	public User getOperator() {
		return operator;
	}
	public void setOperator(User operator) {
		this.operator = operator;
	}

}
