package com.lerx.handlers;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.lerx.annotation.Token;
import com.lerx.dao.iface.IAlbgenreDao;
import com.lerx.dao.iface.IAlbumArticleClassifyDao;
import com.lerx.dao.iface.IAlbumDao;
import com.lerx.entities.Albgenre;
import com.lerx.entities.Album;
import com.lerx.entities.AlbumArticleClassify;
import com.lerx.hql.entities.Rs;

@RequestMapping("/action_album_article_classify")
@Controller
public class AlbumArticleClassifyHandler {
	
	@Autowired
	private IAlbgenreDao albgenreDaoImpl;
	
	@Autowired
	private IAlbumDao albumDaoImpl;
	
	@Autowired
	private IAlbumArticleClassifyDao albumArticleClassifyDaoImpl;
	
	private static final String FAILED = "jsp/result/failed";
	private static final String LOGINPAGE = "jsp/user/login";
	private static final String ADMINFAILRETURN = "_admin.login.redirect_";
	
	@RequestMapping(value = {"/listByGid/{gid}"})
	@Token(ajax = false, admin = true,csrf=true, failedPage = FAILED, msgKey = "fail.permission",failedReturnUrl = ADMINFAILRETURN)
	public String listByGid(@PathVariable(value = "gid", required = true) Long gid,HttpServletRequest request, HttpSession session,Map<String, Object> map) {
		List<AlbumArticleClassify> list=albumArticleClassifyDaoImpl.findByGID(gid);
		map.put("list", list);
		
		return "jsp/album/genre/aacs";
		
	}
	
	
	
	@RequestMapping(value = {"/listByAid/{aid}"})
	@Token(login = true,csrf=true, failedPage = LOGINPAGE, msgKey = "fail.permission",failedReturnUrl = ADMINFAILRETURN)
	public String listByAid(@PathVariable(value = "aid", required = true) Long aid,HttpServletRequest request, HttpSession session,Map<String, Object> map) {
		if (aid==null) {
			return FAILED;
		}
		Album album=albumDaoImpl.findByID(aid);
		if (album==null) {
			return FAILED;
		}else {
			
			List<AlbumArticleClassify> listg=albumArticleClassifyDaoImpl.findByGID(album.getGenre().getId());
			map.put("listg", listg);
			AlbumArticleClassify gmain=albumArticleClassifyDaoImpl.findMainByGID(album.getGenre().getId());
			if (listg.size()>0 && gmain!=null) {
				map.put("gmain", true);
			}else {
				map.put("gmain", false);
			}
			List<AlbumArticleClassify> lista=albumArticleClassifyDaoImpl.findByAID(aid);
			map.put("lista", lista);
		}
		
		map.put("cc", album.getGenre().isArtClassifyCustom());
		
		
		return "jsp/album/control/aacs";
		
	}
	
	
	@RequestMapping(value = {"/list/{mode}/{page}/{pagesize}","/list/{mode}"})
	@Token(ajax = false, admin = true,csrf=true, failedPage = FAILED, msgKey = "fail.permission",failedReturnUrl = ADMINFAILRETURN)
	public String listAll(@PathVariable(value = "gid", required = false) Integer mode,@PathVariable(value = "page", required = false) Integer page,@PathVariable(value = "pagesize", required = false) Integer pagesize,HttpServletRequest request, HttpSession session,Map<String, Object> map) {
		if (mode==null || mode<0 || mode>2) {
			mode=0;
		}
		
		if (page==null) {
			page=0;
		}
		if (pagesize==null) {
			pagesize=10;
		}
		
		Rs rs=albumArticleClassifyDaoImpl.findByMod(mode, page, pagesize);
		map.put("rs", rs);
		map.put("pageUrl", "/action_album_article_classify/list/" + mode);
		return "jsp/aac/list";
		
	}
	
	@ResponseBody
	@RequestMapping(value = "/addOnGenre/{gid}")
	@Token(ajax = true, admin = true,csrf=true,contrast = true,log = true,mark = "album-classify--<add>")
	public int addOnGenre(@PathVariable(value = "gid", required = true) Long gid,String name) {
		Albgenre genre=albgenreDaoImpl.findByID(gid);
		AlbumArticleClassify aac=new AlbumArticleClassify();
		aac.setDeled(false);
		aac.setGenre(genre);
		aac.setName(name);
		aac.setMain(false);
		int maxOrdn=albumArticleClassifyDaoImpl.maxOrdn(gid);
		aac.setOrdn(maxOrdn+1);
		albumArticleClassifyDaoImpl.add(aac);
		return 0;
		
	}
	
	@ResponseBody
	@RequestMapping(value = "/addOnAlbum/{aid}")
	@Token(ajax = true, login = true,csrf=true,contrast = true,log = true,mark = "album-classify--<add>")
	public int addOnAlbum(@PathVariable(value = "aid", required = true) Long aid,String name) {
		
		Album album=albumDaoImpl.findByID(aid);
		if (!album.getGenre().isArtClassifyCustom()) {
			return -403;
		}
		AlbumArticleClassify aac=new AlbumArticleClassify();
		aac.setDeled(false);
		aac.setAlbum(album);
		aac.setName(name);
		aac.setMain(false);
		int maxOrdn=albumArticleClassifyDaoImpl.maxOrdnAtAid(aid);
		aac.setOrdn(maxOrdn+1);
		albumArticleClassifyDaoImpl.add(aac);
		return 0;
		
	}
	
	@ResponseBody
	@RequestMapping(value = "/delOnGenre/{cid}")
	@Token(ajax = true, admin = true,csrf=true,contrast = true,log = true,mark = "album-classify--<del>")
	public int delOnGenre(@PathVariable(value = "cid", required = true) Long cid) {
		albumArticleClassifyDaoImpl.delByID(cid);
		return 0;
		
	}
	
	@ResponseBody
	@RequestMapping(value = "/delOnAlbum/{cid}")
	@Token(ajax = true, login = true,csrf=true,contrast = true,log = true,failedPage = LOGINPAGE,mark = "album-classify--<del>")
	public int delOnAlbum(@PathVariable(value = "cid", required = true) Long cid) {
		AlbumArticleClassify aac=albumArticleClassifyDaoImpl.findByID(cid);
		
		if (aac==null) {
			return -404;
		}
		if (aac.getGenre()!=null) {
			return -200;
		}
		if (!aac.getAlbum().getGenre().isArtClassifyCustom()) {
			return -403;
		}
		albumArticleClassifyDaoImpl.delByID(cid);
		return 0;
		
	}
	
	@ResponseBody
	@RequestMapping(value = "/modifyOnGenre/{cid}")
	@Token(ajax = true, admin = true,csrf=true,contrast = true,log = true,mark = "album-classify--<modify>")
	public int modifyOnGenre(@PathVariable(value = "cid", required = true) Long cid,String name) {
		AlbumArticleClassify aac=albumArticleClassifyDaoImpl.findByID(cid);
		aac.setName(name);
		
		albumArticleClassifyDaoImpl.modify(aac);
		return 0;
		
	}
	
	@ResponseBody
	@RequestMapping(value = "/modifyOnAlbum/{cid}")
	@Token(ajax = true, login = true,csrf=true,contrast = true,failedPage = LOGINPAGE,log = true,mark = "album-classify--<modify>")
	public int modifyOnAlbum(@PathVariable(value = "cid", required = true) Long cid,String name) {
		AlbumArticleClassify aac=albumArticleClassifyDaoImpl.findByID(cid);
		if (aac==null) {
			return -404;
		}
		if (aac.getGenre()!=null) {
			return -200;
		}
		if (!aac.getAlbum().getGenre().isArtClassifyCustom()) {
			return -403;
		}
		aac.setName(name);
		
		albumArticleClassifyDaoImpl.modify(aac);
		return 0;
		
	}
	
	@ResponseBody
	@RequestMapping(value = "/setMain/{cid}")
	@Token(ajax = true, admin = true,csrf=true,contrast = true,log = true,mark = "album-classify--<setMain>")
	public int setMain(@PathVariable(value = "cid", required = true) Long cid) {
		
		albumArticleClassifyDaoImpl.setMain(cid);
		return 0;
		
	}
	
	
	@ResponseBody
	@RequestMapping(value = "/modifyOrdn/{cid}/{ordn}")
	@Token(ajax = true, admin = true,csrf=true,contrast = true,log = true,mark = "album-classify--<modifyOrdn>")
	public int modifyOrdn(@PathVariable(value = "cid", required = true) Long cid,@PathVariable(value = "ordn", required = true) Integer ordn) {
		if (ordn==null || ordn<=0) {
			ordn=99;
		}
		AlbumArticleClassify aac=albumArticleClassifyDaoImpl.findByID(cid);
		aac.setOrdn(ordn);
		albumArticleClassifyDaoImpl.modify(aac);
		return 0;
		
	}
	
	
	
	

}
