package com.lerx.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import com.lerx.analyze.util.AnalyzeUtil;
import com.lerx.annotation.Token;
import com.lerx.dao.iface.IAlbumArticleDao;
import com.lerx.dao.iface.IAlbumArticleHistoryDao;
import com.lerx.dao.iface.IAlbumArtsCountDao;
import com.lerx.dao.iface.IAlbumDao;
import com.lerx.dao.iface.IAlbumFansDao;
import com.lerx.dao.iface.IAlbgenreDao;
import com.lerx.dao.iface.IAlbgenreMangerDao;
import com.lerx.dao.iface.IAlbumArticleAttaDao;
import com.lerx.dao.iface.IAlbumArticleClassifyDao;
import com.lerx.dao.iface.IAlbumPartnerDao;
import com.lerx.dao.iface.ICommentBridgeDao;
import com.lerx.dao.iface.IGroupDao;
import com.lerx.dao.iface.IHtmlFileStaticDao;
import com.lerx.dao.iface.IMailTeamUnitDao;
import com.lerx.dao.iface.IMsgDao;
import com.lerx.dao.iface.IPollDao;
import com.lerx.dao.iface.IPortalDao;
import com.lerx.dao.iface.IRoleDao;
import com.lerx.dao.iface.ITempletAlbumMainDao;
import com.lerx.dao.iface.IUploadedFileDao;
import com.lerx.dao.iface.IUserArtsCountDao;
import com.lerx.dao.iface.IUserDao;
import com.lerx.entities.Albgenre;
import com.lerx.entities.Album;
import com.lerx.entities.AlbumArticle;
import com.lerx.entities.AlbumArticleClassify;
import com.lerx.entities.AlbumArticleContent;
import com.lerx.entities.AlbumArticleHistory;
import com.lerx.entities.AlbumFans;
import com.lerx.entities.AlbumPartner;
import com.lerx.entities.Article;
import com.lerx.entities.ArticleGroup;
import com.lerx.entities.CommentBridge;
import com.lerx.entities.HtmlFileStatic;
import com.lerx.entities.MailTeamUnit;
import com.lerx.entities.Msg;
import com.lerx.entities.Poll;
import com.lerx.entities.Portal;
import com.lerx.entities.Role;
import com.lerx.entities.TempletAlbumMain;
import com.lerx.entities.UploadedFile;
import com.lerx.entities.User;
import com.lerx.entities.VisitorsBook;
import com.lerx.hql.entities.Rs;
import com.lerx.login.util.LoginUtil;
import com.lerx.portal.obj.AacCollArgs;
import com.lerx.portal.obj.ArticleGroupMapCreateArgs;
import com.lerx.portal.obj.FileEl;
import com.lerx.portal.obj.ImgUploadSize;
import com.lerx.portal.obj.ReciveUserModular;
import com.lerx.portal.obj.SimpleArticle;
import com.lerx.portal.obj.SimpleReciveAlbgenre;
import com.lerx.portal.obj.SimpleReciveAlbum;
import com.lerx.portal.obj.SimpleReciveAlbumArticle;
import com.lerx.portal.obj.SimpleReciveUser;
import com.lerx.portal.obj.UacCollArgs;
import com.lerx.portal.obj.UploadArgs;
import com.lerx.sys.obj.Website;
import com.lerx.sys.util.FileUtil;
import com.lerx.sys.util.HttpUtil;
import com.lerx.sys.util.ObjUtil;
import com.lerx.sys.util.SecurityUtil;
import com.lerx.sys.util.StringUtil;
import com.lerx.sys.util.TimeUtil;
import com.lerx.v6.util.AlbgenreUtil;
import com.lerx.v6.util.AlbumArticleUtil;
import com.lerx.v6.util.AlbumUtil;
import com.lerx.v6.util.ArtAttaUtil;
import com.lerx.v6.util.ConfigUtil;
import com.lerx.v6.util.GroupUtil;
import com.lerx.v6.util.PartnerUtil;
import com.lerx.v6.util.PortalUtil;
import com.lerx.v6.util.ReciveUtil;
import com.lerx.v6.util.SitemapUtil;
import com.lerx.v6.util.SysUtil;
import com.lerx.v6.util.UploadUtil;
import com.lerx.v6.util.UserUtil;

@RequestMapping("/action_album_article")
@Controller
public class AlbumArticleHandler {

	@Value("${context.path}")
	private String contextPath;

	@Autowired
	private ResourceBundleMessageSource messageSource;

	private static final String ARTICLEEDIT = "jsp/album/article/add";
	private static final String ADDSUCCESS = "jsp/album/article/continue";
	private static final String LOGINPAGE = "jsp/user/login";
	private static final String FAILED = "jsp/result/failed";
	private static final String FORBIDU = "jsp/result/forbidu";
	private static final String ADMINFAILRETURN = "_admin.login.redirect_";

	@Autowired
	private IPortalDao portalDaoImpl;

	@Autowired
	private IUploadedFileDao uploadedFileDaoImpl;

	@Autowired
	private IAlbumDao albumDaoImpl;

	@Autowired
	private IAlbgenreDao albgenreDaoImpl;

	@Autowired
	private IAlbumArticleDao albumArticleDaoImpl;

	@Autowired
	private IAlbumArticleClassifyDao albumArticleClassifyDaoImpl;

	@Autowired
	private IAlbumArticleAttaDao albumArticleAttaDaoImpl;

	@Autowired
	private IAlbumArticleHistoryDao albumArticleHistoryDaoImpl;

	@Autowired
	private IAlbumPartnerDao albumPartnerDaoImpl;

	@Autowired
	private IUserArtsCountDao userArtsCountDaoImpl;

	@Autowired
	private IAlbumArtsCountDao albumArtsCountDaoImpl;

	@Autowired
	private IUserDao userDaoImpl;

	@Autowired
	private IRoleDao roleDaoImpl;

	@Autowired
	private IGroupDao groupDaoImpl;

	@Autowired
	private IAlbgenreMangerDao albgenreMangerDaoImpl;
	
	@Autowired
	private ITempletAlbumMainDao templetAlbumMainDaoImpl;

	@Autowired
	private IHtmlFileStaticDao htmlFileStaticDaoImpl;

	@Autowired
	private IAlbumFansDao albumFansDaoImpl;

	@Autowired
	private IMsgDao msgDaoImpl;
	
	@Autowired
	private IMailTeamUnitDao mailTeamUnitDaoImpl;

	@Autowired
	private IPollDao pollDaoImpl;

	@Autowired
	private ICommentBridgeDao commentBridgeDaoImpl;

	@ModelAttribute
	public void getAlbumArticle(@RequestParam(value = "id", required = false) Long id, Map<String, Object> map) {
		if (id != null && id > 0) {
			map.put("albumArticle", albumArticleDaoImpl.findByID(id));
		}
	}

	private static void htmlDel(AlbumArticle albumArticle, IHtmlFileStaticDao htmlFileStaticDaoImpl) {
		FileUtil.delete(FileUtil.appPath() + File.separator + albumArticle.getHfs().getRealPath());
		albumArticle.getHfs().setStatus(false);
		htmlFileStaticDaoImpl.modify(albumArticle.getHfs());
	}

	@RequestMapping(value = "/beforeAdd/{aid}")
	@Token(ajax = false, login = true, csrf = true, contrast = true, failedPage = LOGINPAGE, msgKey = "fail.permission")
	public String beforeAdd(@PathVariable(value = "aid", required = false) Long aid, Map<String, Object> map,
			HttpServletRequest request, HttpSession session) {
		Album album = albumDaoImpl.findByID(aid);
		Albgenre albgenre = albgenreDaoImpl.findByID(album.getGenre().getId());
		
		boolean addFree=false;

		if (albgenre.isOwnerSetAdder() && album.isMemberAdd()) {
			addFree=true;
		}
		

		long uid = LoginUtil.uid(messageSource, request);
		if (!addFree && !PartnerUtil.basicPowerChk(uid, album, albumPartnerDaoImpl)) {
			return FORBIDU;
		}
		
		TempletAlbumMain templet=album.getTemplet();
		if (templet==null) {
			templet=templetAlbumMainDaoImpl.findDef();
		}
		
		ImgUploadSize ius=AlbumUtil.fromTemplet(messageSource, templet);
		
		
		AlbumArticle article = new AlbumArticle();
		article.setStatus(true);
		article.setAlbum(album);

		List<AlbumArticleClassify> listg = albumArticleClassifyDaoImpl.findByGID(album.getGenre().getId());
		List<AlbumArticleClassify> lista = albumArticleClassifyDaoImpl.findByAID(album.getId());

		Comparator<AlbumArticleClassify> byMain = Comparator.comparing(AlbumArticleClassify::isMain);
		Comparator<AlbumArticleClassify> byOrdn = Comparator.comparing(AlbumArticleClassify::getOrdn);
		listg.sort(byOrdn.thenComparing(byMain));
		List<AlbumArticleClassify> list = new ArrayList<AlbumArticleClassify>();
		for (AlbumArticleClassify aac : listg) {
			list.add(aac);
		}

		lista.sort(byMain.thenComparing(byOrdn));

		for (AlbumArticleClassify aac : lista) {
			list.add(aac);
		}

		map.put("listClassify", list);
		map.put("albumArticle", article);
		map.put("currTime", System.currentTimeMillis());
		/*
		 * map.put("twidth", albgenre.getThumbnailDefWidth()); map.put("theight",
		 * albgenre.getThumbnailDefHeight());
		 */
		if (albgenre.getThumbnailDefWidth()>0) {
			ius.setThumbnailWidth(albgenre.getThumbnailDefWidth());
		}
		if (albgenre.getThumbnailDefHeight()>0) {
			ius.setThumbnailHeight(albgenre.getThumbnailDefHeight());
		}
		map.put("ius", ius);
//		map.put("album", album);
		return ARTICLEEDIT;
	}

	@RequestMapping("/add")
	@Token(ajax = false, csrf = true, token = true,contrast = true, log = true, mark = "album-article--<add>", login = true, failedPage = LOGINPAGE, msgKey = "fail.permission")
	public String add(@Valid AlbumArticle albumArticle, String attasStr,String token, Map<String, Object> map,
			HttpServletRequest request, HttpSession session) {
		Portal portal = portalDaoImpl.query_update();
		if (!portal.isReleaseAlbum()) {
			return FORBIDU;
		}
		long uid = LoginUtil.uid(messageSource, request);
		User user = userDaoImpl.findByID(uid);
		Album album=albumArticle.getAlbum();
		if (album != null) {
			album= albumDaoImpl.findByID(album.getId());
		}
		if (album == null || album.isDeled() || !album.isStatus() || !album.getGenre().isStatus()) {
			return FORBIDU;
		}
		Albgenre genre = albgenreDaoImpl.findByID(album.getGenre().getId());
		album.setGenre(genre);
		boolean admin = false;
		if (AlbgenreUtil.adminChk(user, genre, albgenreMangerDaoImpl)) {
			admin = true;
		}
//		System.out.println("albumArticle.getAlbum().getId():"+albumArticle.getAlbum().getId());
		//是否自由发表
		boolean addFree=false;

		if (album.getGenre().isOwnerSetAdder() && album.isMemberAdd()) {
			addFree=true;
		}
		
		if (!album.getGenre().isRelease() || (!PartnerUtil.basicPowerChk(uid, album, albumPartnerDaoImpl) && !admin && !addFree)) {
			return FORBIDU;
		}

		if (user == null || user.isGag() || user.getRole().isGag()) {
			map.put("msg", messageSource.getMessage("fail.gag", null, "You may be banned from speaking!", null));
			return FORBIDU;
		}
		if (admin || genre.isFree() || AlbumUtil.checker(album, user, albumPartnerDaoImpl)) {
			albumArticle.setStatus(true);
		}
		
		AlbumArticleContent content = albumArticle.getContent();
		content.setId(0); // 每次都更新

		if (albumArticle.getId() == 0) {
			content.setEditor(user);
		}
		
		content.setEditTime(System.currentTimeMillis());

		content = AlbumArticleUtil.validate(messageSource, content);

		content.setEditor(user);
		content.setContent(SysUtil.htmlAlockAnnotationFilter(content.getContent())); //去除html注释防止暗链
				
		albumArticle.setContent(content);

		HtmlFileStatic hfs;
		if (albumArticle.getId() > 0) {
			// 此处要加是否评论和点赞的改变检查
			if (AlbumArticleUtil.contentChgChk(albumArticle, albumArticleDaoImpl)
					&& AlbumArticleUtil.attaChgChk(albumArticle, albumArticleDaoImpl)
					&& AlbumArticleUtil.classChgChk(albumArticle, albumArticleDaoImpl)) {
				return ADDSUCCESS;
			}
			albumArticle.getCb().setHosturl(AlbumArticleUtil.url(albumArticle, messageSource, request));
			if (albumArticle.isSoul() && !admin) {
				albumArticle.setSoul(false);
			}
			albumArticleDaoImpl.modify(albumArticle, true, user);
			hfs = albumArticle.getHfs();
		} else {

			CommentBridge cb = new CommentBridge();
			cb.setUser(user);
			cb.setStatus(true);
			if (album.getCb() == null) {
				albumDaoImpl.modify(album);
				album = albumDaoImpl.findByID(album.getId());
			}
			cb.setParent(album.getCb());
			cb.setObjType(4);
			cb.setObjTitle(content.getSubject());
			cb.setObjTeam(album.getCb().getObjTeam());

			Poll poll = new Poll();
			poll.setStatus(portal.isPoll());
			poll.setObjTitle(albumArticle.getContent().getSubject());
			poll.setParent(album.getPoll());

			albumArticle.setCb(cb);
			albumArticle.setPoll(poll);

			VisitorsBook vbook = new VisitorsBook();
			vbook.setObjType(4);
			vbook.setObjTitle(albumArticle.getContent().getSubject());
			albumArticle.setVbook(vbook);

			hfs = new HtmlFileStatic();
			albumArticle.setHfs(hfs);
			albumArticle.setOwner(user);
			albumArticle=albumArticleDaoImpl.add(albumArticle);
			AlbumArticle art = albumArticleDaoImpl.findByID(albumArticle.getId());
			hfs = art.getHfs();
			FileEl fe = AlbumArticleUtil.feBuild(messageSource, request, art, false);
			hfs.setRealPath(fe.getRealPath());
			hfs.setUrl(fe.getUrl());
			hfs.setFilename(FileUtil.getFileFromPath(fe.getRealPath()));
			hfs.setStatus(true);
			art.setHfs(hfs);

			albumArticleDaoImpl.modify(art, false, user);
			art = albumArticleDaoImpl.findByID(albumArticle.getId());
			String url;
			if (art.isStatus() && art.getHfs() != null && art.getHfs().isStatus()) {
				url = AlbumArticleUtil.url(art, messageSource, request);
			} else {

				url = HttpUtil.getSrvUrl(request, true)+ "/show_album/art/" + art.getId();
				url=HttpUtil.repairUrl(url);
			}
			
			String alburl=AlbumUtil.getHref(messageSource, request, album, true);
			
			System.out.println("url:"+url);
			System.out.println("alburl:"+alburl);
			cb = art.getCb();
			cb.setHosturl(url);
			art.setCb(cb);
			albumArticleDaoImpl.modify(art, false, user);
			// 测试

			album = art.getAlbum();
			album.setTotalArt(albumArticleDaoImpl.countByAlbumID(album.getId()));
			album.setTotalProhibit(albumArticleDaoImpl.countProhibitByAlbumID(album.getId()));
			album.setLastEditTime(System.currentTimeMillis());
			album.setLastModifyTime(System.currentTimeMillis());
			albumDaoImpl.modify(album);

			// 更新发布数

			UacCollArgs uca = new UacCollArgs();
			uca.setUser(user);
			uca.setAtype(1);
			uca.setCreationDT(System.currentTimeMillis());
			uca.setTag(0);
			uca.setV(1);
			uca.setUserArtsCountDaoImpl(userArtsCountDaoImpl);
			UserUtil.uacUpdate(uca);
			uca.setTag(1);
			UserUtil.uacUpdate(uca);

			AacCollArgs aca = new AacCollArgs();
			aca.setAlbum(album);
			aca.setAlbumArtsCountDaoImpl(albumArtsCountDaoImpl);
			aca.setCreationDT(System.currentTimeMillis());
			aca.setTag(0);
			aca.setV(1);
			AlbumUtil.aacUpdate(aca);
			aca.setTag(1);
			AlbumUtil.aacUpdate(aca);
			if (albumArticle.isStatus()) {
				// 通知粉丝
				List<AlbumFans> fanslist = albumFansDaoImpl.findByAid(album.getId());
				String msgContent = FileUtil.readRes(messageSource, "msg_new_album_article");
				List<Msg> listMsg = new ArrayList<Msg>();
				for (AlbumFans fans : fanslist) {
					String msgTmp = msgContent;
					Msg msg = new Msg();
					msg.setSender(user);
					msg.setRecipient(fans.getUser());
					msg.setSendtime(System.currentTimeMillis());
					msg.setMtype(1);
					msg.setUrl(url);
					msg.setStatus(true);
					msgTmp=AnalyzeUtil.replace(msgTmp, "tag", "url", url);
					msgTmp = AlbumArticleUtil.fmt(msgTmp, art, url);
					msg.setContent(msgTmp);
					msg.setCtext(StringUtil.htmlFilter(msgTmp, true));
					msg.setMainUuid(art.getUuid());
					listMsg.add(msg);

				}

				if (!listMsg.isEmpty()) {
					msgDaoImpl.excuteBatchSave(listMsg);
				}
				SitemapUtil.write(messageSource, request, art);
			}else {//如果状态未通过，通知审核员
				List<User> checkers = PartnerUtil.queryChecker(album.getId(), albumDaoImpl, albumPartnerDaoImpl);
				String msgContent = FileUtil.readRes(messageSource, "msg_pass_new_art");
				String mailContent = FileUtil.readRes(messageSource, "mail_pass_new_art");
				List<Msg> listMsg = new ArrayList<Msg>();
				for (User checker:checkers) {
					String msgTmp = msgContent;
					String mailTmp = mailContent;
					Msg msg = new Msg();
					msg.setSender(user);
					msg.setRecipient(checker);
					msg.setSendtime(System.currentTimeMillis());
					msg.setMtype(1);
					msg.setUrl(url);
					msg.setStatus(true);
					
					msgTmp=AnalyzeUtil.replace(msgTmp, "tag", "url", url);
					mailTmp=AnalyzeUtil.replace(mailTmp, "tag", "url", url);
					
					msgTmp=AnalyzeUtil.replace(msgTmp, "tag", "alburl", alburl);
					mailTmp=AnalyzeUtil.replace(mailTmp, "tag", "alburl", alburl);
					
					msgTmp = AlbumArticleUtil.fmt(msgTmp, art, url);
					mailTmp = AlbumArticleUtil.fmt(mailTmp, art, url);
					
					msgTmp = UserUtil.fmt(msgTmp, user, null);
					mailTmp = UserUtil.fmt(mailTmp, user, null);
					
					msg.setContent(msgTmp);
					msg.setCtext(StringUtil.htmlFilter(msgTmp, true));
					listMsg.add(msg);
					msgDaoImpl.add(msg);
					
					if (UserUtil.mailUsable(checker)!=null ) {
						MailTeamUnit unit = new MailTeamUnit();
						unit.setCreateDT(System.currentTimeMillis());
						unit.setContent(mailTmp);
						unit.setDeled(false);
						unit.setFailures(0);
						unit.setRecipient(checker.getEmail());
						unit.setSender(user.getUsername());
						unit.setStatus(false);
						unit.setSubject(messageSource.getMessage("title.mail.art.pass", null, "New article must to be passed.", null));
						unit.setTxt(mailTmp);
						unit.setCreater(user);
						
						mailTeamUnitDaoImpl.add(unit);
					}
					
				}
			}

		}

		// 更新合作的文章数
		AlbumPartner partner = albumPartnerDaoImpl.findByAIDAndUid(albumArticle.getAlbum().getId(), uid);
		if (partner != null) {
			long countArt = albumArticleDaoImpl.countByPartnerID(partner.getId());
			partner.setTotalArts(countArt);
			albumPartnerDaoImpl.modify(partner);
		}

		albumArticle = albumArticleDaoImpl.findByID(albumArticle.getId());
		ArtAttaUtil.refresh(albumArticle, attasStr, albumArticleAttaDaoImpl);
		albumArticle = AlbumArticleUtil.srtUpdate(albumArticle);
		albumArticle.getSrt().setOperator(user);
		String folder = messageSource.getMessage("res", null, "res", null);
		String riskLevelFilePre = FileUtil.webinfPath()+File.separator+folder+File.separator+"risk_level";
		String riskBody=StringUtil.nullFilter(albumArticle.getContent().getSubject())+","+StringUtil.nullFilter(albumArticle.getContent().getSubjectShort())+","+StringUtil.nullFilter(albumArticle.getContent().getContent())+","+StringUtil.nullFilter(albumArticle.getContent().getSynopsis())+","+StringUtil.nullFilter(albumArticle.getContent().getExtra());
		int level=SysUtil.riskLevelSet(riskBody, riskLevelFilePre);
		albumArticle.getSrt().setRiskLevel(level);
		if (level>0) {
			albumArticle.getSrt().setRiskContent(riskBody);
		}else {
			albumArticle.getSrt().setRiskContent(null);
		}
		albumArticle.getSrt().setHref(AlbumArticleUtil.url(albumArticle, messageSource, request));
		albumArticleDaoImpl.modify(albumArticle, false, user);
		
		if (albumArticle.isStatus()) {
			AlbumArticleUtil.htmlCreate(albumArticle, messageSource, request, htmlFileStaticDaoImpl, contextPath);
			// 更新专辑首页
			AlbumUtil.htmlCreate(album, messageSource, contextPath, true);
		}
		
		map.put("parm", albumArticle.getAlbum().getId());

		return ADDSUCCESS;
	}

	/*
	 * 检测当前登录用户在当前文章中的权限 如果文章id为0，则为新增。
	 */
	@ResponseBody
	@RequestMapping(value = "/loginer/{id}")
	@Token(ajax = true, csrf = true, contrast = true)
	public int auditloginer(@PathVariable("id") Long id, Map<String, Object> map, HttpServletRequest request,
			HttpSession session) {
		long uid = LoginUtil.uid(messageSource, request);
		if (uid > 0) {

			if (id == 0) {
				return 1;
			} else {
				AlbumArticle article = albumArticleDaoImpl.findByID(id);
				if (!PartnerUtil.basicPowerChk(uid, article.getAlbum(), albumPartnerDaoImpl)) {
					return -200;
				} else {
					return 1;
				}
			}

		} else {
			return -201;
		}

	}

	@RequestMapping(value = "/edit/{id}", method = RequestMethod.GET)
	@Token(ajax = false, login = true, csrf = true, contrast = true, failedPage = LOGINPAGE)
	public String edit(@PathVariable("id") Long id, Map<String, Object> map, HttpServletRequest request,
			HttpSession session) {
		AlbumArticle albumArticle = albumArticleDaoImpl.findByID(id);
		if (albumArticle == null || albumArticle.isProhibit()) {
			return FORBIDU;
		}
		long uid = LoginUtil.uid(messageSource, request);
		User arbitrator = userDaoImpl.findByID(uid);
		boolean admin = false;
		boolean chgAddTime = true;
		Album album = albumDaoImpl.findByID(albumArticle.getAlbum().getId());
		if (album == null || album.isDeled() || !album.isStatus() || !album.getGenre().isStatus()) {
			return FORBIDU;
		}
		if (AlbgenreUtil.adminChk(arbitrator, albumArticle.getAlbum().getGenre(), albgenreMangerDaoImpl)) {
			admin = true;
		}

		if (!admin && !PartnerUtil.basicPowerChk(uid, albumArticle.getAlbum(), albumPartnerDaoImpl)) {
			return FORBIDU;
		}
		
		TempletAlbumMain templet=album.getTemplet();
		if (templet==null) {
			templet=templetAlbumMainDaoImpl.findDef();
		}
		
		ImgUploadSize ius=AlbumUtil.fromTemplet(messageSource, templet);
		
		if (!albumArticle.getAlbum().getGenre().isFreeArtAddTime() && !admin) {
			chgAddTime = false;
		}
		AlbumArticleContent content = albumArticle.getContent();
		content.setSubject(StringUtil.htmlRiskFilter(content.getSubject()));
		content.setSubjectShort(StringUtil.htmlRiskFilter(content.getSubjectShort()));
		content.setExtra(StringUtil.htmlRiskFilter(content.getExtra()));
		content.setToppic(StringUtil.htmlRiskFilter(content.getToppic()));
		
		albumArticle.setContent(content);

		List<AlbumArticleClassify> listg = albumArticleClassifyDaoImpl.findByGID(album.getGenre().getId());
		List<AlbumArticleClassify> lista = albumArticleClassifyDaoImpl.findByAID(album.getId());

		Comparator<AlbumArticleClassify> byMain = Comparator.comparing(AlbumArticleClassify::isMain);
		Comparator<AlbumArticleClassify> byOrdn = Comparator.comparing(AlbumArticleClassify::getOrdn);
		listg.sort(byOrdn.thenComparing(byMain));
		List<AlbumArticleClassify> list = new ArrayList<AlbumArticleClassify>();
		for (AlbumArticleClassify aac : listg) {
			list.add(aac);
		}

		lista.sort(byMain.thenComparing(byOrdn));

		for (AlbumArticleClassify aac : lista) {
			list.add(aac);
		}

		map.put("listClassify", list);
		map.put("albumArticle", albumArticle);
		map.put("chgAddTime", chgAddTime);
		
		String mask=arbitrator.getRole().getMask();
		if (mask!=null && mask.trim().equals("0")) {
			map.put("admin", true);
		}
		
		Albgenre albgenre = albgenreDaoImpl.findByID(album.getGenre().getId());
		if (albgenre.getThumbnailDefWidth()>0) {
			ius.setThumbnailWidth(albgenre.getThumbnailDefWidth());
		}
		if (albgenre.getThumbnailDefHeight()>0) {
			ius.setThumbnailHeight(albgenre.getThumbnailDefHeight());
		}
		map.put("ius", ius);
		long currTime = System.currentTimeMillis();
		map.put("currTime", currTime);
		return ARTICLEEDIT;
	}

	// 专辑中文章列表
	@RequestMapping(value = { "/list/{aid}/{status}/{page}/{pagesize}", "/list/{aid}/{status}" })
	@Token(ajax = false, login = true, csrf = true, contrast = true, failedPage = FORBIDU)
	public String list(@PathVariable(value = "aid", required = false) Long aid,
			@PathVariable(value = "status", required = false) Integer status,
			@PathVariable(value = "page", required = false) Integer page,
			@PathVariable(value = "pagesize", required = false) Integer pagesize, HttpServletRequest request,
			Map<String, Object> map) {
		long uid = LoginUtil.uid(messageSource, request);
		if (aid == null) {
			aid = 0L;
		}
		Album album = albumDaoImpl.findByID(aid);
		if (album == null || album.isDeled() || !album.isStatus()) {
			return FORBIDU;
		}
		if (!PartnerUtil.basicPowerChk(uid, album, albumPartnerDaoImpl)) {
			return FORBIDU;
		}

		if (status == null) {
			status = 0;
		}
		boolean asc = false;
		if (page == null) {
			page = 1;
		}
		if (pagesize == null) {
			pagesize = 10;
		}
		int artOrdBy = Integer.valueOf(messageSource.getMessage("album.art.orderby.mod", null, "0", null));

		Rs rs = albumArticleDaoImpl.queryByAid(aid, status, 1, 0, 0, 0, 0, page, pagesize, asc, 0, 0, artOrdBy,
				ConfigUtil.wvov(messageSource));
		@SuppressWarnings("unchecked")
		List<AlbumArticle> list = (List<AlbumArticle>) rs.getList();
		List<AlbumArticle> list2 = new ArrayList<AlbumArticle>();
		for (AlbumArticle art : list) {
			art = albumArticleDaoImpl.findByID(art.getId());
			list2.add(art);
		}
		rs.setList(list2);
		map.put("albid", aid);
		map.put("rs", rs);
		map.put("pageUrl", "action_album_article/list/" + aid + "/" + status);
		return "jsp/album/article/list";
	}

	// 频道内文章列表
	@RequestMapping(value = { "/listInGenre/{gid}/{stamp}", "/listInGenre/{gid}/{stamp}/{page}/{pagesize}" })
	@Token(ajax = false, admin = true, csrf = true, contrast = true, failedPage = FAILED, failedReturnUrl = ADMINFAILRETURN)
	public String listInGenre(@PathVariable(value = "gid", required = false) Long gid,
			@PathVariable(value = "stamp", required = false) Integer stamp,
			@PathVariable(value = "page", required = false) Integer page,
			@PathVariable(value = "pagesize", required = false) Integer pagesize, HttpServletRequest request,
			Map<String, Object> map) {
		if (gid == null) {
			gid = 0L;
		}
		if (stamp == null) {
			stamp = 0;
		}
		boolean asc = false;
		if (page == null) {
			page = 1;
		}
		if (pagesize == null) {
			pagesize = 10;
		}
		int artOrdBy = Integer.valueOf(messageSource.getMessage("album.art.orderby.mod", null, "0", null));
		Rs rs = albumArticleDaoImpl.queryByGid(gid, 0, 0, 0, 0, 0, 0, page, pagesize, asc, 0, 0, artOrdBy,
				ConfigUtil.wvov(messageSource));
		@SuppressWarnings("unchecked")
		List<AlbumArticle> list = (List<AlbumArticle>) rs.getList();
		List<AlbumArticle> list2 = new ArrayList<AlbumArticle>();
		for (AlbumArticle art : list) {
			art = albumArticleDaoImpl.findByID(art.getId());
			art.setSubject(StringUtil.htmlRiskFilter(art.getContent().getSubject()));
			art.setSubjectShort(StringUtil.htmlRiskFilter(art.getSubjectShort()));
			list2.add(art);
		}
		rs.setList(list2);
		map.put("rs", rs);
		map.put("pageUrl", "action_album_article/listInGenre/" + gid);
		if (stamp == 0) {
			return "jsp/album/genre/artlist";
		} else {
			return "jsp/album/genre/artlist2";
		}

	}

	// 频道内文章列表
	@RequestMapping(value = { "/listExt/{gid}/{ordn}", "/listExt/{gid}/{ordn}/{page}/{pagesize}" })
	@Token(ajax = false, admin = true, csrf = true, contrast = true, failedPage = FAILED, failedReturnUrl = ADMINFAILRETURN)
	public String listExt(@PathVariable(value = "gid", required = false) Long gid,
			@PathVariable(value = "ordn", required = false) Integer ordn,
			@PathVariable(value = "page", required = false) Integer page,
			@PathVariable(value = "pagesize", required = false) Integer pagesize, HttpServletRequest request,
			Map<String, Object> map) {
		if (gid == null) {
			gid = 0L;
		}
		if (ordn == null) {
			ordn = 0;
		}
		boolean asc = false;
		if (page == null) {
			page = 1;
		}
		if (pagesize == null) {
			pagesize = 10;
		}
		
		Rs rs = albumArticleDaoImpl.queryByGid(gid, 0, 0, 0, 0, 0, 0, page, pagesize, asc, 0, 0, ordn,
				ConfigUtil.wvov(messageSource));
		@SuppressWarnings("unchecked")
		List<AlbumArticle> list = (List<AlbumArticle>) rs.getList();
		List<AlbumArticle> list2 = new ArrayList<AlbumArticle>();
		for (AlbumArticle art : list) {
			art = albumArticleDaoImpl.findByID(art.getId());
			art.setSubject(StringUtil.htmlRiskFilter(art.getContent().getSubject()));
			art.setSubjectShort(StringUtil.htmlRiskFilter(art.getContent().getSubjectShort()));
			list2.add(art);
		}
		rs.setList(list2);
		map.put("rs", rs);
		map.put("ordn", ordn);
		map.put("pageUrl", "action_album_article/listExt/" + gid+"/"+ordn);
		return "jsp/album/genre/artlist3";
	}

	@ResponseBody
	@RequestMapping(value = "/del/{id}")
	@Token(ajax = true, csrf = true, contrast = true, log = true, mark = "album-article--<del>", login = true)
	public int del(@PathVariable("id") Long id, Map<String, Object> map, HttpServletRequest request,
			HttpSession session) {
		boolean soul = false;
		long uid = LoginUtil.uid(messageSource, request);
		User deler = userDaoImpl.findByID(uid);
		if (deler == null) {
			return -201;
		}
		AlbumArticle art = albumArticleDaoImpl.findByID(id);
		if (art == null) {
			return -400;
		}
		Album album = art.getAlbum();
		if (album == null || album.isDeled() || !album.isStatus()) {
			return -400;
		}
		if (!PartnerUtil.basicPowerChk(uid, art.getAlbum(), albumPartnerDaoImpl)) {
			return -200;
		}
		if (art.isSoul()) {
			soul = true;
		}

		htmlDel(art, htmlFileStaticDaoImpl);
		albumArticleDaoImpl.delByID(id, deler);
		art = albumArticleDaoImpl.findByID(art.getId());
		album.setTotalArt(albumArticleDaoImpl.countByAlbumID(album.getId()));
		album.setLastModifyTime(System.currentTimeMillis());
		albumDaoImpl.modify(album);

		// 更新合作的文章数
		AlbumPartner partner = albumPartnerDaoImpl.findByAIDAndUid(album.getId(), uid);
		if (partner != null) {
			long countArt = albumArticleDaoImpl.countByPartnerID(partner.getId());
			partner.setTotalArts(countArt);
			albumPartnerDaoImpl.modify(partner);
		}

		art = AlbumArticleUtil.srtUpdate(art);
		art.getSrt().setHref(AlbumArticleUtil.url(art, messageSource, request));
		albumArticleDaoImpl.modify(art, false, deler);

		// 更新专辑首页
		AlbumUtil.htmlCreate(album, messageSource, contextPath, true);

		msgDaoImpl.excuteCleanByUuid(art.getUuid());

		// 更新发布数

		UacCollArgs uca = new UacCollArgs();
		uca.setUser(art.getOwner());
		uca.setAtype(1);
		uca.setCreationDT(art.getCreationTime());
		uca.setTag(0);
		uca.setUserArtsCountDaoImpl(userArtsCountDaoImpl);
		uca.setV(-1);
		UserUtil.uacUpdate(uca);
		uca.setTag(1);
		UserUtil.uacUpdate(uca);

		AacCollArgs aca = new AacCollArgs();
		aca.setAlbum(album);
		aca.setAlbumArtsCountDaoImpl(albumArtsCountDaoImpl);
		aca.setCreationDT(System.currentTimeMillis());
		aca.setTag(0);
		aca.setV(-1);
		AlbumUtil.aacUpdate(aca);
		aca.setTag(1);
		AlbumUtil.aacUpdate(aca);
		if (soul) {
			aca.setTag(2);
			aca.setV(-1);
			AlbumUtil.aacUpdate(aca);
		}
		return 0;
	}

	@ResponseBody
	@RequestMapping(value = "/undel/{id}")
	@Token(ajax = true, csrf = true, contrast = true, log = true, mark = "album-article--<undel>", login = true)
	public int undel(@PathVariable("id") Long id, Map<String, Object> map, HttpServletRequest request,
			HttpSession session) {
		long uid = LoginUtil.uid(messageSource, request);
		User operator = userDaoImpl.findByID(uid);
		AlbumArticle art = albumArticleDaoImpl.findByID(id);
		if (art == null || art.isProhibit()) {
			return -400;
		}
		Album album = art.getAlbum();
		if (album == null || album.isDeled() || !album.isStatus()) {
			return -400;
		}
		if (album.isConservative()) {
			if (album.getLeader().getId() != uid) {
				return -200;
			}
		} else {
			if (!PartnerUtil.basicPowerChk(uid, art.getAlbum(), albumPartnerDaoImpl)) {
				return -200;
			}
		}
		albumArticleDaoImpl.undelByID(id);
		art = albumArticleDaoImpl.findByID(id);

		album.setTotalArt(albumArticleDaoImpl.countByAlbumID(album.getId()));
		album.setLastModifyTime(System.currentTimeMillis());
		albumDaoImpl.modify(album);

		// 更新合作的文章数
		AlbumPartner partner = albumPartnerDaoImpl.findByAIDAndUid(album.getId(), uid);
		if (partner != null) {
			long countArt = albumArticleDaoImpl.countByPartnerID(partner.getId());
			partner.setTotalArts(countArt);
			albumPartnerDaoImpl.modify(partner);
		}
		// 重新生成静态文件
		AlbumArticleUtil.htmlCreate(art, messageSource, request, htmlFileStaticDaoImpl, contextPath);

		art = AlbumArticleUtil.srtUpdate(art);
		art.getSrt().setHref(AlbumArticleUtil.url(art, messageSource, request));
		albumArticleDaoImpl.modify(art, false, operator);

		// 更新专辑首页
		AlbumUtil.htmlCreate(album, messageSource, contextPath, true);

		// 更新发布数

		UacCollArgs uca = new UacCollArgs();
		uca.setUser(art.getOwner());
		uca.setAtype(1);
		uca.setCreationDT(art.getCreationTime());
		uca.setTag(0);
		uca.setUserArtsCountDaoImpl(userArtsCountDaoImpl);
		uca.setV(1);
		UserUtil.uacUpdate(uca);
		uca.setTag(1);
		UserUtil.uacUpdate(uca);

		AacCollArgs aca = new AacCollArgs();
		aca.setAlbum(album);
		aca.setAlbumArtsCountDaoImpl(albumArtsCountDaoImpl);
		aca.setCreationDT(System.currentTimeMillis());
		aca.setTag(0);
		aca.setV(1);
		AlbumUtil.aacUpdate(aca);

		aca.setTag(1);
		AlbumUtil.aacUpdate(aca);
		if (art.isSoul()) {
			aca.setTag(2);
			aca.setV(1);
			AlbumUtil.aacUpdate(aca);
		}

		return 0;
	}

	@ResponseBody
	@RequestMapping(value = "/prohibit/{id}")
	@Token(ajax = true, csrf = true, contrast = true, log = true, mark = "album-article--<prohibit>", login = true)
	public int prohibit(@PathVariable("id") Long id, Map<String, Object> map, HttpServletRequest request,
			HttpSession session) {
		long uid = LoginUtil.uid(messageSource, request);
		AlbumArticle art = albumArticleDaoImpl.findByID(id);
		if (art == null) {
			return -400;
		}
		String subject = art.getContent().getSubject();

		Album album = art.getAlbum();
		if (album == null || album.isDeled() || !album.isStatus()) {
			return -400;
		}
		User arbitrator = userDaoImpl.findByID(uid);
		if (!AlbgenreUtil.adminChk(arbitrator, art.getAlbum().getGenre(), albgenreMangerDaoImpl)) {
			return -200;
		}


		albumArticleDaoImpl.modifyProhibitByID(id, arbitrator);
		art = albumArticleDaoImpl.findByID(art.getId());
		htmlDel(art, htmlFileStaticDaoImpl);

		album.setLastModifyTime(System.currentTimeMillis());
		album.setTotalProhibit(albumArticleDaoImpl.countProhibitByAlbumID(album.getId()));
		albumDaoImpl.modify(album);

		// 更新合作的文章数
		AlbumPartner partner = albumPartnerDaoImpl.findByAIDAndUid(album.getId(), uid);
		if (partner != null) {
			long countArt = albumArticleDaoImpl.countByPartnerID(partner.getId());
			partner.setTotalArts(countArt);
			albumPartnerDaoImpl.modify(partner);
		}

		art = AlbumArticleUtil.srtUpdate(art);
		art.getSrt().setHref(AlbumArticleUtil.url(art, messageSource, request));
		albumArticleDaoImpl.modify(art, false, arbitrator);

		// 更新专辑首页
		AlbumUtil.htmlCreate(album, messageSource, contextPath, true);

		msgDaoImpl.excuteCleanByUuid(art.getUuid());

		// 向作者发送通知
		User albLeader = art.getAlbum().getLeader();
		String contentProhibit;
		contentProhibit = FileUtil.readRes(messageSource, "template_prohibit_albart");
		Portal portal = portalDaoImpl.query_update();
		Website site = PortalUtil.lead(portal);
		contentProhibit = HttpUtil.siteImplant(contentProhibit, site, request);
		contentProhibit = AnalyzeUtil.replace(contentProhibit, "tag", "portalName", portal.getName());
		
		String nickname=albLeader.getNickname();
		if (nickname==null || nickname.trim().equals("")) {
			nickname=albLeader.getUsername();
		}
		
		contentProhibit = AnalyzeUtil.replace(contentProhibit, "tag", "nickname", nickname);
		
		contentProhibit = AnalyzeUtil.replace(contentProhibit, "tag", "username", albLeader.getUsername());
		contentProhibit = AnalyzeUtil.replace(contentProhibit, "tag", "albgenre", art.getAlbum().getGenre().getName());
		contentProhibit = AnalyzeUtil.replace(contentProhibit, "tag", "subject", subject);
		contentProhibit = AnalyzeUtil.replace(contentProhibit, "tag", "portalUrl", portal.getUrl());
		contentProhibit = AnalyzeUtil.replace(contentProhibit, "tag", "datetime",
				TimeUtil.coverLongToStr(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss"));

		Set<User> suser = new HashSet<User>();

		User editor = art.getContent().getEditor();
		if (editor != null) {
			suser.add(editor);
		}
		if (UserUtil.mailUsable(albLeader) != null) {
			suser.add(albLeader);
		}

		if (suser.size() > 0) {

			String recipients = "";
			for (User u : suser) {
				recipients += u.getEmail() + ";";
			}
			
			
			MailTeamUnit unit = new MailTeamUnit();
			unit.setCreateDT(System.currentTimeMillis());
			unit.setContent(contentProhibit);
			unit.setDeled(false);
			unit.setFailures(0);
			unit.setRecipient(recipients);
			unit.setSender(arbitrator.getUsername());
			unit.setStatus(false);
			
			unit.setSubject(messageSource.getMessage("title.prohibit", null, "prohibit ", null)+subject);
			unit.setTxt(contentProhibit);
			unit.setCreater(arbitrator);
			
			mailTeamUnitDaoImpl.add(unit);
			
			/*
			if (mailSrvConfigSuccess.trim().equalsIgnoreCase("true")) {
				MailMessage mes = new MailMessage();
				mes.setCharset(charset);
				mes.setRecipient(recipients);
				String msubject = messageSource.getMessage("mail.subject.title.comment", null,
						"You have a new comment in {$tag:portalName$}.", null);
				msubject = AnalyzeUtil.replace(msubject, "tag", "portalName", portal.getName());
				mes.setSubject(msubject);
				mes.setBody(contentProhibit);
				MailUtil.send(mes);
			}
			*/

		}

		UacCollArgs uca = new UacCollArgs();
		uca.setUser(art.getOwner());
		uca.setAtype(1);
		uca.setCreationDT(art.getCreationTime());
		uca.setTag(1);
		uca.setUserArtsCountDaoImpl(userArtsCountDaoImpl);
		uca.setV(-1);
		UserUtil.uacUpdate(uca);

		return 0;
	}

	@ResponseBody
	@RequestMapping(value = "/release/{id}")
	@Token(ajax = true, csrf = true, contrast = true, log = true, mark = "album-article--<release>", login = true)
	public int release(@PathVariable("id") Long id, Map<String, Object> map, HttpServletRequest request,
			HttpSession session) {
		long uid = LoginUtil.uid(messageSource, request);
		AlbumArticle art = albumArticleDaoImpl.findByID(id);
		if (art == null) {
			return -400;
		}
		Album album = art.getAlbum();
		if (album == null || album.isDeled() || !album.isStatus() || !album.getGenre().isStatus()) {
			return -400;
		}
		User arbitrator = userDaoImpl.findByID(uid);
		if (!AlbgenreUtil.adminChk(arbitrator, art.getAlbum().getGenre(), albgenreMangerDaoImpl)) {
			return -200;
		}

		albumArticleDaoImpl.modifyReleaseByID(id, arbitrator);
		art = albumArticleDaoImpl.findByID(id);
		album.setLastModifyTime(System.currentTimeMillis());
		album.setTotalProhibit(albumArticleDaoImpl.countProhibitByAlbumID(album.getId()));
		albumDaoImpl.modify(album);

		// 更新合作的文章数
		AlbumPartner partner = albumPartnerDaoImpl.findByAIDAndUid(album.getId(), uid);
		if (partner != null) {
			long countArt = albumArticleDaoImpl.countByPartnerID(partner.getId());
			partner.setTotalArts(countArt);
			albumPartnerDaoImpl.modify(partner);
		}
		AlbumArticleUtil.htmlCreate(art, messageSource, request, htmlFileStaticDaoImpl, contextPath);

		art = AlbumArticleUtil.srtUpdate(art);
		art.getSrt().setHref(AlbumArticleUtil.url(art, messageSource, request));
		albumArticleDaoImpl.modify(art, false, arbitrator);

		// 更新专辑首页
		AlbumUtil.htmlCreate(album, messageSource, contextPath, true);

		UacCollArgs uca = new UacCollArgs();
		uca.setUser(art.getOwner());
		uca.setAtype(1);
		uca.setCreationDT(art.getCreationTime());
		uca.setTag(1);
		uca.setUserArtsCountDaoImpl(userArtsCountDaoImpl);
		uca.setV(1);
		UserUtil.uacUpdate(uca);
		return 0;
	}

	/*
	 * 文章历史编辑点还原
	 */
	@ResponseBody
	@RequestMapping(value = "/restore/{id}")
	@Token(ajax = true, csrf = true, contrast = true, log = true, mark = "album-article--<restore>", login = true)
	public int restore(@PathVariable("id") Long id, Map<String, Object> map, HttpServletRequest request,
			HttpSession session) {
		long uid = LoginUtil.uid(messageSource, request);
		User operator = userDaoImpl.findByID(uid);
		if (operator == null) {
			return -201;
		}
		AlbumArticleHistory history = albumArticleHistoryDaoImpl.findByID(id);
		AlbumArticle art = history.getArt();
		if (art == null) {
			return -400;
		}
		Album album = art.getAlbum();
		if (album == null || album.isDeled() || !album.isStatus() || !album.getGenre().isStatus()) {
			return -400;
		}
		if (album.isConservative()) {
			if (!AlbumUtil.isLeader(album, uid, albumPartnerDaoImpl)) {
				return -200;
			}
		} else {
			if (!PartnerUtil.basicPowerChk(uid, art.getAlbum(), albumPartnerDaoImpl)) {
				return -200;
			}
		}
		albumArticleHistoryDaoImpl.delAfterID(id);
		art = albumArticleDaoImpl.findByID(art.getId());
		boolean admin = false;
		Albgenre genre = albgenreDaoImpl.findByID(album.getGenre().getId());
		if (AlbgenreUtil.adminChk(operator, genre, albgenreMangerDaoImpl)) {
			admin = true;
		}
		if (art.isSoul() && !admin) {
			art.setSoul(false);
		}
		albumArticleDaoImpl.modify(art, false, operator);

		art = AlbumArticleUtil.srtUpdate(art);
		art.getSrt().setHref(AlbumArticleUtil.url(art, messageSource, request));
		albumArticleDaoImpl.modify(art, false, operator);

		// 更新专辑首页
		AlbumUtil.htmlCreate(album, messageSource, contextPath, true);

		return 0;
	}

	@ResponseBody
	@RequestMapping(value = "/soul/{id}/{status}")
	@Token(ajax = true, csrf = true, contrast = true, log = true, mark = "album-article--<soul>")
	public int modifySoul(@PathVariable(value = "id", required = true) Long id,
			@PathVariable(value = "status", required = true) Integer status, HttpServletRequest request) {
		long uid = LoginUtil.uid(messageSource, request);
		User user = userDaoImpl.findByID(uid);
		AlbumArticle article = albumArticleDaoImpl.findByID(id);
		if (article == null || article.isProhibit()) {
			return -404;
		}
		if (!AlbgenreUtil.adminChk(user, article.getAlbum().getGenre(), albgenreMangerDaoImpl)) {
			return -200;
		}
		Album album = article.getAlbum();
		if (album == null || album.isDeled() || !album.isStatus() || !album.getGenre().isStatus()) {
			return -400;
		}
		long totalSoul = album.getTotalArtSoul();
		AacCollArgs aca = new AacCollArgs();
		aca.setAlbum(album);
		aca.setAlbumArtsCountDaoImpl(albumArtsCountDaoImpl);
		aca.setCreationDT(System.currentTimeMillis());
		aca.setTag(2); // 0是全部1是通过数2是精华

		if (status == 0) {
			if (article.isSoul()) {
				aca.setV(-1);
				totalSoul--;
				if (totalSoul < 0) {
					totalSoul = 0;
				}
			}
			article.setSoul(false);

		} else {
			aca.setV(1);
			if (!article.isSoul()) {
				totalSoul++;
			}
			article.setSoul(true);
		}

		AlbumUtil.aacUpdate(aca);

		albumArticleDaoImpl.modify(article, false, user);
		album.setTotalArtSoul(totalSoul);
		albumDaoImpl.update(album);

		return 0;

	}

	@ResponseBody
	@RequestMapping(value = "/top/{id}/{status}")
	@Token(ajax = true, csrf = true, contrast = true, log = true, mark = "album-article--<top>")
	public int modifyTopOne(@PathVariable(value = "id", required = true) Long id,
			@PathVariable(value = "status", required = true) Integer status, HttpServletRequest request) {
		// <--该代码在专辑中暂不允许执行
		if (status > -999) {
			return -403;
		}
		// -->该代码在专辑中暂不允许执行
		long uid = LoginUtil.uid(messageSource, request);

		AlbumArticle article = albumArticleDaoImpl.findByID(id);
		if (article == null || article.isProhibit()) {
			return -404;
		}
		Album album = albumDaoImpl.findByID(article.getAlbum().getId());
		if (album == null || album.isDeled() || !album.isStatus() || !album.getGenre().isStatus()) {
			return -400;
		}
		if (!PartnerUtil.basicPowerChk(uid, article.getAlbum(), albumPartnerDaoImpl)) {
			return -200;
		}
		boolean sta;
		if (status == 0) {
			sta = false;
		} else {
			sta = true;
		}

		albumArticleDaoImpl.modifyTopOne(id, sta);
		article.getAlbum().setLastModifyTime(System.currentTimeMillis());
		albumDaoImpl.modify(article.getAlbum());

		// 更新专辑首页
		AlbumUtil.htmlCreate(article.getAlbum(), messageSource, contextPath, true);

		return 0;

	}

	@ResponseBody
	@RequestMapping(value = "/addtime/{id}")
	@Token(ajax = true, csrf = true, contrast = true, log = true, mark = "album-article--<addtime-change>", loginOrAdmin = true)
	public int modifyAddTime(@PathVariable(value = "id", required = true) Long id, String addtimeStr,
			HttpServletRequest request, HttpSession session) {
		long uid = LoginUtil.uid(messageSource, request);
		User arbitrator = userDaoImpl.findByID(uid);
		if (addtimeStr == null || addtimeStr.trim().equals("") || !TimeUtil.isValidDatetime(addtimeStr)) {
			return -400;
		}

		AlbumArticle article = albumArticleDaoImpl.findByID(id);

		if (article == null) {
			return -404;
		}
		Album album = albumDaoImpl.findByID(article.getAlbum().getId());
		if (album == null || album.isDeled() || !album.isStatus()) {
			return -400;
		}
		if (!article.getAlbum().getGenre().isFreeArtAddTime()) {
			if (!AlbgenreUtil.adminChk(arbitrator, article.getAlbum().getGenre(), albgenreMangerDaoImpl)) {
				return -200;
			}
		} else {
			if (!PartnerUtil.basicPowerChk(uid, article.getAlbum(), albumPartnerDaoImpl)) {
				return -200;
			}
		}

		article.setCreationTime(TimeUtil.coverStrToLong(addtimeStr));
		albumArticleDaoImpl.modify(article, false, arbitrator);

		AlbumArticleUtil.htmlCreate(article, messageSource, request, htmlFileStaticDaoImpl, contextPath);
		article = AlbumArticleUtil.srtUpdate(article);
		article.getSrt().setHref(AlbumArticleUtil.url(article, messageSource, request));
		albumArticleDaoImpl.modify(article, false, arbitrator);
		// 更新专辑首页
		AlbumUtil.htmlCreate(article.getAlbum(), messageSource, contextPath, true);
		return 0;
	}

	@ResponseBody
	@RequestMapping(value = "/pass/{id}/{status}")
	@Token(ajax = true, csrf = true, contrast = true, log = true, mark = "album-article--<pass>", loginOrAdmin = true)
	public int modifyPass(@PathVariable(value = "id", required = true) Long id,
			@PathVariable(value = "status", required = true) Integer status, HttpServletRequest request,
			HttpSession session) {
		boolean admin = LoginUtil.adminChk(messageSource, session);
		boolean con = false;
		if (admin) {
			con = true;
		}

		AlbumArticle art = albumArticleDaoImpl.findByID(id);
		Album album = albumDaoImpl.findByID(art.getAlbum().getId());
		if (album == null || album.isDeled() || !album.isStatus()) {
			return -400;
		}

		long uid = LoginUtil.uid(messageSource, request);

		User user = userDaoImpl.findByID(uid);

		if (AlbgenreUtil.adminChk(user, art.getAlbum().getGenre(), albgenreMangerDaoImpl) || AlbumUtil.checker(album, user, albumPartnerDaoImpl)) {
			con = true;
		}

		if (con) {
			if (status == 1) {
				art.setStatus(true);
				art.getContent().setPasser(user);
			} else {
				art.setStatus(false);
				art.getContent().setPasser(null);
			}
			art.getAlbum().setLastModifyTime(System.currentTimeMillis());
			albumDaoImpl.modify(art.getAlbum());
			albumArticleDaoImpl.modify(art, false, user);

			if (art.isStatus()) {
				AlbumArticleUtil.htmlCreate(art, messageSource, request, htmlFileStaticDaoImpl, contextPath);

			} else {
				htmlDel(art, htmlFileStaticDaoImpl);
			}
			// 更新目录的状态

			art = AlbumArticleUtil.srtUpdate(art);
			art.getSrt().setHref(AlbumArticleUtil.url(art, messageSource, request));
			albumArticleDaoImpl.modify(art, false, user);

			// 更新专辑首页
			AlbumUtil.htmlCreate(art.getAlbum(), messageSource, contextPath, true);
			
			if (art.isStatus()) {
				// 通知粉丝
				List<AlbumFans> fanslist = albumFansDaoImpl.findByAid(album.getId());
				String msgContent = FileUtil.readRes(messageSource, "msg_new_album_article");
				List<Msg> listMsg = new ArrayList<Msg>();
				String url = AlbumArticleUtil.url(art, messageSource, request);
				if (url!=null && !url.trim().equals("")) {
					Msg msgdb = msgDaoImpl.findByUrl(url);
					if (msgdb==null) {	//如果没有发送过
						for (AlbumFans fans : fanslist) {
							String msgTmp = msgContent;
							Msg msg = new Msg();
							msg.setSender(user);
							msg.setRecipient(fans.getUser());
							msg.setSendtime(System.currentTimeMillis());
							msg.setMtype(1);
							msg.setUrl(url);
							msg.setStatus(true);
							msgTmp = AlbumArticleUtil.fmt(msgTmp, art, url);
							msg.setContent(msgTmp);
							msg.setCtext(StringUtil.htmlFilter(msgTmp, true));
							msg.setMainUuid(art.getUuid());
							listMsg.add(msg);

						}

						if (!listMsg.isEmpty()) {
							msgDaoImpl.excuteBatchSave(listMsg);
						}
					}
				}
				
				SitemapUtil.write(messageSource, request, art);
				
				//通知本人
				User adder= art.getContent().getEditor();
				if (adder==null) {
					adder= art.getOwner();
				}
				
				if (adder!=null) {
					msgContent = FileUtil.readRes(messageSource, "msg_passed_new_art");
					

					String msgTmp = msgContent;
					
					Msg msg = new Msg();
					msg.setSender(user);
					msg.setRecipient(adder);
					msg.setSendtime(System.currentTimeMillis());
					msg.setMtype(1);
					msg.setUrl(url);
					msg.setStatus(true);
					
					String alburl=AlbumUtil.getHref(messageSource, request, album, true);
					
					msgTmp=AnalyzeUtil.replace(msgTmp, "tag", "url", url);
					msgTmp=AnalyzeUtil.replace(msgTmp, "tag", "alburl", alburl);
					msgTmp = AlbumArticleUtil.fmt(msgTmp, art, url);
					msgTmp = UserUtil.fmt(msgTmp, user, null);
					
					msg.setContent(msgTmp);
					msg.setCtext(StringUtil.htmlFilter(msgTmp, true));
					listMsg.add(msg);
					msgDaoImpl.add(msg);
					
					if (UserUtil.mailUsable(adder)!=null ) {
						String mailContent = FileUtil.readRes(messageSource, "mail_passed_new_art");
						String mailTmp = mailContent;
						mailTmp=AnalyzeUtil.replace(mailTmp, "tag", "url", url);
						mailTmp=AnalyzeUtil.replace(mailTmp, "tag", "alburl", alburl);
						mailTmp = AlbumArticleUtil.fmt(mailTmp, art, url);
						mailTmp = UserUtil.fmt(mailTmp, user, null);
						MailTeamUnit unit = new MailTeamUnit();
						unit.setCreateDT(System.currentTimeMillis());
						unit.setContent(mailTmp);
						unit.setDeled(false);
						unit.setFailures(0);
						unit.setRecipient(adder.getEmail());
						unit.setSender(user.getUsername());
						unit.setStatus(false);
						unit.setSubject(messageSource.getMessage("title.mail.art.passed", null, "New article must to be passed.", null));
						unit.setTxt(mailTmp);
						unit.setCreater(user);
						
						mailTeamUnitDaoImpl.add(unit);
					}
					
				}
				
			}

			return 0;
		}

		return -200;

	}

	@RequestMapping(value = { "/history/{aid}/{tid}/{page}/{pagesize}", "/history/{aid}/{tid}" })
	@Token(ajax = false, login = true, csrf = true, contrast = true, failedPage = FORBIDU)
	public String history(@PathVariable(value = "aid", required = false) Long aid,
			@PathVariable(value = "tid", required = false) Long tid,
			@PathVariable(value = "page", required = false) Integer page,
			@PathVariable(value = "pagesize", required = false) Integer pagesize, HttpServletRequest request,
			Map<String, Object> map) {
		if (aid == null) {
			aid = 0L;
		}
		if (tid == null) {
			tid = 0L;
		}

		Album album = albumDaoImpl.findByID(aid);
		if (album == null || album.isDeled() || !album.isStatus()) {
			return FORBIDU;
		}
		long uid = LoginUtil.uid(messageSource, request);
		if (PartnerUtil.basicPowerChk(uid, album, albumPartnerDaoImpl)) {
			if (page == null) {
				page = 1;
			}
			if (pagesize == null) {
				pagesize = 10;
			}
			Rs rs;
			if (tid > 0) {
				rs = albumArticleHistoryDaoImpl.queryByArtID(tid, page, pagesize);
			} else {
				rs = albumArticleHistoryDaoImpl.queryByAlbumID(aid, page, pagesize);
			}

			for (int i = 0; i < rs.getList().size(); i++) {
				AlbumArticleHistory history = (AlbumArticleHistory) rs.getList().get(i);
				AlbumArticle art = albumArticleDaoImpl.findByID(history.getArt().getId());
				history.setArt(art);
			}
			map.put("rs", rs);
			map.put("aid", aid);
			map.put("pageUrl", "action_album_article/history/" + aid + "/" + tid);
			return "jsp/album/article/history";
		} else {
			return FORBIDU;
		}

	}

	// 历史比较
	@RequestMapping(value = "/compare/{cid}")
	@Token(ajax = false, login = true, csrf = true, contrast = true, failedPage = FORBIDU)
	public String compare(@PathVariable(value = "cid", required = true) Long cid, Map<String, Object> map) {
		AlbumArticleContent content = albumArticleDaoImpl.findContentByCID(cid);
		AlbumArticle art = content.getArt();
		Album album = art.getAlbum();
		if (album == null || album.isDeled() || !album.isStatus()) {
			return FORBIDU;
		}
		art = albumArticleDaoImpl.findByID(art.getId()); // 按id从数据库中查询，将content恢复为最新
		List<String> compareResult = AlbumArticleUtil.compare(art.getContent(), content);
		map.put("result", compareResult);
		map.put("curr", art.getContent());
		map.put("tag", content);
		return "jsp/album/article/compare";
	}

	@ResponseBody
	@RequestMapping(value = "/neighbour/{id}/{gid}/{mod}")
	@Token(ajax = true, csrf = true, contrast = true)
	public SimpleArticle neighbour(@PathVariable(value = "id", required = true) Long id,
			@PathVariable(value = "gid", required = true) Long gid,
			@PathVariable(value = "mod", required = true) Integer mod) {
		AlbumArticle art = albumArticleDaoImpl.findByID(id);
		Album album = null;
		if (gid > 0L) {
			album = albumDaoImpl.findByID(gid);
		} else {
			gid = 0L;
		}
		if (album == null) {
			gid = 0L;
		}
		art = albumArticleDaoImpl.findNeighbour(id, mod, gid);
		if (art == null) {
			return null;
		} else {
			SimpleArticle sart = new SimpleArticle();
			sart.setAuthor(art.getContent().getAuthor());
			sart.setHref(art.getHfs().getUrl());
			sart.setId(art.getId());
			sart.setSubject(StringUtil.htmlRiskFilter(art.getContent().getSubject()));
			sart.setSubjectShort(StringUtil.htmlRiskFilter(art.getContent().getSubjectShort()));
			if (art.getContent().getSubjectShort() != null && !art.getContent().getSubjectShort().trim().equals("")) {
				sart.setSubjectShort(art.getContent().getSubjectShort());
			} else {
				sart.setSubjectShort(sart.getSubject());
			}
			sart.setSynopsis(art.getContent().getSynopsis());
			sart.setThumbnail(art.getContent().getThumbnail());
			sart.setUid(art.getContent().getEditor().getId());
			sart.setUsername(art.getContent().getEditor().getUsername());
			return sart;
		}
	}

	// 接收文章
	@CrossOrigin(origins = "*", maxAge = 3600)
	@ResponseBody
	@RequestMapping(value = "/recive", method = RequestMethod.POST)
	@Token(ajax = true, contrast = true)
	public int recive(@RequestParam(value = "file", required = false) MultipartFile file, HttpServletRequest request,
			HttpServletResponse response, HttpSession session) throws Exception {
		String path = FileUtil.appPath();
		String receiveFolder = path + File.separator + "recives" + File.separator;
		receiveFolder = FileUtil.repairFilePath(receiveFolder);
		File filePath = new File(receiveFolder);
		if (!filePath.exists()) {
			filePath.mkdirs();
			FileUtil.erable(filePath);
		}

		String pathfilename = "recives" + File.separator + file.getOriginalFilename();

//		FileInf fi = 
		FileUtil.upload(file, pathfilename);
		String fullFileName = receiveFolder + File.separator + file.getOriginalFilename();
		fullFileName = FileUtil.repairFilePath(fullFileName);

		File f = new File(fullFileName);

		SimpleReciveAlbumArticle article = (SimpleReciveAlbumArticle) ObjUtil.objectXmlDecoder(f.toString()).get(0);
		String webinf = FileUtil.webinfPath() + File.separator;

		if (article == null || article.getAlbum() == null || article.getAlbum().getUser() == null) {
			ReciveUtil.logw(webinf, "recive.log", "-416   获得文章   文件：" + pathfilename);
			return -416;
		}
		SimpleReciveAlbum salbum = article.getAlbum();
		SimpleReciveAlbgenre salbgenre = salbum.getAlbgenre();
		SimpleReciveUser suser = salbum.getUser();
		if (article.getUuid() == null || article.getUuid().trim().equals("")) {
			ReciveUtil.logw(webinf, "recive.log", "-4161  获得文章   标题：" + article.getSubject());
			return -4161;
		}
		if (salbum.getUuid() == null || salbum.getUuid().trim().equals("")) {
			ReciveUtil.logw(webinf, "recive.log", "-4162  获得文章   标题：" + article.getSubject());
			return -4162;
		}
		if (salbgenre.getUuid() == null || salbgenre.getUuid().trim().equals("")) {
			ReciveUtil.logw(webinf, "recive.log", "-4163  获得文章   标题：" + article.getSubject());
			return -4163;
		}
		if (suser.getUuid() == null || suser.getUuid().trim().equals("")) {
			ReciveUtil.logw(webinf, "recive.log", "-4164  获得文章   标题：" + article.getSubject());
			return -4164;
		}
		String securityStr = SecurityUtil.readWords("recivekey");
		if (securityStr == null || securityStr.trim().equals("")) {
			ReciveUtil.logw(webinf, "recive.log", "-403  获得文章   标题：" + article.getSubject());
			return -403;
		}

		if (article.getExtrakey() == null || !article.getExtrakey().trim().equals(securityStr)) {
			ReciveUtil.logw(webinf, "recive.log", "-401  获得文章   标题：" + article.getSubject());
			return -401;
		}

		Albgenre albgenre = albgenreDaoImpl.findByUuid(salbgenre.getUuid());

		if (albgenre == null) {
			albgenre = new Albgenre();
			albgenre.setName(salbgenre.getName());
			albgenre.setUuid(salbgenre.getUuid());
			albgenre.setStatus(true);
			albgenre.setFree(true);
			albgenre.setOpen(true);
			albgenre.setRelease(true);
			albgenre.setPoll(true);
			albgenre.setComm(true);
			albgenreDaoImpl.add(albgenre);
		}

		UploadArgs ua = new UploadArgs();
		ua.setCh(0);
		ua.setCw(0);

		ua.setIntact(true);
		ua.setMessageSource(messageSource);
		ua.setRequest(request);
		ua.setSession(session);
		ua.setTargetFile(null);
		ua.setTitle(null);
		ua.setUploadedFileDaoImpl(uploadedFileDaoImpl);
		ua.setUserDaoImpl(userDaoImpl);
		ReciveUserModular rum = UserUtil.reviceUser(suser, userDaoImpl, roleDaoImpl, ua, request, response);
		User user = rum.getUser();
		ua = rum.getUa();
		ua.setUid(user.getId());
		Album album = albumDaoImpl.findByUuid(salbum.getUuid());
		if (album == null) {
			album = new Album();
			album.setBanner(salbum.getBanner());
			album.setBannerSmall(salbum.getBannerSmall());
			album.setCreateTime(salbum.getCreateTime());
			album.setDescription(salbum.getDescription());
			if (salbum.getName() == null || salbum.getName().trim().equals("")) {
				album.setName(albgenre.getName() + " by " + user.getUsername());
			} else {
				album.setName(salbum.getName());
			}

			album.setLogoSmall(salbum.getLogoSmall());
			album.setTxt1(salbum.getTxt1());
			album.setTxt2(salbum.getTxt2());
			album.setUuid(salbum.getUuid());
			album.setLeader(user);
			album.setGenre(albgenre);
			album.setOpen(salbum.isOpen());
			album.setStatus(salbum.isStatus());
			album.setComm(true);
			album.setMesback(true);

			Poll poll = new Poll();
			poll.setStatus(true);
			album.setPoll(poll);

			VisitorsBook vbook = new VisitorsBook();
			vbook.setObjType(3);
			vbook.setObjTitle(album.getName());
			album.setVbook(vbook);

			CommentBridge cb = new CommentBridge();
			cb.setUser(user);
			cb.setStatus(true);
			cb.setObjTitle(album.getName());
			cb.setObjType(3);
			album.setCb(cb);

			albumDaoImpl.add(album);
		}

		AlbumArticle albumArticle = albumArticleDaoImpl.findByUuid(article.getUuid());

		if (albumArticle == null) {
			albumArticle = new AlbumArticle();
			albumArticle.setUuid(article.getUuid());
			albumArticle.setAlbum(album);
			albumArticle.setOwner(user);
			albumArticle.setCreationTime(article.getCreationTime());
			albumArticle.setCreationTimeOldest(article.getCreationTime());
			albumArticle.setSoul(article.isSoul());
			albumArticle.setStatus(article.isStatus());
			AlbumArticleContent content = new AlbumArticleContent();

			content.setEditor(user);
			content.setAuthor(article.getAuthor());
			content.setAuthorDept(article.getAuthorDept());

			content.setEmail(article.getEmail());
			content.setExtra(article.getExtra());
			content.setEditTime(article.getCreationTime());
			content.setHomepage(article.getHomepage());
			content.setJumpUrl(article.getJumpUrl());
			content.setMediaUrl(article.getMediaUrl());
			content.setSecondTitle(article.getSecondTitle());
			if (article.getSubject() == null || article.getSubject().trim().equals("")) {
				content.setSubject("article at " + TimeUtil.coverLongToStr(article.getCreationTime(), "yyyyMMdd"));
			} else {
				content.setSubject(article.getSubject());
			}

			content.setSubjectShort(article.getSubjectShort());
			content.setSynopsis(article.getSynopsis());

			content.setTitleImgTxt(article.getTitleImgTxt());
			content.setToppic(article.getToppic());

			/*
			 * 图片处理
			 */
			if (article.getThumbnail() != null && !article.getThumbnail().trim().equals("")) {
				UploadedFile uf = UploadUtil.downUrlFile(ua, article.getThumbnail(), request, response);
				if (uf != null) {
					content.setThumbnail(uf.getUrl());
				}

			}

			if (article.getTitleImg() != null && !article.getTitleImg().trim().equals("")) {
				UploadedFile uf = UploadUtil.downUrlFile(ua, article.getTitleImg(), request, response);
				if (uf != null) {
					content.setTitleImg(uf.getUrl());
				}

			}
			content.setContent(ReciveUtil.contentImgDown(ua, article.getContent(), request, response));

			albumArticle.setContent(content);
			content.setArt(albumArticle);

			CommentBridge cb = new CommentBridge();
			cb.setUser(user);
			cb.setStatus(true);
			cb.setObjType(4);
			cb.setObjTitle(content.getSubject());
			Poll poll = new Poll();
			poll.setStatus(true);
			poll.setObjTitle(content.getSubject());
			poll.setAgrees(article.getPollAgree());
			poll.setParent(album.getPoll());

			albumArticle.setCb(cb);
			albumArticle.setPoll(poll);

			VisitorsBook vbook = new VisitorsBook();
			vbook.setObjType(4);
			vbook.setObjTitle(albumArticle.getContent().getSubject());
			vbook.setIpTotal(article.getViews());
			albumArticle.setVbook(vbook);

			HtmlFileStatic hfs = new HtmlFileStatic();
			albumArticle.setHfs(hfs);

			albumArticleDaoImpl.add(albumArticle);

			album.getPoll().setAgrees(album.getPoll().getAgrees() + poll.getAgrees());
			album.getPoll().setTotal(album.getPoll().getTotal() + poll.getAgrees());
			pollDaoImpl.modify(album.getPoll());

			albumArticle = albumArticleDaoImpl.findByID(albumArticle.getId());

			hfs = albumArticle.getHfs();
			FileEl fe = AlbumArticleUtil.feBuild(messageSource, request, albumArticle, false);
			hfs.setRealPath(fe.getRealPath());
			hfs.setUrl(fe.getUrl());
			hfs.setFilename(FileUtil.getFileFromPath(fe.getRealPath()));
			albumArticle.setHfs(hfs);
			albumArticle.getCb().setHosturl(AlbumArticleUtil.url(albumArticle, messageSource, request));
			albumArticleDaoImpl.modify(albumArticle, false, null);

			album = albumArticle.getAlbum();
			album.setTotalArt(albumArticleDaoImpl.countByAlbumID(album.getId()));
			album.setTotalProhibit(albumArticleDaoImpl.countProhibitByAlbumID(album.getId()));
			album.setLastEditTime(System.currentTimeMillis());
			album.setLastModifyTime(System.currentTimeMillis());
			if (albumArticle.isSoul()) {
				album.setTotalArtSoul(album.getTotalArtSoul() + 1);
			}
			albumDaoImpl.modify(album);

			AlbumArticleUtil.htmlCreate(albumArticle, messageSource, request, htmlFileStaticDaoImpl, contextPath);

			albumArticle = AlbumArticleUtil.srtUpdate(albumArticle);
			albumArticle.getSrt().setHref(AlbumArticleUtil.url(albumArticle, messageSource, request));
			albumArticleDaoImpl.modify(albumArticle, false, null);

			// 更新专辑首页
			AlbumUtil.htmlCreate(album, messageSource, contextPath, false);

			ReciveUtil.logw(webinf, "recive.log", "0000  获得文章   标题：" + article.getSubject());
			f.delete();
			return 0;
		} else {
			ReciveUtil.logw(webinf, "recive.log", "-502  获得文章   标题：" + article.getSubject());
			return -502;
		}

	}

	@RequestMapping("/search/{gid}/{aid}")
	@Token(contrast = true)
	public String search(@PathVariable(value = "gid", required = false) Long gid,
			@PathVariable(value = "aid", required = false) Long aid, String keywords,
			@RequestParam(value = "page", required = false) Integer page,
			@RequestParam(value = "pageSize", required = false) Integer pageSize,
			@RequestParam(value = "loc", required = false) Integer loc, HttpServletRequest request,
			Map<String, Object> map) {
		if (gid == null) {
			gid = 0L;
		}
		if (aid == null) {
			aid = 0L;
		}
		if (HttpUtil.referer(request) == null) {
			return "Error! Code :-408";
		}
		Portal portal = portalDaoImpl.query_update();

		if (keywords != null) {
			keywords = StringUtil.htmlFilter(keywords, true);
		}
		if (keywords == null || keywords.trim().equals("")) {
			map.put("keywords", null);
			return "jsp/album/article/search";
		}
		if (page == null) {
			page = 1;
		}
		if (pageSize == null) {
			pageSize = 10;
		}
		if (loc == null) {
			loc = 0;
		}
		keywords = StringUtil.htmlBlankTrim(keywords, true);
		Rs rs = albumArticleDaoImpl.search(gid, aid, keywords, true, 0, page, pageSize);
		map.put("keywords", keywords);
		map.put("rs", rs);
		map.put("gid", gid);
		map.put("albid", aid);
		String station = null;
		String homeurl = null;
		if (aid > 0) {
			Album album = albumDaoImpl.findByID(aid);
			if (album != null) {
				station = album.getName();
				homeurl = AlbumUtil.getHref(messageSource, request, album, false);
			}
		}
		if (station == null && gid > 0) {
			Albgenre albgenre = albgenreDaoImpl.findByID(gid);
			if (albgenre != null) {
				station = albgenre.getName();
				homeurl = AlbgenreUtil.getHref(messageSource, request, albgenre, false);
			}
		}
		if (station != null) {
			map.put("station", station);
			map.put("homeurl", homeurl);
		} else {
			map.put("station", portal.getName());
			map.put("homeurl", request.getContextPath());
		}

		map.put("pageUrl", "/action_album_article/search/" + gid + "/" + aid + "?loc=" + loc + "&keywords=" + keywords);
		if (loc == 1) {
			return "jsp/album/article/search2";
		} else {
			return "jsp/album/article/search";
		}

	}

	// 查询关注的专辑的新文章。该方法已废弃
	/*
	 * @ResponseBody
	 * 
	 * @RequestMapping("/findNewArt")
	 * 
	 * @Token(ajax = true, login = true) public int
	 * findNewAtFansUid(HttpServletRequest request) { long uid =
	 * LoginUtil.uid(messageSource, request); List<Long> list =
	 * albumArticleDaoImpl.queryNewByFansUid(uid); if (list == null) { return 0; }
	 * 
	 * for (Long aid:list) { AlbumArticle art=albumArticleDaoImpl.findByID(aid); }
	 * 
	 * return list.size(); }
	 */

	// 转移某专辑中的所有文章
	@ResponseBody
	@RequestMapping("/move/{fid}/{tid}")
	@Token(ajax = true, admin = true, csrf = true, contrast = true, log = true, mark = "album-article--<move>")
	public int moveAllByAid(@PathVariable(value = "fid", required = true) Long fid,
			@PathVariable(value = "tid", required = true) Long tid) {
		albumArticleDaoImpl.moveAllByAid(fid, tid);
		return 0;
	}

	// 提取文章到门户或个人专辑
	@RequestMapping("/took/{tid}")
	@Token(ajax = true, login = true, csrf = true, contrast = true)
	public String took(@PathVariable(value = "tid", required = true) Long tid, HttpServletRequest request,
			Map<String, Object> map) {
		long uid = LoginUtil.uid(messageSource, request);
		User user = userDaoImpl.findByID(uid);
		Role role = roleDaoImpl.findByID(user.getRole().getId());
		String mask = role.getMask();
		List<Long> pglist = GroupUtil.pchk(mask, groupDaoImpl);
		boolean admin = false;
		if (pglist != null && pglist.size() > 0) {
			if (pglist.size() == 1 && pglist.get(0) == 0) {
				map.put("admin", true);
				admin = true;
			} else {
				map.put("pglist", pglist);
			}
		} else {
			map.put("pglist", null);
		}

		String rootTitle = messageSource.getMessage("root.select.title", null, "Select channel", null);
		ArticleGroupMapCreateArgs agmca = new ArticleGroupMapCreateArgs();
		agmca.setCurrRoleMask(mask);
		agmca.setCurrRoot(null);
		agmca.setFree(admin);
		agmca.setGroupDaoImpl(groupDaoImpl);
		agmca.setMap(map);
		agmca.setRootTitle(rootTitle);
		agmca.setStatus(1);
		agmca.setMessageSource(messageSource);
		agmca.setRequest(request);

		List<ArticleGroup> gmap = GroupUtil.readFromCache(agmca, rootTitle);
		List<ArticleGroup> aonroot = new ArrayList<ArticleGroup>();
		for (ArticleGroup g : gmap) {
			mask = "," + mask + ",";
			if (!admin && mask.indexOf(",p" + g.getId() + ",") == -1) {
				g.setClogging(false);
			}
			aonroot.add(g);
		}

		map.put("preListAll", aonroot);

		AlbumArticle albart = albumArticleDaoImpl.findByID(tid);
		Article article = new Article();
		article.setSubject(StringUtil.ampClear(albart.getContent().getSubject()));
		article.setSubjectShort(StringUtil.ampClear(albart.getContent().getSubjectShort()));
		article.setJumpUrl(AlbumArticleUtil.url(albart, messageSource, request));
		String synopsis = albart.getContent().getSynopsis();
		if (synopsis == null || synopsis.trim().equals("")) {
			synopsis = albart.getContent().getContent();

		}
		synopsis = StringUtil.htmlFilter(synopsis, true);
		synopsis = StringUtil.htmlBlankTrim(synopsis, false);
		synopsis = synopsis.trim();
		if (synopsis.length() > 240) {
			synopsis = synopsis.substring(0, 240) + "…";
		}
		article.setSynopsis(synopsis);
		map.put("article", article);
		map.put("currTime", System.currentTimeMillis());
		return "jsp/album/article/took";
	}

	// 修复新旧版本交替过程中，旧版本数据中有的cb中无url的情况 v6.6以后版本无需执行
	@RequestMapping("/repairHostUrl")
	@Token(admin0 = true, csrf = true, contrast = true)
	public String repairHostUrl() {
		List<Long> list = albumArticleDaoImpl.queryCbHostUrlNull();
		System.out.println("找到 " + list.size() + " 条记录");
		for (long aid : list) {
			AlbumArticle art = albumArticleDaoImpl.findByID(aid);
			CommentBridge cb = art.getCb();
			cb = commentBridgeDaoImpl.findByID(cb.getId());
			if (cb.getHosturl() == null || cb.getHosturl().trim().equals("")) {
				cb.setHosturl(art.getHfs().getUrl());
				commentBridgeDaoImpl.modify(cb);
			}
		}
		return "jsp/result/success";
	}

}
