package com.lerx.handlers;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

import com.lerx.annotation.Token;
import com.lerx.dao.iface.IAlbumDao;
import com.lerx.dao.iface.IAlbumExternalLinkDao;
import com.lerx.dao.iface.IAlbumPartnerDao;
import com.lerx.entities.Album;
import com.lerx.entities.AlbumExternalLink;
import com.lerx.login.util.LoginUtil;
import com.lerx.v6.util.PartnerUtil;

@RequestMapping("/action_album_link")
@Controller
public class AlbumExternalLinkHandler {
	
	
	@Autowired
	private IAlbumDao albumDaoImpl;
	
	@Autowired
	private IAlbumExternalLinkDao albumExternalLinkDaoImpl;
	
	@Autowired
	private IAlbumPartnerDao albumPartnerDaoImpl;
	
	private static final String FORBIDU = "jsp/result/forbidu";
	private static final String ADDSUCCESS = "jsp/result/success";
	private static final String ADD = "jsp/album/link/add";
	private static final String LOGINPAGE = "jsp/user/login";
	
	@Autowired
	private ResourceBundleMessageSource messageSource;
	
	
	@RequestMapping(value = {"/beforeAdd/{aid}/{lid}","/beforeAdd/{aid}"})
	@Token(ajax = false, login = true, csrf = true, contrast = true, failedPage = LOGINPAGE, msgKey = "fail.permission")
	public String beforeAdd(@PathVariable(value = "aid", required = false) Long aid,@PathVariable(value = "lid", required = false) Long lid, Map<String, Object> map,
			HttpServletRequest request, HttpSession session) {
		if (aid==null) {
			aid=0L;
		}
		if (lid==null) {
			lid=0L;
		}
		Album album = albumDaoImpl.findByID(aid);
		if (album == null  || album.isDeled() || !album.isStatus()) {
			return FORBIDU;
		}
		long uid = LoginUtil.uid(messageSource, request);
		if (!PartnerUtil.basicPowerChk(uid, album, albumPartnerDaoImpl)) {
			return FORBIDU;
		}
		AlbumExternalLink link;
		if (lid==0) {
			link = new AlbumExternalLink();
			link.setAlbum(album);
			link.setDeled(false);
		}else {
			link=albumExternalLinkDaoImpl.findByID(lid);
		}
		
		map.put("aid", aid);
		map.put("link", link);
		map.put("currTime", System.currentTimeMillis());

//		map.put("album", album);
		return ADD;
	}
	
	@RequestMapping(value = {"/listByAid/{aid}"})
	@Token(ajax = false, login = true, csrf = true, contrast = true, failedPage = FORBIDU)
	public String listByAid(@PathVariable(value = "aid", required = true) Long aid,HttpServletRequest request, HttpSession session,Map<String, Object> map) {
		Album album = albumDaoImpl.findByID(aid);
		long uid = LoginUtil.uid(messageSource, request);
		
		if (album == null  || album.isDeled() || !album.isStatus() || !PartnerUtil.basicPowerChk(uid, album, albumPartnerDaoImpl) ) {
			return FORBIDU;
		}
		
		List<AlbumExternalLink> list=albumExternalLinkDaoImpl.findByAid(aid,1);
		map.put("list", list);
		map.put("aid", aid);
		return "jsp/album/link/list";
		
	}
	
	
	@RequestMapping("/add")
	@Token(ajax = false, login = true, csrf = true, contrast = true,log = true,mark = "album-ext-link--<add>", failedPage = FORBIDU)
	public String add(@Valid AlbumExternalLink link, Map<String, Object> map,
			HttpServletRequest request, HttpSession session) {
		long uid = LoginUtil.uid(messageSource, request);
		Album album = albumDaoImpl.findByID(link.getAlbum().getId());
		if (album == null  || album.isDeled() || !album.isStatus()) {
			return FORBIDU;
		}
		if (!PartnerUtil.basicPowerChk(uid, album, albumPartnerDaoImpl)) {
			return FORBIDU;
		}
		if (link.getId() == 0) {
			albumExternalLinkDaoImpl.add(link);
		}else {
			albumExternalLinkDaoImpl.modify(link);
		}
		
		return ADDSUCCESS;
		
	}

}
