package com.lerx.handlers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.lerx.annotation.Token;
import com.lerx.dao.iface.IAlbumArtsCountDao;
import com.lerx.dao.iface.IAlbumDao;
import com.lerx.dao.iface.IAlbumFansDao;
import com.lerx.dao.iface.IAlbumPartnerDao;
import com.lerx.dao.iface.IMailTeamUnitDao;
import com.lerx.dao.iface.IMsgDao;
import com.lerx.dao.iface.IUserDao;
import com.lerx.entities.Album;
import com.lerx.entities.AlbumArtsCount;
import com.lerx.entities.AlbumFans;
import com.lerx.entities.AlbumPartner;
import com.lerx.entities.MailTeamUnit;
import com.lerx.entities.Msg;
import com.lerx.entities.User;
import com.lerx.hql.entities.Rs;
import com.lerx.login.util.LoginUtil;
import com.lerx.portal.obj.SimpleFans;
import com.lerx.sys.util.FileUtil;
import com.lerx.sys.util.StringUtil;
import com.lerx.sys.util.TimeUtil;
import com.lerx.v6.util.AlbumFansUtil;
import com.lerx.v6.util.AlbumUtil;
import com.lerx.v6.util.PartnerUtil;

@RequestMapping("/action_fans")
@Controller
public class AlbumFansHandler {

	@Autowired
	private ResourceBundleMessageSource messageSource;

	@Autowired
	private IUserDao userDaoImpl;

	@Autowired
	private IAlbumDao albumDaoImpl;

	@Autowired
	private IAlbumFansDao albumFansDaoImpl;

	@Autowired
	private IAlbumPartnerDao albumPartnerDaoImpl;
	
	@Autowired
	private IAlbumArtsCountDao albumArtsCountDaoImpl;
	
	@Autowired
	private IMsgDao msgDaoImpl;
	
	@Autowired
	private IMailTeamUnitDao mailTeamUnitDaoImpl;
	
	private static final String LOGINPAGE = "jsp/user/login";
	private static final String FORBIDU = "jsp/result/forbidu";

	@ResponseBody
	@RequestMapping(value = "/followon/{aid}")
	@Token(ajax = true,csrf=true,contrast = true, log = true, mark = "album-fans--<add>", login = true)
	public int followon(@PathVariable(value = "aid", required = true) Long aid, HttpServletRequest request) {
		long uid = LoginUtil.uid(messageSource, request);
		User user = userDaoImpl.findByID(uid);
		if (user == null) {
			return -201;
		}
		Album album = albumDaoImpl.findByID(aid);
		if (album == null) {
			return -404;
		}
		if (album.isDeled() || !album.isStatus()) {
			return 400;
		}
		if (albumFansDaoImpl.findByUidAndAid(uid, aid) == null) {
			AlbumFans fans = new AlbumFans();
			fans.setCreateTime(System.currentTimeMillis());
			fans.setUser(user);
			fans.setTagAlb(album);
			fans.setLastVisitTime(System.currentTimeMillis());
			albumFansDaoImpl.add(fans);
			
			//增加通知
			String msgContent = FileUtil.readRes(messageSource, "msg_new_album_fans");
			String mailContent = FileUtil.readRes(messageSource, "mail_new_album_fans");
			
			List<AlbumPartner> listAP=albumPartnerDaoImpl.queryByAid(album.getId());
			Set<User> suser=new HashSet<User>();
			suser.add(album.getLeader());
			for (AlbumPartner partner:listAP) {
				suser.add(partner.getUser());
			}
			List<Msg> listMsg = new ArrayList<Msg>();
			if (!suser.isEmpty()) {
				msgContent=AlbumFansUtil.fmt(msgContent,fans);
				mailContent=AlbumFansUtil.fmt(mailContent,fans);
				String recipients="";
				for (User u:suser) {
					recipients += u.getEmail() + ";";
					Msg msg=new Msg();
					msg.setSender(user);
					msg.setRecipient(u);
					msg.setSendtime(System.currentTimeMillis());
					msg.setMtype(2);
					msg.setUrl(AlbumUtil.getHref(messageSource, request, album, true));
					msg.setStatus(true);
					
					msg.setContent(msgContent);
					msg.setCtext(StringUtil.htmlFilter(msgContent, true));
					listMsg.add(msg);
				}
				
				MailTeamUnit unit = new MailTeamUnit();
				unit.setCreateDT(System.currentTimeMillis());
				unit.setContent(mailContent);
				unit.setDeled(false);
				unit.setFailures(0);
				unit.setRecipient(recipients);
				unit.setSender(user.getUsername());
				unit.setStatus(false);
				unit.setSubject(messageSource.getMessage("title.fans.new.note", null, "New fan notification.", null));
				unit.setTxt(mailContent);
				unit.setCreater(user);
				
				mailTeamUnitDaoImpl.add(unit);
			}
			
			if (!listMsg.isEmpty()) {
				msgDaoImpl.excuteBatchSave(listMsg);
			}
			
			
			
			return 0;
		} else {
			return -502;
		}

	}

	@ResponseBody
	@RequestMapping(value = "/followout/{aid}")
	@Token(ajax = true,csrf=true,contrast = true, log = true, mark = "album-fans--<del>", login = true)
	public int followout(@PathVariable(value = "aid", required = true) Long aid, HttpServletRequest request) {
		long uid = LoginUtil.uid(messageSource, request);
		User user = userDaoImpl.findByID(uid);
		if (user == null) {
			return -201;
		}
		AlbumFans fans = albumFansDaoImpl.findByUidAndAid(uid, aid);
		if (fans.getUser().getId() == uid) {
			albumFansDaoImpl.delByID(fans.getId());
			return 0;
		} else {
			return -200;
		}

	}

	@ResponseBody
	@RequestMapping(value = "/del/{id}")
	@Token(ajax = true,csrf=true,contrast = true, log = true, mark = "album-fans--<del>", login = true)
	public int del(@PathVariable(value = "id", required = true) Long id, HttpServletRequest request) {
		long uid = LoginUtil.uid(messageSource, request);
		User user = userDaoImpl.findByID(uid);
		if (user == null) {
			return -201;
		}

		AlbumFans fans = albumFansDaoImpl.findByID(id);
		if (fans.getUser().getId() == uid) {
			albumFansDaoImpl.delByID(id);
			return 0;
		} else {
			return -200;
		}

	}
	
	//备注
	@ResponseBody
	@RequestMapping(value = "/note/{id}")
	@Token(ajax = true,csrf=true,contrast = true, log = true, mark = "album-fans--<note>", login = true)
	public int note(@PathVariable(value = "id", required = true) Long id,String note, HttpServletRequest request) {
		long uid = LoginUtil.uid(messageSource, request);
		User user = userDaoImpl.findByID(uid);
		if (user == null) {
			return -201;
		}

		AlbumFans fans = albumFansDaoImpl.findByID(id);
		if (fans.getUser().getId() == uid) {
			if (note!=null) {
				note=note.trim();
			}
			fans.setNote(note);
			albumFansDaoImpl.modify(fans);
			return 0;
		} else {
			return -200;
		}

	}


	@ResponseBody
	@RequestMapping(value = "/query/{aid}")
	@Token(ajax = true, csrf = true, contrast = true, login = true)
	public int query(@PathVariable(value = "aid", required = true) Long aid, HttpServletRequest request) {
		long uid = LoginUtil.uid(messageSource, request);
		User user = userDaoImpl.findByID(uid);
		if (user == null) {
			return -1;
		}
		Album album = albumDaoImpl.findByID(aid);
		if (album == null) {
			return -1;
		}
		if (album.isDeled() || !album.isStatus()) {
			return -400;
		}
		
		if (album.getLeader().getId() == uid) {
			return -1;
		}
		if (albumFansDaoImpl.findByUidAndAid(uid, aid) == null) {
			return 1;

		} else {
			return -502;
		}
	}

	@RequestMapping(value = { "/list/{aid}", "/list/{aid}/{page}/{pagesize}" })
	@Token(ajax = false, csrf = true, contrast = true, login = true, failedPage = FORBIDU)
	public String list(@PathVariable(value = "aid", required = true) Long aid,
			@PathVariable(value = "page", required = false) Integer page,
			@PathVariable(value = "pagesize", required = false) Integer pagesize, HttpServletRequest request,
			Map<String, Object> map) {
		long uid = LoginUtil.uid(messageSource, request);
		User user = userDaoImpl.findByID(uid);
		if (user == null) {
			return "jsp/result/error";
		}
		Album album = albumDaoImpl.findByID(aid);
		if (album == null) {
			return "jsp/result/error";
		}
		if (album.isDeled() || !album.isStatus()) {
			return FORBIDU;
		}
		

		if (!PartnerUtil.basicPowerChk(uid, album, albumPartnerDaoImpl)) {
//			System.out.println("HttpUtil.curUrl(request):"+HttpUtil.curUrl(request));
			return FORBIDU;
		}

		if (page == null) {
			page = 1;
		}
		if (pagesize == null) {
			pagesize = 10;
		}

		Rs rs = albumFansDaoImpl.queryByAid(aid, 0, page, pagesize);
		map.put("pageUrl", "action_fans/list/" + aid);
		map.put("rs", rs);
		map.put("aid", aid);
		return "jsp/album/control/fans";

	}

	@RequestMapping(value = { "/idols/{aid}", "/idols/{aid}/{page}/{pagesize}" })
	@Token(ajax = false, csrf = true, contrast = true, login = true, failedPage = FORBIDU)
	public String idols(@PathVariable(value = "aid", required = true) Long aid,
			@PathVariable(value = "page", required = false) Integer page,
			@PathVariable(value = "pagesize", required = false) Integer pagesize,@RequestParam(value = "timeKey", required = false) String timeKey, HttpServletRequest request,
			Map<String, Object> map) {
		long uid = LoginUtil.uid(messageSource, request);
		User user = userDaoImpl.findByID(uid);
		if (user == null) {
			return "jsp/result/error";
		}
		Album album = albumDaoImpl.findByID(aid);
		if (album == null) {
			return "jsp/result/error";
		}
		
		if (album.isDeled() || !album.isStatus()) {
			return FORBIDU;
		}

		if (!PartnerUtil.basicPowerChk(uid, album, albumPartnerDaoImpl)) {
			return FORBIDU;
		}

		if (page == null) {
			page = 1;
		}
		if (pagesize == null) {
			pagesize = 10;
		}

		Rs rs = albumFansDaoImpl.queryByUid(uid, 0, page, pagesize);
		List<SimpleFans> sflist= new ArrayList<SimpleFans>();
		@SuppressWarnings("unchecked")
		List<AlbumFans> list=(List<AlbumFans>) rs.getList();
		if (timeKey==null) {
			timeKey=TimeUtil.coverLongToStr(System.currentTimeMillis(), "yyyyMM");
		}
		for (AlbumFans fans:list) {
			SimpleFans sf=new SimpleFans();
			sf.setAlbid(fans.getTagAlb().getId());
			sf.setAlbname(fans.getTagAlb().getName());
			sf.setFans(fans.getUser());
			String nickname=fans.getTagAlb().getLeader().getNickname();
			if (nickname==null || nickname.trim().equals("")) {
				nickname=fans.getTagAlb().getLeader().getUsername();
			}
			sf.setAlbLeader(nickname);
			sf.setAlbLeaderUid(fans.getTagAlb().getLeader().getId());
			sf.setId(fans.getId());
			sf.setFg(fans.getFg());
			sf.setNote(fans.getNote());
			sf.setCreateTime(fans.getCreateTime());
			sf.setAlbhref(AlbumUtil.getHref(messageSource, request, fans.getTagAlb(), false));
			AlbumArtsCount aac=albumArtsCountDaoImpl.findByAK(fans.getTagAlb(), Integer.valueOf(timeKey));
			if (aac==null) {
				aac=new AlbumArtsCount();
				aac.setAlbum(album);
				aac.setTotal(0);
				aac.setPassed(0);
				aac.setSoul(0);
			}
			sf.setAac(aac);
			sflist.add(sf);
		}
		rs.setList(sflist);
		map.put("pageUrl", "action_fans/idols/" + aid);
		map.put("timeKey", timeKey);
		map.put("rs", rs);
		map.put("aid", aid);
		return "jsp/album/control/idols";

	}
	
	/*
	 * 同步更新
	 * 当浏览某专辑时，将更新该专辑的最新文章ID至粉丝的最后浏览文章ID 
	 * 【提示】新的消息系统，该方法已弃用！！！！
	 */
	@ResponseBody
	@RequestMapping(value = "/synchronous/{aid}")
	@Token(ajax = true,csrf=true,contrast = true, login = true, failedPage = LOGINPAGE)
	public int synchronous(@PathVariable(value = "aid", required = true) Long aid, HttpServletRequest request) {
		return -1;
		/*
		long uid = LoginUtil.uid(messageSource, request);
		User user = userDaoImpl.findByID(uid);
		if (user == null) {
			return -201;
		}
		Album album=albumDaoImpl.findByID(aid);
		if (album==null) {
			return -404;
		}
		if (album.isDeled() || !album.isStatus()) {
			return -400;
		}
		AlbumFans fans=albumFansDaoImpl.findByUidAndAid(uid, aid);
		if (fans==null) {
			return -302;
		}
		long maxArtID=albumArticleDaoImpl.findMaxArtID(aid);
		fans.setLastViewedID(maxArtID);
		albumFansDaoImpl.modify(fans);
		return 0;
		*/
	}

	/*
	 * 检查fans的所有专注的转辑是否有更新
	 * 【提示】新的消息系统，该方法已弃用！！！！
	 */
	@ResponseBody
	@RequestMapping(value = "/checkUpdates/{sta}")
	@Token(ajax = true,csrf=true,contrast = true, login = true, failedPage = LOGINPAGE)
	public int checkUpdates(@PathVariable(value = "sta", required = false) Integer sta, HttpServletRequest request) {
		return -1;
		/*
		long uid = LoginUtil.uid(messageSource, request);
		User user = userDaoImpl.findByID(uid);
		if (user == null) {
			return -201; //未登录
		}
		List<AlbumFans> list = albumFansDaoImpl.findByUid(uid);
		int rn = 0;
		boolean forcon = true;
		for (AlbumFans fans : list) {
			long newids = albumArticleDaoImpl.countAfterArticleID(fans.getLastViewedID());
			
			switch (sta) {
			case 1:			//每个关注的更新，只有更新+1，最终返回的是有多少个有更新的专辑
				if (newids>0) {
					rn++;
				}
				break;
			case 2:
				if (newids>0) {		//每个关心的更新的文章数，最终返回的是所有更新的专辑更新的文章总数
					rn += newids;
				}
				break;
			default:		//默认，只要有更新就退出，返回1
				if (newids>0) {
					forcon=false;
					rn=1;
				}

			}
			if (!forcon) {
				break;
			}
		}
		
		return rn;
		
		*/

	}

}
