package com.lerx.handlers;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.lerx.annotation.Token;
import com.lerx.dao.iface.IAlbumArticleDao;
import com.lerx.dao.iface.IAlbumDao;
import com.lerx.dao.iface.IAlbumPartnerDao;
import com.lerx.dao.iface.ITeamDao;
import com.lerx.dao.iface.IUserDao;
import com.lerx.entities.Album;
import com.lerx.entities.AlbumPartner;
import com.lerx.entities.Team;
import com.lerx.entities.User;
import com.lerx.login.util.LoginUtil;
import com.lerx.portal.obj.SimplePartner;
import com.lerx.v6.util.AlbumUtil;
import com.lerx.v6.util.PartnerUtil;

@RequestMapping("/action_album_partner")
@Controller
public class AlbumPartnerHandler {
	
	@Autowired
	private IAlbumDao albumDaoImpl;
	
	@Autowired
	private IUserDao userDaoImpl;
	
	@Autowired
	private IAlbumPartnerDao albumPartnerDaoImpl;
	
	@Autowired
	private IAlbumArticleDao albumArticleDaoImpl;
	
	@Autowired
	private ITeamDao TeamDaoImpl;
	
	
	@Autowired
	private ResourceBundleMessageSource messageSource;
	
	private static final String FORBIDU = "jsp/result/forbidu";
	
	@RequestMapping(value = {"/list/{albid}","/list/{albid}/{lookOnly}"})
	@Token(ajax=false,login=true, csrf = true, contrast = true,failedPage=FORBIDU)
	public String list(@PathVariable(value = "albid", required = true) Long albid,@PathVariable(value = "lookOnly", required = false) Integer lookOnly,HttpServletRequest request, HttpSession session,Map<String, Object> map) {
		if (lookOnly==null) {
			lookOnly=0;
		}
		long uid = LoginUtil.uid(messageSource, request);
		Album album = albumDaoImpl.findByID(albid);
		if (album == null  || album.isDeled() || !album.isStatus() || !PartnerUtil.basicPowerChk(uid, album, albumPartnerDaoImpl) ) {
			return FORBIDU;
		}
		
		if (AlbumUtil.isLeader(album, uid, albumPartnerDaoImpl)) {
			lookOnly=0;
		}else {
			lookOnly=1;
		}
		
		List<AlbumPartner> listAP=albumPartnerDaoImpl.queryByAid(albid);
		for (AlbumPartner ap:listAP) {
			if (ap.getUser().getNickname()==null || ap.getUser().getNickname().trim().equals("")) {
				ap.getUser().setNickname(ap.getUser().getUsername());
			}
		}
		map.put("album", album);
		map.put("list", listAP);
		map.put("lookOnly", lookOnly);
		map.put("gfree", album.getGenre().isFree());
		return "jsp/album/control/partner";
		
		
	}
	
	@ResponseBody
	@RequestMapping(value = "/add/{albid}/{uid}")
	@Token(ajax=true,csrf=true,contrast = true,login=true,log = true,mark = "album-partner--<add>")
	public int add(@PathVariable(value = "albid", required = true) Long albid,@PathVariable(value = "uid", required = true) Long uid,HttpServletRequest request, HttpSession session,Map<String, Object> map) {
		long curruid = LoginUtil.uid(messageSource, request);
		Album album = albumDaoImpl.findByID(albid);
		if (album == null  || album.isDeled() || !album.isStatus()) {
			return -400;
		}
		if (!AlbumUtil.isLeader(album, curruid, albumPartnerDaoImpl)) {
			return -200;
		}
		
		if (album.getLeader().getId()==uid) {
			return -502;
		}
		
		List<AlbumPartner> listAP=albumPartnerDaoImpl.queryByAid(albid);
		for (int i=0;i<listAP.size();i++) {
			AlbumPartner partner = listAP.get(i);
			if (partner.getUser().getId()==uid) {
				return -502;
			}
		}
		
		
		User user=userDaoImpl.findByID(uid);
		if (user==null) {
			return -405;
		}
		AlbumPartner partner =new AlbumPartner();
		
		partner.setAlbum(album);
		partner.setStatus(true);
		partner.setUser(user);
		partner.setApplyTime(System.currentTimeMillis());
		albumPartnerDaoImpl.add(partner);
		
		album.setTotalPartner(albumPartnerDaoImpl.countByAlbumID(album.getId()));
		albumDaoImpl.modify(album);
		teamUpdate(album);
		return 0;
	}
	
	
	@ResponseBody
	@RequestMapping(value = "/del/{pid}")
	@Token(ajax=true,csrf=true,contrast = true,login=true,log = true,mark = "album-partner--<del>")
	public int del(@PathVariable(value = "pid", required = true) Long pid,HttpServletRequest request, HttpSession session,Map<String, Object> map) {
		AlbumPartner partner = albumPartnerDaoImpl.findByID(pid);
		if (partner==null) {
			return -404;
		}
		long curruid = LoginUtil.uid(messageSource, request);
		Album album = partner.getAlbum();
		if (album == null  || album.isDeled() || !album.isStatus()) {
			return -400;
		}
		if (!AlbumUtil.isLeader(album, curruid, albumPartnerDaoImpl)) {
			return -200;
		}
		
		if (partner.getUser().getId()==curruid) {
			return -403;
		}
		albumPartnerDaoImpl.delByID(pid);
		
		
		teamUpdate(album);
		
		album.setTotalPartner(albumPartnerDaoImpl.countByAlbumID(album.getId()));
		albumDaoImpl.modify(album);
		
		return 0;
	}
	
	
	@ResponseBody
	@RequestMapping(value = "/lead/{pid}/{sta}")
	@Token(ajax=true,csrf=true,contrast = true,login=true,log = true,mark = "album-partner--<lead>")
	public int lead(@PathVariable(value = "pid", required = true) Long pid,@PathVariable(value = "sta", required = true) Integer sta,HttpServletRequest request, HttpSession session,Map<String, Object> map) {
		AlbumPartner partner = albumPartnerDaoImpl.findByID(pid);
		if (partner==null) {
			return -404;
		}
		long curruid = LoginUtil.uid(messageSource, request);
		Album album = partner.getAlbum();
		if (album == null  || album.isDeled() || !album.isStatus()) {
			return -400;
		}
		if (album.getLeader().getId() != curruid) {
			return -200;
		}
		if (sta==1) {
			albumPartnerDaoImpl.excuteLead(pid, true);
		}else {
			albumPartnerDaoImpl.excuteLead(pid, false);
		}
		
		
		return 0;
	}
	
	@ResponseBody
	@RequestMapping(value = "/checker/{pid}/{sta}")
	@Token(ajax=true,csrf=true,contrast = true,login=true,log = true,mark = "album-partner--<checker>")
	public int checker(@PathVariable(value = "pid", required = true) Long pid,@PathVariable(value = "sta", required = true) Integer sta,HttpServletRequest request, HttpSession session,Map<String, Object> map) {
		AlbumPartner partner = albumPartnerDaoImpl.findByID(pid);
		if (partner==null) {
			return -404;
		}
		long curruid = LoginUtil.uid(messageSource, request);
		Album album = partner.getAlbum();
		if (album == null  || album.isDeled() || !album.isStatus()) {
			return -400;
		}
		boolean admin=AlbumUtil.isLeader(album, curruid, albumPartnerDaoImpl);
		if (!admin) {
			return -200;
		}
		if (sta==1) {
			partner.setChecker(true);
		}else {
			partner.setChecker(false);
		}
		albumPartnerDaoImpl.modify(partner);
		return 0;
	}
	
	private void teamUpdate(Album album) {
		List<AlbumPartner> listAP=albumPartnerDaoImpl.queryByAid(album.getId());
		String userteam=album.getLeader().getId()+",";
		for (int i=0;i<listAP.size();i++) {
			AlbumPartner p = listAP.get(i);
			userteam+=p.getUser().getId()+",";
		}
		
		Team team=album.getCb().getObjTeam();
		team.setUidstr(userteam);
		TeamDaoImpl.modify(team);
	}
	
	//自己退出
	@ResponseBody
	@RequestMapping(value = "/secede/{aid}")
	@Token(ajax=true,csrf=true,contrast = true,login=true,log = true,mark = "album-partner--<secede>")
	public int secede(@PathVariable(value = "aid", required = true) Long aid,HttpServletRequest request, HttpSession session,Map<String, Object> map) {
		Album album = albumDaoImpl.findByID(aid);
		if (album==null) {
			return -400;
		}
		long curruid = LoginUtil.uid(messageSource, request);
		if (curruid<=0) {
			return -201;
		}
		
		AlbumPartner partner =albumPartnerDaoImpl.findByAIDAndUid(aid, curruid);
		if (partner==null) {
			return -404;
		}
		if (partner.getUser().getId() != curruid) {
			return -406;
		}
		
		albumPartnerDaoImpl.delByID(partner.getId());
		
		album.setTotalPartner(albumPartnerDaoImpl.countByAlbumID(album.getId()));
		albumDaoImpl.modify(album);
		
		return 0;
	}
	
	
	
	//列出所有成员 0 是专辑主人
	@ResponseBody
	@RequestMapping(value = "/all/{aid}")
	@Token(ajax=true, csrf = true, contrast = true,login=true)
	public List<SimplePartner> simpleall(@PathVariable(value = "aid", required = true) Long aid,HttpServletRequest request, HttpSession session,Map<String, Object> map) {
		return PartnerUtil.query(aid, albumDaoImpl, albumArticleDaoImpl, albumPartnerDaoImpl);
		
		/*
		 * Album album = albumDaoImpl.findByID(aid); if (album == null ||
		 * album.isDeled() || !album.isStatus()) { return null; }
		 * 
		 * List<SimplePartner> lr=new ArrayList<SimplePartner>(); SimplePartner partner
		 * = new SimplePartner(); partner.setUid(album.getLeader().getId());
		 * partner.setUsername(album.getLeader().getUsername()); partner.setTab(0);
		 * partner.setNickname(album.getLeader().getNickname()); long
		 * countarts=albumArticleDaoImpl.countByAlbumIDAndOwnUID(aid,
		 * album.getLeader().getId(),false);
		 * partner.setArts(Integer.valueOf(String.valueOf(countarts))); long
		 * countsouls=albumArticleDaoImpl.countByAlbumIDAndOwnUID(aid,
		 * album.getLeader().getId(),true);
		 * partner.setSouls(Integer.valueOf(String.valueOf(countsouls)));
		 * lr.add(partner); List<AlbumPartner>
		 * listAP=albumPartnerDaoImpl.queryByAid(aid); for (int i=0;i<listAP.size();i++)
		 * { AlbumPartner ap = listAP.get(i); partner = new SimplePartner();
		 * partner.setUid(ap.getUser().getId());
		 * partner.setUsername(ap.getUser().getUsername()); partner.setTab(1);
		 * partner.setNickname(ap.getUser().getNickname());
		 * countarts=albumArticleDaoImpl.countByAlbumIDAndOwnUID(aid,
		 * ap.getUser().getId(),false);
		 * partner.setArts(Integer.valueOf(String.valueOf(countarts)));
		 * countsouls=albumArticleDaoImpl.countByAlbumIDAndOwnUID(aid,
		 * ap.getUser().getId(),true);
		 * partner.setSouls(Integer.valueOf(String.valueOf(countsouls)));
		 * lr.add(partner); } return lr;
		 */
		
	}

}
