package com.lerx.handlers;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.lerx.annotation.Token;
import com.lerx.app.util.SafeStrUtil;
import com.lerx.dao.iface.IPortalDao;
import com.lerx.dao.iface.IUserDao;
import com.lerx.entities.Portal;
import com.lerx.portal.obj.ResultColle;
import com.lerx.sys.obj.Website;
import com.lerx.sys.util.RandomNumUtil;
import com.lerx.sys.util.SecurityUtil;
import com.lerx.sys.util.StringUtil;
import com.lerx.v6.util.CaptchaUtil;
import com.lerx.v6.util.ConfigUtil;
import com.lerx.v6.util.PortalUtil;

/*
 * 验证码
 */
@RequestMapping("/action_captcha")
@Controller
public class CaptchaHandler {
	
	@Autowired
	private ResourceBundleMessageSource messageSource;
	
	

	@Autowired
	private IPortalDao portalDaoImpl;
	
	@Autowired
	private IUserDao userDaoImpl;
	
	@Value("${mail.server.config.success:false}")
	private String mailSrvConfigSuccess;
	
	@Value("${sms.server.config.success:false}")
	private String smsSrvConfigSuccess;
	
	
	@RequestMapping("/randomNum")
	@Token(ajax=false,csrf=true,contrast = true)
	public void randomNum(HttpServletRequest request,HttpServletResponse response,HttpSession session,String key,@RequestParam(value = "time", required = false) Long time) throws Exception{
		
		String captchaMode = messageSource.getMessage("captcha.mode", null, "blend", null);
		int imgMode;
		if (captchaMode.trim().equalsIgnoreCase("words")){	//
			imgMode=2;
		}else if (captchaMode.trim().equalsIgnoreCase("number")){
			imgMode=1;
		}else{
			imgMode=0;
		}
		
		RandomNumUtil randomNum = new RandomNumUtil(response,60,18,4,18,imgMode);
		String  safeSessionStr=SafeStrUtil.getstr(messageSource, request,key);
		session.setAttribute(safeSessionStr, randomNum.getRandomCode());
		
	}
	
	
	@RequestMapping("/send")
	@ResponseBody
	@Token(ajax=true,csrf=true,contrast = true,log=true,mark = "captcha--<send>")
	public int send(String target,@RequestParam(value = "mode", required = false) Integer mode,@RequestParam(value = "lookup", required = false) Integer lookup,HttpServletRequest request,HttpServletResponse response,HttpSession session) throws Exception{
		/*
		if (session.getAttribute("vcodeSendDt") != null) {
			long lastSentDt=(long) session.getAttribute("vcodeSendDt");
			if (System.currentTimeMillis() - lastSentDt < (1000*60*5)) {
				return -409;
			}
		}
		*/
		/*
		 * mode & sendM
		 * mode 0:email
		 * mode 1:phone
		 */
		int sendM = -1;
		Portal portal=portalDaoImpl.query_update();
		if (mode!=null) {
			sendM=mode;
		}
		if (sendM == -1) {
			
			if (portal.getCodeSendMode()==0) {	//如果验证码发向邮箱
				if (!mailSrvConfigSuccess.trim().equalsIgnoreCase("true")) {
					return -421;
				}
				sendM=0;
				if (target == null || !StringUtil.emailTest(target)) {
					return -400;
				}
				if (!ConfigUtil.mailChk(messageSource, target)) {
					return -403;
				}
			}else {//如果发向手机
				if (!smsSrvConfigSuccess.trim().equalsIgnoreCase("true")) {
					return -421;
				}
				sendM=1;
				if (!StringUtil.phoneTest(target.trim())) {
					return -400;
				}
			}
		}
		
		if (lookup==null) {
			lookup=0;
		}
		
		if (lookup > 0) {
			if (sendM==1) {	//查找手机
				if (userDaoImpl.findByMobile(target, 0) != null) {
					return -502;
				}
			}else {			//查找邮箱
				if (userDaoImpl.findByEmail(target, 0) != null) {
					return -502;
				}
			}
		}
		
		
		Website site = PortalUtil.lead(portal);
		String charset = messageSource.getMessage("charset", null, "UTF-8", null);
		int r=CaptchaUtil.send(messageSource, request, session,site, sendM, target,"default",charset);
		if (r>=0) {
//			session.setAttribute("sendTarget", target);
			session.setAttribute("targetMode", sendM);
			//session.setAttribute("vcodeSendDt", System.currentTimeMillis());
		} 
		return r;
	}
	
	
	@ResponseBody
	@RequestMapping("/validate")
	@Token(ajax=true,csrf=true,contrast = true)
	public ResultColle validate(String vcode,String target,HttpServletRequest request,HttpServletResponse response,HttpSession session) throws Exception{
		
		ResultColle rc=new ResultColle();
		rc.setCode(CaptchaUtil.valid(messageSource,vcode,target,"default",session));
		String salt = StringUtil.randomString(6);
		
		String securityStr = SecurityUtil.readWords(messageSource);
		String encryptStr = StringUtil.md5(StringUtil.md5(securityStr).toLowerCase().concat(salt)).toLowerCase();
		
		rc.setSalt(salt);
		rc.setEncryptStr(encryptStr);
		
		return rc;
		
		
	}
	
		
}
