package com.lerx.handlers;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.lerx.annotation.Token;
import com.lerx.dao.iface.IAlbumDao;
import com.lerx.dao.iface.IAlbumFansDao;
import com.lerx.dao.iface.IAlbumPartnerDao;
import com.lerx.dao.iface.IFansGroupDao;
import com.lerx.dao.iface.IUserDao;
import com.lerx.entities.Album;
import com.lerx.entities.AlbumFans;
import com.lerx.entities.FansGroup;
import com.lerx.entities.User;
import com.lerx.login.util.LoginUtil;
import com.lerx.v6.util.PartnerUtil;

@RequestMapping("/action_fans_group")
@Controller
public class FansGroupHandler {
	
	private static final String SUCCESS = "jsp/result/success";
	private static final String FAILED = "jsp/result/failed";
	private static final String LOGINPAGE = "jsp/user/login";
	
	@Autowired
	private IFansGroupDao fansGroupDaoImpl;
	
	@Autowired
	private IAlbumDao albumDaoImpl;
	
	@Autowired
	private IUserDao userDaoImpl;
	
	@Autowired
	private IAlbumPartnerDao albumPartnerDaoImpl;
	
	@Autowired
	private IAlbumFansDao albumFansDaoImpl;
	
	@Autowired
	private ResourceBundleMessageSource messageSource;
	
	@ResponseBody
	@RequestMapping(value = "/add/{aid}")
	@Token(ajax = true,csrf=true,contrast = true, log = true, mark = "album-fans-group--<add>", login = true)
	public int add(@PathVariable(value = "aid", required = true) Long aid,String name, HttpServletRequest request) {
		if (fansGroupDaoImpl.findByName(aid, name,0)!=null) {
			return -420;
		}else {
			Album album=albumDaoImpl.findByID(aid);
			if (album==null) {
				return -400;
			}
			
			long uid = LoginUtil.uid(messageSource, request);
			User user = userDaoImpl.findByID(uid);
			
			if (!PartnerUtil.basicPowerChk(uid, album, albumPartnerDaoImpl)) {
				return -200;
			}
			
			FansGroup fg=new FansGroup();
			fg.setDeled(false);
			fg.setAlbum(album);
			fg.setCreationDt(System.currentTimeMillis());
			fg.setName(name);
			fg.setFounder(user);
			
			fansGroupDaoImpl.add(fg);
			return 0;
			
		}
		
	}
	
	@ResponseBody
	@RequestMapping(value = "/chgname/{id}")
	@Token(ajax = true,csrf=true,contrast = true, log = true, mark = "album-fans-group--<chgname>", login = true)
	public int chgname(@PathVariable(value = "id", required = true) Long id,String name, HttpServletRequest request) {
		FansGroup fg=fansGroupDaoImpl.findByID(id);
		FansGroup fgsame=fansGroupDaoImpl.findByName(fg.getAlbum().getId(), name, fg.getId());
		if (fgsame!=null) {
			return -420;
		}
		
		long uid = LoginUtil.uid(messageSource, request);
		if (uid!=fg.getFounder().getId()) {
			return -200;
		}
		fg.setName(name);
		fansGroupDaoImpl.modify(fg);
		return 0;
	}
	
	@ResponseBody
	@RequestMapping(value = "/del/{id}")
	@Token(ajax = true,csrf=true,contrast = true, log = true, mark = "album-fans-group--<chgname>", login = true)
	public int del(@PathVariable(value = "id", required = true) Long id, HttpServletRequest request) {
		long uid = LoginUtil.uid(messageSource, request);
		FansGroup fg=fansGroupDaoImpl.findByID(id);
		
		if (uid!=fg.getFounder().getId()) {
			return -200;
		}
		List<AlbumFans> list=albumFansDaoImpl.findByGid(fg.getId());
		if (list!=null && !list.isEmpty() && list.size()>0) {
			return -501;
		}
		fansGroupDaoImpl.delByID(id);
		return 0;
	}
	
	
	@RequestMapping("/list/{aid}/{fid}")
	@Token(ajax = false,csrf=true,contrast = true, login = true, failedPage = FAILED, msgKey = "fail.permission",failedReturnUrl = LOGINPAGE)
	public String list(@PathVariable(value = "aid", required = true) Long aid,@PathVariable(value = "fid", required = true) Long fid,HttpSession session,
			 HttpServletRequest request,Map<String, Object> map) {
		long uid = LoginUtil.uid(messageSource, request);
		List<FansGroup> list=fansGroupDaoImpl.find(uid, 1);
		map.put("list", list);
		map.put("aid", aid);
		map.put("uid", uid);
		map.put("fid", fid);
		
		AlbumFans  fans=albumFansDaoImpl.findByID(fid);
		FansGroup fg= fans.getFg();
		if (fg==null) {
			map.put("currgid", 0);
		}else {
			map.put("currgid", fg.getId());
		}
		return "jsp/album/fansgroup/list";
		
	}
	
	@RequestMapping(value = "/select/{fid}")
	@Token(ajax = true,csrf=true,contrast = true, log = true, mark = "album-fans-group--<chgname>", login = true)
	public String select(@PathVariable(value = "fid", required = true) Long fid,Long fgid, HttpServletRequest request) {
		long uid = LoginUtil.uid(messageSource, request);
		FansGroup fg=fansGroupDaoImpl.findByID(fgid);
		AlbumFans  fans=albumFansDaoImpl.findByID(fid);
		if (uid!=fans.getUser().getId()) {
			return FAILED;
		}
		
		fans.setFg(fg);
		
		albumFansDaoImpl.modify(fans);
		return SUCCESS;
	}
	

}
